/*
 * Decompiled with CFR 0.152.
 */
package ome.parameters;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.parameters.Filter;
import ome.parameters.Options;
import ome.parameters.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
implements Serializable {
    public static final String ID = "id";
    public static final String IDS = "ids";
    public static final String CLASS = "class";
    public static final String ALGORITHM = "algorithm";
    public static final String OWNER_ID = "ownerId";
    public static final String GROUP_ID = "groupId";
    private Filter filter;
    private Options options;
    private transient Map queryParameters = new HashMap();
    private static final long serialVersionUID = 6428983610525830551L;

    public Parameters() {
    }

    public Parameters(Filter filter) {
        this.filter = filter;
    }

    public Parameters(Parameters old) {
        if (old == null) {
            return;
        }
        this.addAll(old);
    }

    public Parameters(QueryParameter[] queryParameters) {
        this.addAll(queryParameters);
    }

    public QueryParameter[] queryParameters() {
        return this.queryParameters.values().toArray(new QueryParameter[this.queryParameters.size()]);
    }

    public QueryParameter get(String name) {
        return (QueryParameter)this.queryParameters.get(name);
    }

    public Set<String> keySet() {
        return new HashSet<String>(this.queryParameters.keySet());
    }

    public Parameters setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Parameters setOptions(Options options) {
        this.options = options;
        return this;
    }

    public Parameters add(QueryParameter parameter) {
        if (parameter == null) {
            throw new ApiUsageException("Parameter argument may not be null.");
        }
        this.queryParameters.put(parameter.name, parameter);
        return this;
    }

    public Parameters addAll(Parameters old) {
        if (old == null) {
            throw new ApiUsageException("Parameters argument may not be null.");
        }
        if (old.filter != null) {
            if (this.filter != null) {
                throw new ApiUsageException("Two filters not allowed during copy constructor.");
            }
            this.filter = old.filter;
        }
        if (old.options != null) {
            if (this.options != null) {
                throw new ApiUsageException("Two options not allowed during copy constructor.");
            }
            this.options = old.options;
        }
        return this.addAll(old.queryParameters());
    }

    public Parameters addAll(QueryParameter[] queryParameters) {
        if (queryParameters == null) {
            throw new ApiUsageException("Array of QueryParameters may not be null.");
        }
        for (int i = 0; i < queryParameters.length; ++i) {
            this.add(queryParameters[i]);
        }
        return this;
    }

    public Parameters addClass(Class klass) {
        this.addClass(CLASS, klass);
        return this;
    }

    public Parameters addClass(String name, Class value) {
        this.add(new QueryParameter(name, Class.class, value));
        return this;
    }

    public Parameters addBoolean(String name, Boolean value) {
        this.add(new QueryParameter(name, Boolean.class, value));
        return this;
    }

    public Parameters addInteger(String name, Integer value) {
        this.add(new QueryParameter(name, Integer.class, value));
        return this;
    }

    public Parameters addLong(String name, Long value) {
        this.add(new QueryParameter(name, Long.class, value));
        return this;
    }

    public Parameters addSet(String name, Set value) {
        this.add(new QueryParameter(name, Set.class, value));
        return this;
    }

    public Parameters addList(String name, List value) {
        this.add(new QueryParameter(name, List.class, value));
        return this;
    }

    public Parameters addMap(String name, Map value) {
        this.add(new QueryParameter(name, Map.class, value));
        return this;
    }

    public Parameters addString(String name, String value) {
        this.add(new QueryParameter(name, String.class, value));
        return this;
    }

    public Parameters addId(Long id) {
        this.add(new QueryParameter(ID, Long.class, id));
        return this;
    }

    public Parameters addIds(Collection ids) {
        this.add(new QueryParameter(IDS, Collection.class, ids));
        return this;
    }

    public Parameters addAlgorithm(String algo) {
        this.addString(ALGORITHM, algo);
        return this;
    }

    public Parameters exp(long id) {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.owner(id);
        return this;
    }

    public Parameters allExps() {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.owner(-1L);
        return this;
    }

    public long owner() {
        if (this.filter != null) {
            return this.filter.owner();
        }
        return -1L;
    }

    public boolean isExperimenter() {
        if (this.filter != null) {
            return this.filter.owner() != -1L;
        }
        return false;
    }

    public Long getExperimenter() {
        long o = this.owner();
        if (o == -1L) {
            return null;
        }
        return o;
    }

    public Parameters grp(long id) {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.group(id);
        return this;
    }

    public long group() {
        if (this.filter != null) {
            return this.filter.group();
        }
        return -1L;
    }

    public Long getGroup() {
        long g = this.group();
        if (g == -1L) {
            return null;
        }
        return g;
    }

    public boolean isGroup() {
        if (this.filter != null) {
            return this.filter.group() != -1L;
        }
        return false;
    }

    public Parameters startTime(Timestamp timestamp) {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.startTime = timestamp;
        return this;
    }

    public Timestamp getStartTime() {
        if (this.filter != null) {
            return this.filter.startTime;
        }
        return null;
    }

    public Parameters endTime(Timestamp timestamp) {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.endTime = timestamp;
        return this;
    }

    public Timestamp getEndTime() {
        if (this.filter != null) {
            return this.filter.endTime;
        }
        return null;
    }

    public Parameters paginate(Integer offset, Integer limit) {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.limit = limit;
        this.filter.offset = offset;
        return this;
    }

    public Integer getLimit() {
        if (this.filter != null) {
            return this.filter.limit;
        }
        return null;
    }

    public Integer getOffset() {
        if (this.filter != null) {
            return this.filter.offset;
        }
        return null;
    }

    public boolean isPagination() {
        if (this.filter != null) {
            return this.filter.offset != null || this.filter.limit != null;
        }
        return false;
    }

    public Parameters page(Integer offset, Integer limit) {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.limit = limit;
        this.filter.offset = offset;
        return this;
    }

    public Parameters unique() {
        if (this.filter == null) {
            this.filter = new Filter();
        }
        this.filter.unique();
        return this;
    }

    public boolean isUnique() {
        if (this.filter != null) {
            return this.filter.isUnique();
        }
        return false;
    }

    public boolean isAcquisitionData() {
        if (this.options != null) {
            return this.options.acquisitionData;
        }
        return false;
    }

    public boolean isLeaves() {
        if (this.options != null) {
            return this.options.leaves;
        }
        return false;
    }

    public Parameters leaves() {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.leaves = true;
        return this;
    }

    public Parameters noLeaves() {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.leaves = false;
        return this;
    }

    public Parameters orphan() {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.orphan = true;
        return this;
    }

    public Parameters noOrphan() {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.orphan = false;
        return this;
    }

    public boolean isOrphan() {
        if (this.options != null) {
            return this.options.orphan;
        }
        return false;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.queryParameters = new HashMap();
        for (int i = 0; i < size; ++i) {
            this.add((QueryParameter)s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Set keySet = this.queryParameters.keySet();
        s.writeInt(keySet.size());
        for (String key : keySet) {
            s.writeObject(this.queryParameters.get(key));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PARAMS");
        if (this.filter != null) {
            sb.append(":");
            sb.append(this.filter);
        }
        if (this.options != null) {
            sb.append(":");
            sb.append(this.options);
        }
        if (this.queryParameters != null && this.queryParameters.size() > 0) {
            sb.append(":");
            for (Object obj : this.queryParameters.values()) {
                QueryParameter qp = (QueryParameter)obj;
                sb.append(qp.name);
                sb.append("=");
                if (qp.value == null) {
                    sb.append(" ");
                    continue;
                }
                Class<?> k = qp.value.getClass();
                if (Collection.class.isAssignableFrom(k)) {
                    sb.append(k.getSimpleName());
                    sb.append("(");
                    sb.append(((Collection)qp.value).size());
                    sb.append(")");
                } else if (Map.class.isAssignableFrom(k)) {
                    sb.append("map(");
                    sb.append(((Map)qp.value).size());
                    sb.append(")");
                } else {
                    sb.append(qp.value);
                }
                sb.append(" ");
            }
        }
        return sb.toString();
    }
}

