/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.LightSource;
import ome.model.enums.LaserMedium;
import ome.model.enums.LaserType;
import ome.model.enums.Pulse;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@PrimaryKeyJoinColumn(name="lightsource_id")
@Table(name="laser")
@ForeignKey(name="FKlaser_lightsource_id_lightsource")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
@Check(constraints="frequencyMultiplication > 0 and wavelength > 0")
public class Laser
extends LightSource
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "laser_owner_filter";
    public static final String GROUP_FILTER = "laser_group_filter";
    public static final String EVENT_FILTER = "laser_event_filter";
    public static final String PERMS_FILTER = "laser_perms_filter";
    protected LaserType type = null;
    protected LaserMedium laserMedium = null;
    protected Integer frequencyMultiplication = null;
    protected Boolean tuneable = null;
    protected Pulse pulse = null;
    protected Integer wavelength = null;
    protected Boolean pockelCell = null;
    protected LightSource pump = null;
    protected Double repetitionRate = null;
    public static final String TYPE = "ome.model.acquisition.Laser_type";
    public static final String LASERMEDIUM = "ome.model.acquisition.Laser_laserMedium";
    public static final String FREQUENCYMULTIPLICATION = "ome.model.acquisition.Laser_frequencyMultiplication";
    public static final String TUNEABLE = "ome.model.acquisition.Laser_tuneable";
    public static final String PULSE = "ome.model.acquisition.Laser_pulse";
    public static final String WAVELENGTH = "ome.model.acquisition.Laser_wavelength";
    public static final String POCKELCELL = "ome.model.acquisition.Laser_pockelCell";
    public static final String PUMP = "ome.model.acquisition.Laser_pump";
    public static final String REPETITIONRATE = "ome.model.acquisition.Laser_repetitionRate";
    public static final Set<String> FIELDS;

    public Laser() {
        this(null, true);
    }

    protected Laser(Long id) {
        this(id, true);
    }

    public Laser(Long id, boolean loaded) {
        super(id, loaded);
    }

    public Laser(LaserType _type, LaserMedium _laserMedium) {
        this(null, true);
        this.setType(_type);
        this.setLaserMedium(_laserMedium);
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=LaserType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlaser_type_lasertype")
    public LaserType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(LaserType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=LaserMedium.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="laserMedium", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlaser_laserMedium_lasermedium")
    public LaserMedium getLaserMedium() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.laserMedium;
    }

    public void setLaserMedium(LaserMedium laserMedium) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.laserMedium = laserMedium;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="frequencyMultiplication", updatable=true)
    public Integer getFrequencyMultiplication() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.frequencyMultiplication;
    }

    public void setFrequencyMultiplication(Integer frequencyMultiplication) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.frequencyMultiplication = frequencyMultiplication;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="tuneable", updatable=true)
    public Boolean getTuneable() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.tuneable;
    }

    public void setTuneable(Boolean tuneable) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.tuneable = tuneable;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Pulse.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pulse", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlaser_pulse_pulse")
    public Pulse getPulse() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pulse;
    }

    public void setPulse(Pulse pulse) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pulse = pulse;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="wavelength", updatable=true)
    public Integer getWavelength() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.wavelength;
    }

    public void setWavelength(Integer wavelength) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.wavelength = wavelength;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="pockelCell", updatable=true)
    public Boolean getPockelCell() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pockelCell;
    }

    public void setPockelCell(Boolean pockelCell) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pockelCell = pockelCell;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=LightSource.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pump", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlaser_pump_lightsource")
    public LightSource getPump() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pump;
    }

    public void setPump(LightSource pump) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pump = pump;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="repetitionRate", updatable=true)
    public Double getRepetitionRate() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.repetitionRate;
    }

    public void setRepetitionRate(Double repetitionRate) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.repetitionRate = repetitionRate;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Laser newInstance() {
        return new Laser();
    }

    public Laser proxy() {
        return new Laser(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.type = (LaserType)__filter.filter(TYPE, this.type);
            this.laserMedium = (LaserMedium)__filter.filter(LASERMEDIUM, this.laserMedium);
            this.frequencyMultiplication = (Integer)__filter.filter(FREQUENCYMULTIPLICATION, this.frequencyMultiplication);
            this.tuneable = (Boolean)__filter.filter(TUNEABLE, this.tuneable);
            this.pulse = (Pulse)__filter.filter(PULSE, this.pulse);
            this.wavelength = (Integer)__filter.filter(WAVELENGTH, this.wavelength);
            this.pockelCell = (Boolean)__filter.filter(POCKELCELL, this.pockelCell);
            this.pump = (LightSource)__filter.filter(PUMP, this.pump);
            this.repetitionRate = (Double)__filter.filter(REPETITIONRATE, this.repetitionRate);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(LASERMEDIUM)) {
            return this.getLaserMedium();
        }
        if (field.equals(FREQUENCYMULTIPLICATION)) {
            return this.getFrequencyMultiplication();
        }
        if (field.equals(TUNEABLE)) {
            return this.getTuneable();
        }
        if (field.equals(PULSE)) {
            return this.getPulse();
        }
        if (field.equals(WAVELENGTH)) {
            return this.getWavelength();
        }
        if (field.equals(POCKELCELL)) {
            return this.getPockelCell();
        }
        if (field.equals(PUMP)) {
            return this.getPump();
        }
        if (field.equals(REPETITIONRATE)) {
            return this.getRepetitionRate();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TYPE)) {
            this.setType((LaserType)value);
        } else if (field.equals(LASERMEDIUM)) {
            this.setLaserMedium((LaserMedium)value);
        } else if (field.equals(FREQUENCYMULTIPLICATION)) {
            this.setFrequencyMultiplication((Integer)value);
        } else if (field.equals(TUNEABLE)) {
            this.setTuneable((Boolean)value);
        } else if (field.equals(PULSE)) {
            this.setPulse((Pulse)value);
        } else if (field.equals(WAVELENGTH)) {
            this.setWavelength((Integer)value);
        } else if (field.equals(POCKELCELL)) {
            this.setPockelCell((Boolean)value);
        } else if (field.equals(PUMP)) {
            this.setPump((LightSource)value);
        } else if (field.equals(REPETITIONRATE)) {
            this.setRepetitionRate((Double)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.type = null;
        this.laserMedium = null;
        this.frequencyMultiplication = null;
        this.tuneable = null;
        this.pulse = null;
        this.wavelength = null;
        this.pockelCell = null;
        this.pump = null;
        this.repetitionRate = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TYPE);
        raw.addAll(LightSource.FIELDS);
        raw.add(LASERMEDIUM);
        raw.addAll(LightSource.FIELDS);
        raw.add(FREQUENCYMULTIPLICATION);
        raw.addAll(LightSource.FIELDS);
        raw.add(TUNEABLE);
        raw.addAll(LightSource.FIELDS);
        raw.add(PULSE);
        raw.addAll(LightSource.FIELDS);
        raw.add(WAVELENGTH);
        raw.addAll(LightSource.FIELDS);
        raw.add(POCKELCELL);
        raw.addAll(LightSource.FIELDS);
        raw.add(PUMP);
        raw.addAll(LightSource.FIELDS);
        raw.add(REPETITIONRATE);
        raw.addAll(LightSource.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

