/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import java.io.Serializable;
import org.apache.commons.math.optimization.VectorialConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;

public class SimpleVectorialValueChecker
implements VectorialConvergenceChecker,
Serializable {
    private static final long serialVersionUID = -3892196630780700808L;
    private static final double DEFAULT_RELATIVE_THRESHOLD = (double)1.110223E-14f;
    private static final double DEFAULT_ABSOLUTE_THRESHOLD = 2.2250738585072014E-306;
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public SimpleVectorialValueChecker() {
        this.relativeThreshold = 1.110223E-14f;
        this.absoluteThreshold = 2.2250738585072014E-306;
    }

    public SimpleVectorialValueChecker(double relativeThreshold, double absoluteThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.absoluteThreshold = absoluteThreshold;
    }

    public boolean converged(int iteration, VectorialPointValuePair previous, VectorialPointValuePair current) {
        double[] p = previous.getValueRef();
        double[] c = current.getValueRef();
        for (int i = 0; i < p.length; ++i) {
            double size;
            double pi = p[i];
            double ci = c[i];
            double difference = Math.abs(pi - ci);
            if (!(difference > (size = Math.max(Math.abs(pi), Math.abs(ci))) * this.relativeThreshold) || !(difference > this.absoluteThreshold)) continue;
            return false;
        }
        return true;
    }
}

