/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import java.util.Arrays;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.UnivariateRealOptimizer;
import org.apache.commons.math.random.RandomGenerator;

public class MultiStartUnivariateRealOptimizer
implements UnivariateRealOptimizer {
    private static final long serialVersionUID = 5983375963110961019L;
    private final UnivariateRealOptimizer optimizer;
    private int maxIterations;
    private int maxEvaluations;
    private int totalIterations;
    private int totalEvaluations;
    private int starts;
    private RandomGenerator generator;
    private double[] optima;

    public MultiStartUnivariateRealOptimizer(UnivariateRealOptimizer optimizer, int starts, RandomGenerator generator) {
        this.optimizer = optimizer;
        this.totalIterations = 0;
        this.starts = starts;
        this.generator = generator;
        this.optima = null;
        this.setMaximalIterationCount(Integer.MAX_VALUE);
        this.setMaxEvaluations(Integer.MAX_VALUE);
    }

    public double getFunctionValue() {
        return this.optimizer.getFunctionValue();
    }

    public double getResult() {
        return this.optimizer.getResult();
    }

    public double getAbsoluteAccuracy() {
        return this.optimizer.getAbsoluteAccuracy();
    }

    public int getIterationCount() {
        return this.totalIterations;
    }

    public int getMaximalIterationCount() {
        return this.maxIterations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public double getRelativeAccuracy() {
        return this.optimizer.getRelativeAccuracy();
    }

    public void resetAbsoluteAccuracy() {
        this.optimizer.resetAbsoluteAccuracy();
    }

    public void resetMaximalIterationCount() {
        this.optimizer.resetMaximalIterationCount();
    }

    public void resetRelativeAccuracy() {
        this.optimizer.resetRelativeAccuracy();
    }

    public void setAbsoluteAccuracy(double accuracy) {
        this.optimizer.setAbsoluteAccuracy(accuracy);
    }

    public void setMaximalIterationCount(int count) {
        this.maxIterations = count;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public void setRelativeAccuracy(double accuracy) {
        this.optimizer.setRelativeAccuracy(accuracy);
    }

    public double[] getOptima() throws IllegalStateException {
        if (this.optima == null) {
            throw MathRuntimeException.createIllegalStateException("no optimum computed yet", new Object[0]);
        }
        return (double[])this.optima.clone();
    }

    public double optimize(UnivariateRealFunction f, GoalType goalType, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.optimize(f, goalType, min, max, min + this.generator.nextDouble() * (max - min));
    }

    public double optimize(UnivariateRealFunction f, GoalType goalType, double min, double max, double startValue) throws ConvergenceException, FunctionEvaluationException {
        int i;
        this.optima = new double[this.starts];
        this.totalIterations = 0;
        this.totalEvaluations = 0;
        for (int i2 = 0; i2 < this.starts; ++i2) {
            try {
                this.optimizer.setMaximalIterationCount(this.maxIterations - this.totalIterations);
                this.optimizer.setMaxEvaluations(this.maxEvaluations - this.totalEvaluations);
                this.optima[i2] = this.optimizer.optimize(f, goalType, min, max, i2 == 0 ? startValue : this.generator.nextDouble() * (max - min));
            }
            catch (FunctionEvaluationException fee) {
                this.optima[i2] = Double.NaN;
            }
            catch (ConvergenceException ce) {
                this.optima[i2] = Double.NaN;
            }
            this.totalIterations += this.optimizer.getIterationCount();
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        int lastNaN = this.optima.length;
        for (i = 0; i < lastNaN; ++i) {
            if (!Double.isNaN(this.optima[i])) continue;
            this.optima[i] = this.optima[--lastNaN];
            this.optima[lastNaN + 1] = Double.NaN;
        }
        Arrays.sort(this.optima, 0, lastNaN);
        if (goalType == GoalType.MAXIMIZE) {
            i = 0;
            for (int j = lastNaN - 1; i < j; ++i, --j) {
                double tmp = this.optima[i];
                this.optima[i] = this.optima[j];
                this.optima[j] = tmp;
            }
        }
        if (Double.isNaN(this.optima[0])) {
            throw new OptimizationException("none of the {0} start points lead to convergence", this.starts);
        }
        return this.optima[0];
    }
}

