/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import javax.ejb.EJBLocalObject;
import javax.ejb.LocalHome;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulLocalHomeProxy;
import org.jboss.ejb3.stateful.StatefulLocalProxy;
import org.jboss.logging.Logger;

public class StatefulLocalProxyFactory
extends BaseStatefulProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulLocalProxyFactory.class);

    protected Class[] getInterfaces() {
        StatefulContainer statefulContainer = (StatefulContainer)this.container;
        LocalHome localHome = (LocalHome)statefulContainer.resolveAnnotation(LocalHome.class);
        boolean bindTogether = false;
        if (localHome != null && this.bindHomeAndBusinessTogether(statefulContainer)) {
            bindTogether = true;
        }
        Class[] localInterfaces = ProxyFactoryHelper.getLocalInterfaces(this.container);
        Class[] interfaces = bindTogether ? new Class[localInterfaces.length + 3] : new Class[localInterfaces.length + 2];
        System.arraycopy(localInterfaces, 0, interfaces, 0, localInterfaces.length);
        interfaces[localInterfaces.length] = JBossProxy.class;
        interfaces[localInterfaces.length + 1] = EJBLocalObject.class;
        if (bindTogether) {
            interfaces[localInterfaces.length + 2] = localHome.value();
        }
        return interfaces;
    }

    protected boolean bindHomeAndBusinessTogether(StatefulContainer container) {
        return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(ProxyFactoryHelper.getLocalJndiName(container));
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getLocalJndiName(this.container);
    }

    public void start() throws Exception {
        super.start();
        try {
            NonSerializableFactory.rebind(this.container.getInitialContext(), this.jndiName + "StatefulProxyFactory", this);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful local proxy with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        StatefulContainer statefulContainer = (StatefulContainer)this.container;
        LocalHome localHome = (LocalHome)((EJBContainer)this.container).resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.container.getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatefulLocalHomeProxy(this.container));
            NonSerializableFactory.rebind(this.container.getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(this.container), homeProxy);
        }
    }

    public void stop() throws Exception {
        super.stop();
        NonSerializableFactory.unbind(this.container.getInitialContext(), this.jndiName + "StatefulProxyFactory");
        StatefulContainer statefulContainer = (StatefulContainer)this.container;
        LocalHome localHome = (LocalHome)((EJBContainer)this.container).resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            NonSerializableFactory.unbind(this.container.getInitialContext(), ProxyFactoryHelper.getLocalHomeJndiName(this.container));
        }
    }

    public Object createProxy() {
        try {
            StatefulContainer sfsb = (StatefulContainer)this.container;
            StatefulBeanContext ctx = sfsb.getCache().create();
            ctx.setInUse(false);
            Object id = ctx.getId();
            Object[] args = new Object[]{new StatefulLocalProxy(this.container, id)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    public Object createProxy(Object id) {
        try {
            StatefulContainer sfsb = (StatefulContainer)this.container;
            Object[] args = new Object[]{new StatefulLocalProxy(this.container, id)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    public Object createProxy(Class[] initTypes, Object[] initValues) {
        try {
            StatefulContainer sfsb = (StatefulContainer)this.container;
            Object id = sfsb.createSession(initTypes, initValues);
            Object[] args = new Object[]{new StatefulLocalProxy(this.container, id)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        LocalBinding remoteBinding = (LocalBinding)this.advisor.resolveAnnotation(LocalBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }
}

