/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.transformation;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.Boundable;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTransform<T extends Type<T>>
implements OutputAlgorithm<T> {
    protected final InvertibleCoordinateTransform transform;
    protected final Boundable transformAsBoundable;
    protected final Image<T> img;
    protected final int numDimensions;
    protected InterpolatorFactory<T> interpolatorFactory;
    protected final boolean isAffine;
    ImageFactory<T> outputImageFactory;
    final int[] newDim;
    final float[] offset;
    Image<T> transformed;
    String errorMessage = "";

    public <BT extends InvertibleCoordinateTransform & Boundable> ImageTransform(Image<T> image, BT BT, InterpolatorFactory<T> interpolatorFactory) {
        int n;
        this.img = image;
        this.interpolatorFactory = interpolatorFactory;
        this.numDimensions = image.getNumDimensions();
        this.transform = BT;
        this.transformAsBoundable = BT;
        this.outputImageFactory = image.getImageFactory();
        this.isAffine = BT instanceof AffineModel3D || BT instanceof AffineModel2D || BT instanceof TranslationModel3D || BT instanceof TranslationModel2D || BT instanceof RigidModel2D;
        int[] nArray = image.getDimensions();
        float[] fArray = new float[this.numDimensions];
        float[] fArray2 = new float[this.numDimensions];
        for (n = 0; n < this.numDimensions; ++n) {
            fArray2[n] = nArray[n] - 1;
        }
        this.transformAsBoundable.estimateBounds(fArray, fArray2);
        this.offset = new float[this.numDimensions];
        this.newDim = new int[this.numDimensions];
        for (n = 0; n < this.numDimensions; ++n) {
            this.newDim[n] = (int)(fArray2[n] - fArray[n] + 1.0f);
            this.offset[n] = fArray[n];
        }
    }

    public void setOutputImageFactory(ImageFactory<T> imageFactory) {
        this.outputImageFactory = imageFactory;
    }

    public void setInterpolatorFactory(InterpolatorFactory<T> interpolatorFactory) {
        this.interpolatorFactory = interpolatorFactory;
    }

    public ImageFactory<T> getOutputImageFactory() {
        return this.outputImageFactory;
    }

    public float[] getOffset() {
        return (float[])this.offset.clone();
    }

    public float getOffset(int n) {
        return this.offset[n];
    }

    public void setOffset(int n, int n2) {
        this.offset[n] = n2;
    }

    public void setOffset(float[] fArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.offset[i] = fArray[i];
        }
    }

    public InterpolatorFactory<T> getInterpolatorFactory() {
        return this.interpolatorFactory;
    }

    public int[] getNewImageSize() {
        return (int[])this.newDim.clone();
    }

    public float getNewImageSize(int n) {
        return this.newDim[n];
    }

    public void setNewImageSize(int n, int n2) {
        this.newDim[n] = n2;
    }

    public void setNewImageSize(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.newDim[i] = nArray[i];
        }
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.img == null) {
            this.errorMessage = "AffineTransform: [Image<T> img] is null.";
            return false;
        }
        if (this.interpolatorFactory.getOutOfBoundsStrategyFactory() == null) {
            this.errorMessage = "AffineTransform: [OutOfBoundsStrategyFactory<T> of interpolatorFactory] is null.";
            return false;
        }
        if (this.interpolatorFactory == null) {
            this.errorMessage = "AffineTransform: [InterpolatorFactory<T> interpolatorFactory] is null.";
            return false;
        }
        if (this.transform == null) {
            this.errorMessage = "AffineTransform: [Transform3D transform] or [float[] transform] is null.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Image<T> getResult() {
        return this.transformed;
    }

    public boolean process() {
        if (!this.checkInput()) {
            return false;
        }
        this.transformed = this.outputImageFactory.createImage(this.newDim);
        LocalizableCursor localizableCursor = this.transformed.createLocalizableCursor();
        Interpolator interpolator = this.img.createInterpolator(this.interpolatorFactory);
        try {
            float[] fArray = new float[this.numDimensions];
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                for (int i = 0; i < this.numDimensions; ++i) {
                    fArray[i] = (float)localizableCursor.getPosition(i) + this.offset[i];
                }
                this.transform.applyInverseInPlace(fArray);
                interpolator.moveTo(fArray);
                localizableCursor.getType().set(interpolator.getType());
            }
        }
        catch (NoninvertibleModelException noninvertibleModelException) {
            localizableCursor.close();
            interpolator.close();
            this.transformed.close();
            this.errorMessage = "ImageTransform.process(): " + noninvertibleModelException.getMessage();
            return false;
        }
        localizableCursor.close();
        interpolator.close();
        return true;
    }
}

