/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.transformation;

import java.util.ArrayList;
import mpicbg.imglib.algorithm.transformation.HoughTransform;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoughLineTransform<S extends RealType<S>, T extends Type<T> & Comparable<T>>
extends HoughTransform<S, T> {
    public static final int DEFAULT_THETA = 180;
    public final double dTheta;
    public final double dRho;
    private final T threshold;
    private final int nRho;
    private final int nTheta;
    private final double[] rho;
    private final double[] theta;
    private ArrayList<double[]> rtPeaks;

    public static int defaultRho(Image<?> image) {
        return (int)(2.0f * Util.computeLength((int[])image.getDimensions()));
    }

    public static <T extends Type<T> & Comparable<T>> HoughLineTransform<ShortType, T> shortHoughLine(Image<T> image) {
        return new HoughLineTransform<ShortType, T>(image, new ShortType());
    }

    public static <T extends Type<T> & Comparable<T>> HoughLineTransform<IntType, T> integerHoughLine(Image<T> image) {
        return new HoughLineTransform<IntType, T>(image, new IntType());
    }

    public static <T extends Type<T> & Comparable<T>> HoughLineTransform<LongType, T> longHoughLine(Image<T> image) {
        return new HoughLineTransform<LongType, T>(image, new LongType());
    }

    public HoughLineTransform(Image<T> image, S s) {
        this(image, 180, s);
    }

    public HoughLineTransform(Image<T> image, int n, S s) {
        this(image, HoughLineTransform.defaultRho(image), 180, s);
    }

    public HoughLineTransform(Image<T> image, int n, int n2, S s) {
        super(image, new int[]{n, n2}, s);
        this.dTheta = Math.PI / (double)n2;
        this.dRho = (double)(2.0f * Util.computeLength((int[])image.getDimensions())) / (double)n;
        this.threshold = image.createType();
        this.nRho = n;
        this.nTheta = n2;
        this.theta = new double[n2];
        this.rho = new double[n];
        this.rtPeaks = null;
    }

    public HoughLineTransform(Image<T> image, ImageFactory<S> imageFactory, int n, int n2) {
        super(image, new int[]{n, n2}, imageFactory);
        this.dTheta = Math.PI / (double)n2;
        this.dRho = (double)(2.0f * Util.computeLength((int[])image.getDimensions())) / (double)n;
        this.threshold = image.createType();
        this.nRho = n;
        this.nTheta = n2;
        this.theta = new double[n2];
        this.rho = new double[n];
        this.rtPeaks = null;
    }

    public void setThreshold(T t) {
        this.threshold.set(t);
    }

    public boolean process() {
        int n;
        LocalizableCursor localizableCursor = this.getImage().createLocalizableCursor();
        int[] nArray = new int[this.getImage().getDimensions().length];
        double d = -Util.computeLength((int[])super.getImage().getDimensions());
        long l = System.currentTimeMillis();
        for (n = 0; n < this.nTheta; ++n) {
            this.theta[n] = this.dTheta * (double)n + -1.5707963267948966;
        }
        for (n = 0; n < this.nRho; ++n) {
            this.rho[n] = this.dRho * (double)n + d;
        }
        while (localizableCursor.hasNext()) {
            int[] nArray2 = new int[2];
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray);
            for (int i = 0; i < this.nTheta; ++i) {
                int n2;
                if (((Comparable)localizableCursor.getType()).compareTo(this.threshold) <= 0) continue;
                double d2 = Math.cos(this.theta[i]) * (double)nArray[0] + Math.sin(this.theta[i]) * (double)nArray[1];
                nArray2[0] = n2 = Math.round((float)((d2 - d) / this.dRho));
                nArray2[1] = i;
                try {
                    super.placeVote(nArray2);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Tried to place vote at " + n2 + " " + i + " for theta " + this.theta[i] + ", and rho " + d2);
                    return false;
                }
            }
        }
        boolean bl = super.pickPeaks();
        this.pTime = System.currentTimeMillis() - l;
        return bl;
    }

    public ArrayList<double[]> getTranslatedPeakList() {
        if (this.rtPeaks == null) {
            ArrayList<int[]> arrayList = this.getPeakList();
            this.rtPeaks = new ArrayList(arrayList.size());
            for (int[] nArray : arrayList) {
                double[] dArray = new double[]{this.rho[nArray[0]], this.theta[nArray[2]]};
                this.rtPeaks.add(dArray);
            }
        }
        return this.rtPeaks;
    }
}

