/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import java.util.ArrayList;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.function.SubtractNormReal;
import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.algorithm.math.ImageCalculator;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.algorithm.math.NormalizeImageMinMax;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleSpace<A extends Type<A>, B extends RealType<B>>
implements OutputAlgorithm<B>,
MultiThreaded,
Benchmark {
    final Image<A> image;
    final ImageFactory<B> processFactory;
    final Converter<A, B> converter;
    ContainerFactory scaleSpaceContainerFactory;
    ArrayList<DifferenceOfGaussianPeak<B>> peaks;
    Image<B> scaleSpace;
    double initialSigma;
    double scale;
    double imageSigma;
    int minImageSize;
    int stepsPerOctave;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public ScaleSpace(Image<A> image, ImageFactory<B> imageFactory, Converter<A, B> converter, double d) {
        this.setNumThreads();
        this.image = image;
        this.processFactory = imageFactory;
        this.converter = converter;
        this.scaleSpaceContainerFactory = new ArrayContainerFactory();
        this.initialSigma = d;
        this.scale = 1.0;
        this.imageSigma = 0.5;
        this.minImageSize = 16;
        this.stepsPerOctave = 7;
    }

    public Image<B> getResult() {
        return this.scaleSpace;
    }

    public ArrayList<DifferenceOfGaussianPeak<B>> getPeaks() {
        return this.peaks;
    }

    public boolean process() {
        Image<B> image;
        long l = System.currentTimeMillis();
        if (this.initialSigma < 1.0) {
            image = this.upSample(this.image, this.processFactory, this.converter);
            this.imageSigma *= 2.0;
            this.initialSigma *= 2.0;
            this.scale = 2.0;
        } else {
            image = this.convert(this.image, this.processFactory, this.converter);
        }
        if (image == null) {
            this.errorMessage = "Error creating input image: " + this.errorMessage;
            return false;
        }
        if (!this.normImageMinMax(image)) {
            image.close();
            return false;
        }
        double[] dArray = this.getSigmas(image, this.initialSigma, this.minImageSize, this.stepsPerOctave);
        double[] dArray2 = this.getIncrementalSigmas(dArray, this.imageSigma);
        double d = this.getNormalizationFactor(this.stepsPerOctave);
        this.scaleSpace = this.computeScaleSpace(image, dArray2, d, this.scaleSpaceContainerFactory);
        if (this.scaleSpace == null) {
            this.errorMessage = "Cannot compute scale space: " + this.errorMessage;
            image.close();
            return false;
        }
        DifferenceOfGaussianReal<B, B> differenceOfGaussianReal = new DifferenceOfGaussianReal<B, B>(this.scaleSpace, this.scaleSpace.getImageFactory(), null, 0.0, 0.0, 0.03f, 0.0);
        this.peaks = differenceOfGaussianReal.findPeaks(this.scaleSpace);
        SubpixelLocalization<B> subpixelLocalization = new SubpixelLocalization<B>(this.scaleSpace, this.peaks);
        subpixelLocalization.setNumThreads(this.getNumThreads());
        if (!subpixelLocalization.checkInput() || !subpixelLocalization.process()) {
            this.errorMessage = "Cannot compute subpixel localization: " + subpixelLocalization.getErrorMessage();
            this.scaleSpace.close();
            return false;
        }
        for (DifferenceOfGaussianPeak<B> differenceOfGaussianPeak : this.peaks) {
            double d2 = differenceOfGaussianPeak.getSubPixelPosition(this.scaleSpace.getNumDimensions() - 1) + 0.5f;
            d2 = this.initialSigma * Math.pow(2.0, d2 / (double)this.stepsPerOctave);
            differenceOfGaussianPeak.setPixelLocation((int)Math.round(d2), this.scaleSpace.getNumDimensions() - 1);
            differenceOfGaussianPeak.setSubPixelLocationOffset((float)d2 - (float)((int)Math.round(d2)), this.scaleSpace.getNumDimensions() - 1);
            if (this.scale == 1.0) continue;
            for (int i = 0; i < this.scaleSpace.getNumDimensions(); ++i) {
                float f = differenceOfGaussianPeak.getSubPixelPosition(i) / 2.0f;
                int n = Util.round((float)f);
                differenceOfGaussianPeak.setPixelLocation(n, i);
                differenceOfGaussianPeak.setSubPixelLocationOffset(f - (float)n, i);
            }
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected Image<B> computeScaleSpace(Image<B> image, double[] dArray, double d, ContainerFactory containerFactory) {
        int[] nArray = new int[image.getNumDimensions() + 1];
        image.getDimensions(nArray);
        nArray[image.getNumDimensions()] = dArray.length - 1;
        Image image2 = new ImageFactory(image.createType(), containerFactory).createImage(nArray, "Scalespace of " + image.getName());
        Image image3 = null;
        Image image4 = null;
        GaussianConvolutionReal<B> gaussianConvolutionReal = new GaussianConvolutionReal<B>(image, new OutOfBoundsStrategyMirrorFactory(), dArray[0]);
        gaussianConvolutionReal.setNumThreads(this.getNumThreads());
        if (!gaussianConvolutionReal.checkInput() || !gaussianConvolutionReal.process()) {
            this.errorMessage = "Cannot compute inital gaussian convolution: " + gaussianConvolutionReal.getErrorMessage();
            image2.close();
            return null;
        }
        image3 = gaussianConvolutionReal.getResult();
        for (int i = 1; i < dArray.length; ++i) {
            gaussianConvolutionReal.setImage(image3);
            gaussianConvolutionReal.setSigma(dArray[i]);
            if (!gaussianConvolutionReal.checkInput() || !gaussianConvolutionReal.process()) {
                this.errorMessage = "Cannot compute gaussian convolution with sigma=" + dArray[i] + " : " + gaussianConvolutionReal.getErrorMessage();
                image2.close();
                return null;
            }
            image4 = gaussianConvolutionReal.getResult();
            SubtractNormReal subtractNormReal = new SubtractNormReal(d);
            ImageCalculator imageCalculator = new ImageCalculator(image4, image3, image3, subtractNormReal);
            imageCalculator.setNumThreads(this.getNumThreads());
            if (!imageCalculator.checkInput() || !imageCalculator.process()) {
                this.errorMessage = "Cannot subtract images: " + imageCalculator.getErrorMessage();
                image2.close();
                image3.close();
                image4.close();
                return null;
            }
            LocalizableCursor localizableCursor = image3.createLocalizableCursor();
            LocalizableByDimCursor localizableByDimCursor = image2.createLocalizableByDimCursor();
            int[] nArray2 = localizableByDimCursor.getPosition();
            nArray2[image2.getNumDimensions() - 1] = i - 1;
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                localizableCursor.getPosition(nArray2);
                localizableByDimCursor.moveTo(nArray2);
                ((RealType)localizableByDimCursor.getType()).set(localizableCursor.getType());
            }
            localizableCursor.close();
            localizableByDimCursor.close();
            image3.close();
            image3 = image4;
            image4 = null;
        }
        image3.close();
        return image2;
    }

    protected double getNormalizationFactor(int n) {
        double d = Math.pow(2.0, 1.0 / (double)n);
        double d2 = 1.0 / (d - 1.0);
        return d2;
    }

    protected double[] getIncrementalSigmas(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = Math.sqrt(dArray[0] * dArray[0] - d * d);
        for (int i = 1; i < dArray.length; ++i) {
            dArray2[i] = Math.sqrt(dArray[i] * dArray[i] - dArray[i - 1] * dArray[i - 1]);
        }
        return dArray2;
    }

    protected double[] getSigmas(Image<?> image, double d, int n, int n2) {
        int n3;
        int n4 = image.getDimension(0);
        for (n3 = 1; n3 < image.getNumDimensions(); ++n3) {
            n4 = Math.min(n4, image.getDimension(n3));
        }
        n3 = (int)Math.round(Util.log2((double)n4) - Util.log2((double)n) + 0.25);
        double[] dArray = new double[n3 * n2 + 3];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d * Math.pow(2.0, (double)i / (double)n2);
        }
        return dArray;
    }

    protected boolean normImageMinMax(Image<B> image) {
        NormalizeImageMinMax<B> normalizeImageMinMax = new NormalizeImageMinMax<B>(image);
        normalizeImageMinMax.setNumThreads(this.getNumThreads());
        if (!normalizeImageMinMax.checkInput() || !normalizeImageMinMax.process()) {
            this.errorMessage = "Cannot normalize image: " + normalizeImageMinMax.getErrorMessage();
            return false;
        }
        return true;
    }

    protected Image<B> convert(Image<A> image, ImageFactory<B> imageFactory, Converter<A, B> converter) {
        ImageConverter<A, B> imageConverter = new ImageConverter<A, B>(this.image, imageFactory, converter);
        imageConverter.setNumThreads(this.getNumThreads());
        if (!imageConverter.checkInput() || !imageConverter.process()) {
            this.errorMessage = "Cannot convert image: " + imageConverter.getErrorMessage();
            return null;
        }
        return imageConverter.getResult();
    }

    protected Image<B> upSample(Image<A> image, ImageFactory<B> imageFactory, Converter<A, B> converter) {
        int n = image.getNumDimensions();
        int[] nArray = image.getDimensions();
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray[i] * 2 - 1;
        }
        Image image2 = imageFactory.createImage(nArray);
        LocalizableCursor localizableCursor = image.createLocalizableCursor();
        LocalizableByDimCursor localizableByDimCursor = image2.createLocalizableByDimCursor();
        int[] nArray2 = new int[n];
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray2);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                nArray2[n3] = nArray2[n3] * 2;
            }
            localizableByDimCursor.setPosition(nArray2);
            converter.convert(localizableCursor.getType(), localizableByDimCursor.getType());
        }
        localizableCursor.close();
        LocalizableCursor localizableCursor2 = image2.createLocalizableCursor();
        for (int i = 0; i < n; ++i) {
            localizableCursor2.reset();
            while (localizableCursor2.hasNext()) {
                localizableCursor2.fwd();
                int n4 = localizableCursor2.getPosition(i);
                if (n4 % 2 != 1) continue;
                localizableByDimCursor.setPosition((Localizable)localizableCursor2);
                localizableByDimCursor.bck(i);
                double d = ((RealType)localizableByDimCursor.getType()).getRealDouble();
                localizableByDimCursor.fwd(i);
                localizableByDimCursor.fwd(i);
                double d2 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
                localizableByDimCursor.bck(i);
                ((RealType)localizableByDimCursor.getType()).setReal((d2 + d) / 2.0);
            }
        }
        localizableByDimCursor.close();
        localizableCursor2.close();
        return image2;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ScaleSpace: [Image<A> img] is null.";
            return false;
        }
        if (this.processFactory == null) {
            this.errorMessage = "ScaleSpace: [ImageFactory<B> processFactory] is null.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

