/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.function.SubtractNormReal;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution2;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceOfGaussianReal<A extends RealType<A>, B extends RealType<B>>
extends DifferenceOfGaussian<A, B> {
    double normalizationFactor;
    double minPeakValue;

    public DifferenceOfGaussianReal(Image<A> image, ImageFactory<B> imageFactory, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, double d, double d2, double d3, double d4) {
        super(image, imageFactory, new RealTypeConverter(), outOfBoundsStrategyFactory, d, d2, DifferenceOfGaussianReal.createVariable(imageFactory, d3), DifferenceOfGaussianReal.createVariable(imageFactory, d4));
        this.normalizationFactor = d4;
        this.minPeakValue = d3;
    }

    protected static <T extends RealType<T>> T createVariable(ImageFactory<T> imageFactory, double d) {
        RealType realType = (RealType)imageFactory.createType();
        realType.setReal(d);
        return (T)realType;
    }

    @Override
    public void setMinPeakValue(B b) {
        this.minPeakValue = b.getRealDouble();
    }

    @Override
    public B getMinPeakValue() {
        return (B)DifferenceOfGaussianReal.createVariable(this.factory, this.minPeakValue);
    }

    protected OutputAlgorithm<B> getGaussianConvolution(double d, int n) {
        GaussianConvolution2 gaussianConvolution2 = new GaussianConvolution2(this.image, this.factory, this.outOfBoundsFactory, new RealTypeConverter(), d);
        return gaussianConvolution2;
    }

    @Override
    protected Function<B, B, B> getNormalizedSubtraction() {
        return new SubtractNormReal(this.normalizationFactor);
    }

    @Override
    protected boolean isPeakHighEnough(B b) {
        return Math.abs(b.getRealDouble()) >= this.minPeakValue;
    }

    @Override
    protected DifferenceOfGaussian.SpecialPoint isSpecialPoint(LocalNeighborhoodCursor<B> localNeighborhoodCursor, B b) {
        boolean bl;
        double d;
        boolean bl2 = true;
        double d2 = b.getRealDouble();
        for (bl = true; (bl || bl2) && localNeighborhoodCursor.hasNext(); bl2 &= d >= d2, bl &= d <= d2) {
            localNeighborhoodCursor.fwd();
            d = ((RealType)localNeighborhoodCursor.getType()).getRealDouble();
        }
        if (bl2) {
            return DifferenceOfGaussian.SpecialPoint.MAX;
        }
        if (bl) {
            return DifferenceOfGaussian.SpecialPoint.MIN;
        }
        return DifferenceOfGaussian.SpecialPoint.INVALID;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "DifferenceOfGaussian: [Image<A> img] is null.";
            return false;
        }
        if (this.factory == null) {
            this.errorMessage = "DifferenceOfGaussian: [ImageFactory<B> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "DifferenceOfGaussian: [OutOfBoundsStrategyFactory<B>] is null.";
            return false;
        }
        return true;
    }
}

