/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceOfGaussianPeak<T extends NumericType<T>>
implements Localizable,
Leaf<DifferenceOfGaussianPeak<T>> {
    DifferenceOfGaussian.SpecialPoint specialPoint;
    String errorMessage;
    protected final int[] pixelLocation;
    protected final float[] subPixelLocationOffset;
    protected final T value;
    protected final T fitValue;
    protected final T sumValue;
    final int numDimensions;

    public DifferenceOfGaussianPeak(int[] nArray, T t, DifferenceOfGaussian.SpecialPoint specialPoint) {
        this.specialPoint = specialPoint;
        this.pixelLocation = (int[])nArray.clone();
        this.subPixelLocationOffset = new float[nArray.length];
        this.numDimensions = nArray.length;
        this.value = (NumericType)t.copy();
        this.sumValue = (NumericType)t.copy();
        this.fitValue = (NumericType)t.createVariable();
        this.fitValue.setZero();
        this.errorMessage = "";
    }

    public DifferenceOfGaussianPeak<T> copy() {
        DifferenceOfGaussianPeak<T> differenceOfGaussianPeak = new DifferenceOfGaussianPeak<T>(this.pixelLocation, this.value, this.specialPoint);
        differenceOfGaussianPeak.setFitValue(this.fitValue);
        differenceOfGaussianPeak.setSubPixelLocationOffset(this.subPixelLocationOffset);
        return differenceOfGaussianPeak;
    }

    public boolean isMin() {
        return this.specialPoint == DifferenceOfGaussian.SpecialPoint.MIN;
    }

    public boolean isMax() {
        return this.specialPoint == DifferenceOfGaussian.SpecialPoint.MAX;
    }

    public boolean isValid() {
        return this.specialPoint != DifferenceOfGaussian.SpecialPoint.INVALID;
    }

    public DifferenceOfGaussian.SpecialPoint getPeakType() {
        return this.specialPoint;
    }

    public float[] getSubPixelPositionOffset() {
        return (float[])this.subPixelLocationOffset.clone();
    }

    public float getSubPixelPositionOffset(int n) {
        return this.subPixelLocationOffset[n];
    }

    public float[] getSubPixelPosition() {
        float[] fArray = (float[])this.subPixelLocationOffset.clone();
        for (int i = 0; i < fArray.length; ++i) {
            int n = i;
            fArray[n] = fArray[n] + (float)this.pixelLocation[i];
        }
        return fArray;
    }

    public void getSubPixelPosition(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.subPixelLocationOffset[i] + (float)this.pixelLocation[i];
        }
    }

    public float getSubPixelPosition(int n) {
        return this.subPixelLocationOffset[n] + (float)this.pixelLocation[n];
    }

    public T getValue() {
        return this.sumValue;
    }

    public T getImgValue() {
        return this.value;
    }

    public T getFitValue() {
        return this.fitValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPeakType(DifferenceOfGaussian.SpecialPoint specialPoint) {
        this.specialPoint = specialPoint;
    }

    public void setSubPixelLocationOffset(float f, int n) {
        this.subPixelLocationOffset[n] = f;
    }

    public void setSubPixelLocationOffset(float[] fArray) {
        for (int i = 0; i < this.pixelLocation.length; ++i) {
            this.subPixelLocationOffset[i] = fArray[i];
        }
    }

    public void setPixelLocation(int n, int n2) {
        this.pixelLocation[n2] = n;
    }

    public void setPixelLocation(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pixelLocation[i] = nArray[i];
        }
    }

    public void setImgValue(T t) {
        this.value.set(t);
        this.sumValue.set(this.value);
        this.sumValue.add(this.fitValue);
    }

    public void setFitValue(T t) {
        this.fitValue.set(t);
        this.sumValue.set(this.value);
        this.sumValue.add(this.fitValue);
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.pixelLocation.length; ++i) {
            nArray[i] = this.pixelLocation[i];
        }
    }

    public int[] getPosition() {
        return (int[])this.pixelLocation.clone();
    }

    public int getPosition(int n) {
        return this.pixelLocation[n];
    }

    public String getPositionAsString() {
        return Util.printCoordinates((int[])this.pixelLocation);
    }

    public void fwd(long l) {
    }

    public void fwd() {
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public float get(int n) {
        return this.getSubPixelPosition(n);
    }

    @Override
    public float distanceTo(DifferenceOfGaussianPeak<T> differenceOfGaussianPeak) {
        double d = 0.0;
        for (int i = 0; i < this.numDimensions; ++i) {
            double d2 = differenceOfGaussianPeak.get(i) - this.get(i);
            d += d2 * d2;
        }
        return (float)Math.sqrt(d);
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    public DifferenceOfGaussianPeak<T>[] createArray(int n) {
        return new DifferenceOfGaussianPeak[n];
    }

    @Override
    public DifferenceOfGaussianPeak<T> getEntry() {
        return this;
    }
}

