/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.function.SubtractNorm;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution2;
import mpicbg.imglib.algorithm.math.ImageCalculator;
import mpicbg.imglib.algorithm.math.ImageCalculatorInPlace;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceOfGaussian<A extends Type<A>, B extends NumericType<B> & Comparable<B>>
implements Algorithm,
MultiThreaded,
Benchmark {
    protected final Image<A> image;
    protected Image<B> dogImage;
    protected final ImageFactory<B> factory;
    protected final OutOfBoundsStrategyFactory<B> outOfBoundsFactory;
    final double[] sigma1;
    final double[] sigma2;
    final B normalizationFactor;
    final B minPeakValue;
    final B negMinPeakValue;
    final B zero;
    final B one;
    final B minusOne;
    protected final ArrayList<DifferenceOfGaussianPeak<B>> peaks = new ArrayList();
    protected final Converter<A, B> converter;
    boolean computeConvolutionsParalell = true;
    boolean keepDoGImage;
    long processingTime = -1L;
    int numThreads;
    String errorMessage = "";

    private static final double[] asArray(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    public DifferenceOfGaussian(Image<A> image, ImageFactory<B> imageFactory, Converter<A, B> converter, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, double d, double d2, B b, B b2) {
        this(image, imageFactory, converter, outOfBoundsStrategyFactory, DifferenceOfGaussian.asArray(image.getNumDimensions(), d), DifferenceOfGaussian.asArray(image.getNumDimensions(), d2), b, b2);
    }

    public DifferenceOfGaussian(Image<A> image, ImageFactory<B> imageFactory, Converter<A, B> converter, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, double[] dArray, double[] dArray2, B b, B b2) {
        this.setNumThreads();
        this.image = image;
        this.factory = imageFactory;
        this.outOfBoundsFactory = outOfBoundsStrategyFactory;
        this.converter = converter;
        this.sigma1 = dArray;
        this.sigma2 = dArray2;
        this.normalizationFactor = b2;
        this.minPeakValue = b;
        this.zero = (NumericType)imageFactory.createType();
        this.zero.setZero();
        this.one = (NumericType)imageFactory.createType();
        this.one.setOne();
        this.minusOne = (NumericType)imageFactory.createType();
        this.minusOne.setZero();
        this.minusOne.sub(this.one);
        this.negMinPeakValue = (NumericType)b.copy();
        this.negMinPeakValue.mul(this.minusOne);
        this.dogImage = null;
        this.keepDoGImage = false;
    }

    public void setMinPeakValue(B b) {
        this.minPeakValue.set(b);
    }

    public B getMinPeakValue() {
        return (B)((NumericType)this.minPeakValue.copy());
    }

    public Image<B> getDoGImage() {
        return this.dogImage;
    }

    public void setKeepDoGImage(boolean bl) {
        this.keepDoGImage = bl;
    }

    public boolean getKeepDoGImage() {
        return this.keepDoGImage;
    }

    public ArrayList<DifferenceOfGaussianPeak<B>> getPeaks() {
        return this.peaks;
    }

    public void setComputeConvolutionsParalell(boolean bl) {
        this.computeConvolutionsParalell = bl;
    }

    public boolean getComputeConvolutionsParalell() {
        return this.computeConvolutionsParalell;
    }

    protected OutputAlgorithm<B> getGaussianConvolution(double[] dArray, int n) {
        GaussianConvolution2<A, B> gaussianConvolution2 = new GaussianConvolution2<A, B>(this.image, this.factory, this.outOfBoundsFactory, this.converter, dArray);
        return gaussianConvolution2;
    }

    protected Function<B, B, B> getNormalizedSubtraction() {
        return new SubtractNorm<B>(this.normalizationFactor);
    }

    protected boolean isPeakHighEnough(B b) {
        if (((Comparable)b).compareTo(this.zero) >= 0) {
            return ((Comparable)b).compareTo(this.minPeakValue) >= 0;
        }
        return ((Comparable)b).compareTo(this.negMinPeakValue) <= 0;
    }

    protected SpecialPoint isSpecialPoint(LocalNeighborhoodCursor<B> localNeighborhoodCursor, B b) {
        boolean bl;
        NumericType numericType;
        boolean bl2 = true;
        for (bl = true; (bl || bl2) && localNeighborhoodCursor.hasNext(); bl2 &= ((Comparable)numericType).compareTo(b) >= 0, bl &= ((Comparable)numericType).compareTo(b) <= 0) {
            localNeighborhoodCursor.fwd();
            numericType = (NumericType)localNeighborhoodCursor.getType();
        }
        if (bl2) {
            return SpecialPoint.MAX;
        }
        if (bl) {
            return SpecialPoint.MIN;
        }
        return SpecialPoint.INVALID;
    }

    public boolean process() {
        Object object;
        Function<B, B, B> function;
        long l = System.currentTimeMillis();
        int n = this.computeConvolutionsParalell ? 2 : 1;
        OutputAlgorithm<B> outputAlgorithm = this.getGaussianConvolution(this.sigma1, Math.max(1, this.getNumThreads() / n));
        OutputAlgorithm<B> outputAlgorithm2 = this.getGaussianConvolution(this.sigma2, Math.max(1, this.getNumThreads() / n));
        if (outputAlgorithm.checkInput() && outputAlgorithm2.checkInput()) {
            function = new Function<B, B, B>(0);
            object = SimpleMultiThreading.newThreads((int)n);
            for (int i = 0; i < ((Thread[])object).length; ++i) {
                object[i] = new Thread(new Runnable((AtomicInteger)function, outputAlgorithm, outputAlgorithm2){
                    final /* synthetic */ AtomicInteger val$ai;
                    final /* synthetic */ OutputAlgorithm val$conv1;
                    final /* synthetic */ OutputAlgorithm val$conv2;
                    {
                        this.val$ai = atomicInteger;
                        this.val$conv1 = outputAlgorithm;
                        this.val$conv2 = outputAlgorithm2;
                    }

                    public void run() {
                        int n = this.val$ai.getAndIncrement();
                        if (!(n != 0 && DifferenceOfGaussian.this.computeConvolutionsParalell || this.val$conv1.process())) {
                            System.out.println("Cannot compute gaussian convolution 1: " + this.val$conv1.getErrorMessage());
                        }
                        if (!(n != 1 && DifferenceOfGaussian.this.computeConvolutionsParalell || this.val$conv2.process())) {
                            System.out.println("Cannot compute gaussian convolution 2: " + this.val$conv2.getErrorMessage());
                        }
                    }
                });
            }
        } else {
            this.errorMessage = "Cannot compute gaussian convolutions: " + outputAlgorithm.getErrorMessage() + " & " + outputAlgorithm2.getErrorMessage();
            Object var7_8 = null;
            Object var6_11 = null;
            return false;
        }
        SimpleMultiThreading.startAndJoin((Thread[])object);
        if (outputAlgorithm.getErrorMessage().length() != 0 || outputAlgorithm2.getErrorMessage().length() != 0) {
            Object var7_10 = null;
            Object var6_13 = null;
            return false;
        }
        Image image = outputAlgorithm.getResult();
        Image image2 = outputAlgorithm2.getResult();
        function = this.getNormalizedSubtraction();
        object = new ImageCalculatorInPlace<B, B>(image2, image, function);
        if (!((ImageCalculator)object).checkInput() || !((ImageCalculator)object).process()) {
            this.errorMessage = "Cannot subtract images: " + ((ImageCalculator)object).getErrorMessage();
            image.close();
            image2.close();
            return false;
        }
        image.close();
        this.peaks.clear();
        this.peaks.addAll(this.findPeaks(image2));
        if (this.keepDoGImage) {
            this.dogImage = image2;
        } else {
            image2.close();
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    public ArrayList<DifferenceOfGaussianPeak<B>> findPeaks(final Image<B> image) {
        int n;
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.getNumThreads());
        final int n2 = threadArray.length;
        final int n3 = image.getNumDimensions();
        final Vector vector = new Vector();
        for (n = 0; n < n2; ++n) {
            vector.add(new ArrayList());
        }
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n] = new Thread(new Runnable(){

                public void run() {
                    int n = atomicInteger.getAndIncrement();
                    ArrayList arrayList = (ArrayList)vector.get(n);
                    LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
                    LocalNeighborhoodCursor localNeighborhoodCursor = LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor((LocalizableByDimCursor)localizableByDimCursor);
                    int[] nArray = new int[n3];
                    int[] nArray2 = image.getDimensions();
                    int n22 = 0;
                    while (n22 < n3) {
                        int n32 = n22++;
                        nArray2[n32] = nArray2[n32] - 2;
                    }
                    block1: while (localizableByDimCursor.hasNext()) {
                        localizableByDimCursor.fwd();
                        localizableByDimCursor.getPosition(nArray);
                        if (nArray[0] % n2 != n) continue;
                        for (n22 = 0; n22 < n3; ++n22) {
                            int n4 = nArray[n22];
                            if (n4 < 1 || n4 > nArray2[n22]) continue block1;
                        }
                        NumericType numericType = (NumericType)((NumericType)localizableByDimCursor.getType()).copy();
                        if (!DifferenceOfGaussian.this.isPeakHighEnough(numericType)) continue;
                        localNeighborhoodCursor.update();
                        SpecialPoint specialPoint = DifferenceOfGaussian.this.isSpecialPoint(localNeighborhoodCursor, numericType);
                        if (specialPoint != SpecialPoint.INVALID) {
                            arrayList.add(new DifferenceOfGaussianPeak<NumericType>(nArray, numericType, specialPoint));
                        }
                        localNeighborhoodCursor.reset();
                    }
                    localizableByDimCursor.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        ArrayList<DifferenceOfGaussianPeak<B>> arrayList = new ArrayList<DifferenceOfGaussianPeak<B>>();
        for (ArrayList arrayList2 : vector) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "DifferenceOfGaussian: [Image<A> img] is null.";
            return false;
        }
        if (this.factory == null) {
            this.errorMessage = "DifferenceOfGaussian: [ImageFactory<B> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "DifferenceOfGaussian: [OutOfBoundsStrategyFactory<B>] is null.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialPoint {
        INVALID,
        MIN,
        MAX;

    }
}

