/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.algorithm.ROIAlgorithm;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ShortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectConvolution<T extends RealType<T>, R extends RealType<R>, S extends RealType<S>>
extends ROIAlgorithm<T, S> {
    private final Image<R> kernel;
    private final int[] kernelSize;
    private LocalizableByDimCursor<S> outputImageCursor;
    private final LocalizableByDimCursor<R> kernelCursor;
    private final boolean doInvert;

    protected static void quickKernel2D(short[][] sArray, Image<ShortType> image) {
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
        int[] nArray = new int[2];
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray[i].length; ++j) {
                nArray[0] = i;
                nArray[1] = j;
                localizableByDimCursor.setPosition(nArray);
                ((ShortType)localizableByDimCursor.getType()).set(sArray[i][j]);
            }
        }
        localizableByDimCursor.close();
    }

    public static Image<ShortType> sobelVertical() {
        ImageFactory imageFactory = new ImageFactory((Type)new ShortType(), (ContainerFactory)new ArrayContainerFactory());
        Image image = imageFactory.createImage(new int[]{3, 3}, "Vertical Sobel");
        short[][] sArrayArray = new short[][]{{-1, -2, -1}, {0, 0, 0}, {1, 2, 1}};
        DirectConvolution.quickKernel2D(sArrayArray, (Image<ShortType>)image);
        return image;
    }

    public static Image<ShortType> sobelHorizontal() {
        ImageFactory imageFactory = new ImageFactory((Type)new ShortType(), (ContainerFactory)new ArrayContainerFactory());
        Image image = imageFactory.createImage(new int[]{3, 3}, "Horizontal Sobel");
        short[][] sArrayArray = new short[][]{{1, 0, -1}, {2, 0, -2}, {1, 0, -1}};
        DirectConvolution.quickKernel2D(sArrayArray, (Image<ShortType>)image);
        return image;
    }

    public DirectConvolution(S s, Image<T> image, Image<R> image2) {
        this(s, image, image2, null);
    }

    public DirectConvolution(S s, Image<T> image, Image<R> image2, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(s, image, image2, outOfBoundsStrategyFactory, true);
    }

    protected DirectConvolution(S s, Image<T> image, Image<R> image2, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, boolean bl) {
        super(s, image, image2.getDimensions(), outOfBoundsStrategyFactory);
        this.kernel = image2;
        this.outputImageCursor = null;
        this.kernelSize = image2.getDimensions();
        this.kernelCursor = image2.createLocalizableByDimCursor();
        this.setName(image.getName() + " * " + image2.getName());
        this.doInvert = bl;
    }

    private LocalizableByDimCursor<S> getOutputCursor() {
        if (this.outputImageCursor == null) {
            this.outputImageCursor = this.getOutputImage().createLocalizableByDimCursor();
        }
        return this.outputImageCursor;
    }

    private void invertPosition(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this.kernel.getNumDimensions(); ++i) {
            nArray2[i] = this.kernelSize[i] - nArray[i] - 1;
        }
    }

    protected boolean patchOperation(int[] nArray, RegionOfInterestCursor<T> regionOfInterestCursor) {
        LocalizableByDimCursor<S> localizableByDimCursor = this.getOutputCursor();
        int[] nArray2 = new int[localizableByDimCursor.getNumDimensions()];
        int[] nArray3 = new int[localizableByDimCursor.getNumDimensions()];
        RealType realType = (RealType)localizableByDimCursor.getImage().createType();
        RealType realType2 = (RealType)localizableByDimCursor.getImage().createType();
        RealType realType3 = (RealType)localizableByDimCursor.getImage().createType();
        realType.setZero();
        localizableByDimCursor.setPosition(nArray);
        while (regionOfInterestCursor.hasNext()) {
            realType2.setOne();
            regionOfInterestCursor.fwd();
            regionOfInterestCursor.getPosition(nArray2);
            if (this.doInvert) {
                this.invertPosition(nArray2, nArray3);
                this.kernelCursor.setPosition(nArray3);
            } else {
                this.kernelCursor.setPosition(nArray2);
            }
            realType3.setReal(((RealType)this.kernelCursor.getType()).getRealDouble());
            realType3.setComplex(-((RealType)this.kernelCursor.getType()).getComplexDouble());
            realType2.mul((NumericType)realType3);
            realType3.setReal(((RealType)regionOfInterestCursor.getType()).getRealDouble());
            realType3.setComplex(((RealType)regionOfInterestCursor.getType()).getComplexDouble());
            realType2.mul((NumericType)realType3);
            realType.add((NumericType)realType2);
        }
        ((RealType)localizableByDimCursor.getType()).set((Type)realType);
        return true;
    }

    public boolean checkInput() {
        if (super.checkInput()) {
            if (this.kernel.getNumDimensions() == this.getOutputImage().getNumActiveCursors()) {
                this.setErrorMessage("Kernel has different dimensionality than the Image");
                return false;
            }
            return true;
        }
        return false;
    }
}

