/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.function.NormMinMax;
import mpicbg.imglib.algorithm.math.ComputeMinMax;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.util.RealSum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizeImageMinMax<T extends RealType<T>>
implements Algorithm,
MultiThreaded {
    final Image<T> image;
    String errorMessage = "";
    int numThreads;

    public NormalizeImageMinMax(Image<T> image) {
        this.setNumThreads();
        this.image = image;
    }

    public boolean process() {
        double d;
        ComputeMinMax<T> computeMinMax = new ComputeMinMax<T>(this.image);
        computeMinMax.setNumThreads(this.getNumThreads());
        if (!computeMinMax.checkInput() || !computeMinMax.process()) {
            this.errorMessage = "Cannot compute min and max: " + computeMinMax.getErrorMessage();
            return false;
        }
        double d2 = ((RealType)computeMinMax.getMin()).getRealDouble();
        if (d2 == (d = ((RealType)computeMinMax.getMax()).getRealDouble())) {
            this.errorMessage = "Min and Max of the image are equal";
            return false;
        }
        ImageConverter<T, T> imageConverter = new ImageConverter<T, T>(this.image, this.image, new NormMinMax(d2, d));
        imageConverter.setNumThreads(this.getNumThreads());
        if (!imageConverter.checkInput() || !imageConverter.process()) {
            this.errorMessage = "Cannot divide by value: " + imageConverter.getErrorMessage();
            return false;
        }
        return true;
    }

    public static <T extends RealType<T>> double sumImage(Image<T> image) {
        RealSum realSum = new RealSum();
        Cursor cursor = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            realSum.add(((RealType)cursor.getType()).getRealDouble());
        }
        cursor.close();
        return realSum.getSum();
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "NormalizeImageReal: [Image<T> image] is null.";
            return false;
        }
        return true;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

