/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.util.RealSum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizeImageFloat<T extends RealType<T>>
implements OutputAlgorithm<FloatType>,
Benchmark {
    private final Image<T> image;
    private Image<FloatType> outputImage = null;
    private String errorMsg = "";
    private long pTime = 0L;

    public static <T extends RealType<T>> double sumImage(Image<T> image) {
        RealSum realSum = new RealSum();
        Cursor cursor = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            realSum.add((double)((RealType)cursor.getType()).getRealFloat());
        }
        cursor.close();
        return realSum.getSum();
    }

    public NormalizeImageFloat(Image<T> image) {
        this.image = image;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        double d = NormalizeImageFloat.sumImage(this.image);
        int[] nArray = this.image.getDimensions();
        ImageFactory imageFactory = new ImageFactory((Type)new FloatType(), this.image.getContainerFactory());
        if (d == 0.0) {
            this.errorMsg = "Zero Sum Image";
            return false;
        }
        this.outputImage = imageFactory.createImage(nArray);
        LocalizableByDimCursor localizableByDimCursor = this.outputImage.createLocalizableByDimCursor();
        LocalizableCursor localizableCursor = this.image.createLocalizableCursor();
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableByDimCursor.setPosition((Localizable)localizableCursor);
            ((FloatType)localizableByDimCursor.getType()).set((float)((double)((RealType)localizableCursor.getType()).getRealFloat() / d));
        }
        this.pTime = System.currentTimeMillis() - l;
        localizableCursor.close();
        localizableByDimCursor.close();
        return true;
    }

    public Image<FloatType> getResult() {
        return this.outputImage;
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public long getProcessingTime() {
        return this.pTime;
    }
}

