/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageConverter<S extends Type<S>, T extends Type<T>>
implements OutputAlgorithm<T>,
MultiThreaded,
Benchmark {
    final Image<S> image;
    final Image<T> output;
    final Converter<S, T> converter;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public ImageConverter(Image<S> image, Image<T> image2, Converter<S, T> converter) {
        this.image = image;
        this.output = image2;
        this.converter = converter;
        this.setNumThreads();
    }

    public ImageConverter(Image<S> image, ImageFactory<T> imageFactory, Converter<S, T> converter) {
        this(image, ImageConverter.createImageFromFactory(imageFactory, image.getDimensions()), converter);
    }

    public Image<T> getResult() {
        return this.output;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ImageCalculator: [Image<S> image1] is null.";
            return false;
        }
        if (this.output == null) {
            this.errorMessage = "ImageCalculator: [Image<T> output] is null.";
            return false;
        }
        if (this.converter == null) {
            this.errorMessage = "ImageCalculator: [Converter<S,T>] is null.";
            return false;
        }
        if (!this.image.getContainer().compareStorageContainerDimensions(this.output.getContainer())) {
            this.errorMessage = "ImageCalculator: Images have different dimensions, not supported: Image: " + Util.printCoordinates((int[])this.image.getDimensions()) + " Output: " + Util.printCoordinates((int[])this.output.getDimensions());
            return false;
        }
        return true;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        long l2 = this.image.getNumPixels();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.getNumThreads());
        final Vector vector = SimpleMultiThreading.divideIntoChunks((long)l2, (int)this.numThreads);
        final boolean bl = this.image.getContainer().compareStorageContainerCompatibility(this.output.getContainer());
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n = atomicInteger.getAndIncrement();
                    Chunk chunk = (Chunk)vector.get(n);
                    if (bl) {
                        ImageConverter.this.computeSimple(chunk.getStartPosition(), chunk.getLoopSize());
                    } else {
                        ImageConverter.this.computeAdvanced(chunk.getStartPosition(), chunk.getLoopSize());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected void computeSimple(long l, long l2) {
        Cursor cursor = this.image.createCursor();
        Cursor cursor2 = this.output.createCursor();
        cursor.fwd(l);
        cursor2.fwd(l);
        for (long i = 0L; i < l2; ++i) {
            cursor.fwd();
            cursor2.fwd();
            this.converter.convert(cursor.getType(), cursor2.getType());
        }
        cursor.close();
        cursor2.close();
    }

    protected void computeAdvanced(long l, long l2) {
        LocalizableByDimCursor localizableByDimCursor = this.image.createLocalizableByDimCursor();
        LocalizableCursor localizableCursor = this.output.createLocalizableCursor();
        localizableCursor.fwd(l);
        for (long i = 0L; i < l2; ++i) {
            localizableCursor.fwd();
            localizableByDimCursor.setPosition((Localizable)localizableCursor);
            this.converter.convert(localizableByDimCursor.getType(), localizableCursor.getType());
        }
        localizableByDimCursor.close();
        localizableCursor.close();
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    protected static <T extends Type<T>> Image<T> createImageFromFactory(ImageFactory<T> imageFactory, int[] nArray) {
        if (imageFactory == null || nArray == null) {
            return null;
        }
        return imageFactory.createImage(nArray);
    }
}

