/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.algorithm.labeling.AllConnectedComponents;
import mpicbg.imglib.algorithm.labeling.Watershed;
import mpicbg.imglib.algorithm.math.ComputeMinMax;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.algorithm.math.PickImagePeaks;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientWatershed<T extends RealType<T>, L extends Comparable<L>>
implements OutputAlgorithm<LabelingType<L>> {
    protected Image<T> input;
    protected Labeling<L> output;
    protected double[] scale;
    protected double[] sigma1;
    protected double[] sigma2;
    protected Iterator<L> names;
    protected double minBackgroundPeakHeight = 0.0;
    protected double minForegroundPeakHeight = 0.0;
    protected boolean wantsToQuantize = true;
    protected int numQuanta = 100;
    protected int[][] structuringElement;
    protected String error_message;
    protected ImageFactory<LabelingType<L>> labelingFactory;
    protected Image<FloatType> floatImage;
    protected ImageFactory<FloatType> floatFactory;

    public GradientWatershed(Image<T> image, double[] dArray, double[] dArray2, double[] dArray3, Iterator<L> iterator) {
        this.input = image;
        this.scale = dArray;
        this.sigma1 = dArray2;
        this.sigma2 = dArray3;
        this.structuringElement = AllConnectedComponents.getStructuringElement(image.getNumDimensions());
        this.names = iterator;
        this.labelingFactory = new ImageFactory((Type)new LabelingType(), image.getContainerFactory());
    }

    public int[][] getStructuringElement() {
        return GradientWatershed.cloneStructuringElement(this.structuringElement);
    }

    protected static int[][] cloneStructuringElement(int[][] nArray) {
        int[][] nArray2 = (int[][])nArray.clone();
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (int[])nArray2[i].clone();
        }
        return nArray2;
    }

    public void setStructuringElement(int[][] nArray) {
        this.structuringElement = GradientWatershed.cloneStructuringElement(nArray);
    }

    public double[] getScale() {
        return (double[])this.scale.clone();
    }

    public void setScale(double[] dArray) {
        this.scale = (double[])dArray.clone();
    }

    public void setMinBackgroundPeakHeight(double d) {
        this.minBackgroundPeakHeight = d;
    }

    public double getMinBackgroundPeakHeight() {
        return this.minBackgroundPeakHeight;
    }

    public void setMinForegroundPeakHeight(double d) {
        this.minForegroundPeakHeight = d;
    }

    public double getMinForegroundPeakHeight() {
        return this.minForegroundPeakHeight;
    }

    public void enableQuantization(boolean bl) {
        this.wantsToQuantize = bl;
    }

    public boolean isQuantized() {
        return this.wantsToQuantize;
    }

    public void setNumQuanta(int n) {
        this.numQuanta = n;
    }

    public void setOutputImageFactory(ImageFactory<LabelingType<L>> imageFactory) {
        this.labelingFactory = imageFactory;
    }

    public ImageFactory<LabelingType<L>> getOutputImageFactory() {
        return this.labelingFactory;
    }

    public void setOutputLabeling(Labeling<L> labeling) {
        this.output = labeling;
    }

    public int getNumQuanta() {
        return this.numQuanta;
    }

    public boolean checkInput() {
        if (this.error_message.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.error_message = "The input image is null.";
            return false;
        }
        if (this.scale == null) {
            this.error_message = "The scale is null.";
            return false;
        }
        if (this.sigma1 == null) {
            this.error_message = "The first smoothing standard deviation (sigma1) is null.";
            return false;
        }
        if (this.sigma2 == null) {
            this.error_message = "The second smoothing standard deviation (sigma2) is null.";
            return false;
        }
        if (this.structuringElement == null) {
            this.error_message = "The structuring element is null.";
            return false;
        }
        if (this.names == null) {
            this.error_message = "The names iterator is null.";
        }
        if (!this.checkDimensions(this.scale)) {
            this.error_message = "The dimensions of the scale do not match those of the image";
            return false;
        }
        if (!this.checkDimensions(this.sigma1)) {
            this.error_message = "The dimensions of sigma1 do not match those of the image";
            return false;
        }
        if (!this.checkDimensions(this.sigma2)) {
            this.error_message = "The dimensions of sigma2 do not match those of the image";
            return false;
        }
        int[][] nArray = this.structuringElement;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2 == null) {
                this.error_message = "One of the coordinates of the structuring element is null.";
                return false;
            }
            if (this.checkDimensions(nArray2)) continue;
            this.error_message = "The dimensions of one of the coordinates of the structuring element does not match those of the image.";
            return false;
        }
        if (this.wantsToQuantize && this.numQuanta < 2) {
            this.error_message = String.format("The number of quanta is %d, but must be at least 2 (and ideally > 20).", this.numQuanta);
            return false;
        }
        for (int i = 0; i < this.sigma1.length; ++i) {
            if (!(this.sigma1[i] <= this.sigma2[i])) continue;
            this.error_message = String.format("All values of sigma1 should be greater than sigma2. For dimension %d, sigma1=%f, sigma2=%f", i, this.sigma1[i], this.sigma2[i]);
            return false;
        }
        if (this.output != null) {
            int[] nArray3 = this.output.getDimensions();
            if (!this.checkDimensions(nArray3)) {
                this.error_message = "The labeling container does not have the correct number of dimensions";
                return false;
            }
            for (n = 0; n < nArray3.length; ++n) {
                if (nArray3[n] == this.input.getDimension(n)) continue;
                this.error_message = String.format("The labeling container is not the same size as the image: dimension %d, labeling = %d, image = %d", n, nArray3[n], this.input.getDimension(n));
                return false;
            }
        }
        return true;
    }

    protected boolean checkDimensions(int[] nArray) {
        return nArray.length == this.input.getNumDimensions();
    }

    protected boolean checkDimensions(double[] dArray) {
        return dArray.length == this.input.getNumDimensions();
    }

    public boolean process() {
        Object object4;
        Object object22;
        Object object3;
        Image<FloatType> image;
        this.floatImage = null;
        if (this.output == null) {
            this.output = new Labeling(this.labelingFactory, this.input.getDimensions(), null);
        } else {
            image = this.output.createLocalizableCursor();
            object3 = ((LabelingType)image.getType()).intern(new ArrayList());
            for (Object object22 : image) {
                object22.setLabeling((List)object3);
            }
            image.close();
        }
        image = FourierConvolution.createGaussianKernel(this.input.getContainerFactory(), this.scale);
        object3 = new FourierConvolution<FloatType, FloatType>(this.getFloatImage(), image);
        if (!((FourierConvolution)object3).process()) {
            return false;
        }
        Image image2 = ((FourierConvolution)object3).getResult();
        object22 = new PickImagePeaks(image2);
        ((PickImagePeaks)object22).setSuppression(this.scale);
        ((PickImagePeaks)object22).process();
        Labeling labeling = this.output.createNewLabeling();
        LocalizableByDimCursor localizableByDimCursor = labeling.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor2 = image2.createLocalizableByDimCursor();
        int[] nArray = this.input.getDimensions();
        for (Object object4 : ((PickImagePeaks)object22).getPeakList()) {
            if (!this.filterPeak((LocalizableByDimCursor<FloatType>)localizableByDimCursor2, (int[])object4, nArray, false)) continue;
            localizableByDimCursor.setPosition(object4);
            ((LabelingType)localizableByDimCursor.getType()).setLabel((Comparable)this.names.next());
        }
        localizableByDimCursor2.close();
        List list = ((LabelingType)localizableByDimCursor.getType()).intern((Comparable)this.names.next());
        object4 = new Converter<FloatType, FloatType>(){

            public void convert(FloatType floatType, FloatType floatType2) {
                floatType2.setReal(-floatType.getRealFloat());
            }
        };
        ImageConverter imageConverter = new ImageConverter(image2, image2, object4);
        imageConverter.process();
        object22 = new PickImagePeaks(image2);
        ((PickImagePeaks)object22).setSuppression(this.scale);
        ((PickImagePeaks)object22).process();
        localizableByDimCursor2 = image2.createLocalizableByDimCursor();
        for (int[] nArray2 : ((PickImagePeaks)object22).getPeakList()) {
            if (!this.filterPeak((LocalizableByDimCursor<FloatType>)localizableByDimCursor2, nArray2, nArray, true)) continue;
            localizableByDimCursor.setPosition(nArray2);
            ((LabelingType)localizableByDimCursor.getType()).setLabeling(list);
        }
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
        image2 = null;
        imageConverter = null;
        Iterator<int[]> iterator = this.getGradientImage();
        if (iterator == null) {
            return false;
        }
        Watershed.seededWatershed(iterator, labeling, this.structuringElement, this.output);
        return true;
    }

    protected ImageFactory<FloatType> getFloatFactory() {
        if (this.floatFactory == null) {
            this.floatFactory = new ImageFactory((Type)new FloatType(), this.input.getContainerFactory());
        }
        return this.floatFactory;
    }

    protected Image<FloatType> getFloatImage() {
        if (this.floatImage == null) {
            ImageConverter<FloatType, FloatType> imageConverter = new ImageConverter<FloatType, FloatType>((Image<FloatType>)this.input, this.getFloatFactory(), (Converter<FloatType, FloatType>)new RealTypeConverter());
            if (!imageConverter.process()) {
                return null;
            }
            this.floatImage = imageConverter.getResult();
        }
        return this.floatImage;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public Image<LabelingType<L>> getResult() {
        return this.output;
    }

    protected boolean filterPeak(LocalizableByDimCursor<FloatType> localizableByDimCursor, int[] nArray, int[] nArray2, boolean bl) {
        double d = this.minForegroundPeakHeight;
        if (bl) {
            d = this.minBackgroundPeakHeight;
        }
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray.length];
        for (int i = 0; i < this.scale.length; ++i) {
            int n = (int)(this.scale[i] / 2.0) * 2 + 1;
            nArray3[i] = nArray[i] - n / 2;
            nArray4[i] = n;
            if (nArray3[i] < 0) {
                int n2 = i;
                nArray4[n2] = nArray4[n2] + nArray3[i];
                nArray3[i] = 0;
            }
            if (nArray3[i] + nArray4[i] < nArray2[i]) continue;
            nArray4[i] = nArray2[i] - nArray3[i] - 1;
        }
        localizableByDimCursor.setPosition(nArray);
        float f = ((FloatType)localizableByDimCursor.getType()).get();
        RegionOfInterestCursor regionOfInterestCursor = new RegionOfInterestCursor(localizableByDimCursor, nArray3, nArray4);
        for (FloatType floatType : regionOfInterestCursor) {
            double d2 = 0.0;
            regionOfInterestCursor.getPosition(nArray5);
            for (int i = 0; i < nArray5.length; ++i) {
                double d3 = (double)(nArray5[i] + nArray3[i] - nArray[i]) / this.scale[i];
                d2 += d3 * d3;
            }
            if (!(d2 <= 1.0) || !(bl ? (double)((FloatType)regionOfInterestCursor.getType()).get() > (double)f + d : (double)((FloatType)regionOfInterestCursor.getType()).get() < (double)f - d)) continue;
            return true;
        }
        System.err.format("Filtered at %d, %d\n", nArray[0], nArray[1]);
        regionOfInterestCursor.close();
        return false;
    }

    public Image<FloatType> getGradientImage() {
        Image image3;
        double[][] dArrayArray = new double[this.input.getNumDimensions()][];
        double[][] dArrayArray2 = new double[this.input.getNumDimensions()][];
        int[] nArray = this.input.createPositionArray();
        int[] nArray2 = this.input.createPositionArray();
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = Util.createGaussianKernel1DDouble((double)this.sigma1[i], (boolean)true);
            dArrayArray2[i] = Util.createGaussianKernel1DDouble((double)this.sigma2[i], (boolean)true);
            nArray[i] = dArrayArray[i].length;
            nArray2[i] = (dArrayArray[i].length - dArrayArray2[i].length) / 2;
        }
        Image image2 = this.getFloatFactory().createImage(nArray);
        LocalizableCursor localizableCursor = image2.createLocalizableCursor();
        int[] nArray3 = this.input.createPositionArray();
        for (Image image3 : localizableCursor) {
            localizableCursor.getPosition(nArray3);
            double d = 1.0;
            double d2 = 1.0;
            for (int i = 0; i < dArrayArray.length; ++i) {
                d *= dArrayArray[i][nArray3[i]];
                int n = nArray3[i] - nArray2[i];
                if (n >= 0 && n < dArrayArray2[i].length) {
                    d2 *= dArrayArray2[i][n];
                    continue;
                }
                d2 = 0.0;
            }
            image3.setReal(d - d2);
        }
        localizableCursor.close();
        FourierConvolution fourierConvolution = new FourierConvolution(this.getFloatImage(), image2);
        if (!fourierConvolution.process()) {
            return null;
        }
        image3 = fourierConvolution.getResult();
        ComputeMinMax computeMinMax = new ComputeMinMax(image3);
        computeMinMax.process();
        final float f = ((FloatType)computeMinMax.getMin()).get();
        final float f2 = ((FloatType)computeMinMax.getMax()).get();
        if (f2 == f) {
            return image3;
        }
        ImageConverter<FloatType, FloatType> imageConverter = new ImageConverter<FloatType, FloatType>(image3, image3.getImageFactory(), new Converter<FloatType, FloatType>(){

            public void convert(FloatType floatType, FloatType floatType2) {
                float f3 = (floatType.get() - f) / (f2 - f);
                f3 = Math.round(f3 * 100.0f);
                floatType2.set(f3);
            }
        });
        imageConverter.process();
        return imageConverter.getResult();
    }
}

