/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree.node;

import mpicbg.imglib.algorithm.kdtree.node.Leaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNode
implements Leaf<SimpleNode> {
    final float[] p;
    final int numDimensions;

    public SimpleNode(SimpleNode simpleNode) {
        this.p = (float[])simpleNode.p.clone();
        this.numDimensions = this.p.length;
    }

    public SimpleNode(float[] fArray) {
        this.p = (float[])fArray.clone();
        this.numDimensions = fArray.length;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean equals(SimpleNode simpleNode) {
        if (simpleNode.getNumDimensions() != this.numDimensions) {
            return false;
        }
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.p[i] == simpleNode.p[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float distanceTo(SimpleNode simpleNode) {
        double d = 0.0;
        for (int i = 0; i < this.numDimensions; ++i) {
            double d2 = simpleNode.get(i) - this.get(i);
            d += d2 * d2;
        }
        return (float)Math.sqrt(d);
    }

    @Override
    public float get(int n) {
        return this.p[n];
    }

    public String toString() {
        String string = "(" + this.p[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.p[i];
        }
        string = string + ")";
        return string;
    }

    public SimpleNode[] createArray(int n) {
        return new SimpleNode[n];
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public SimpleNode getEntry() {
        return this;
    }
}

