/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import mpicbg.imglib.algorithm.kdtree.DistanceComparator;
import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.NNearestNeighborSearch;
import mpicbg.imglib.algorithm.kdtree.NearestNeighborSearch;
import mpicbg.imglib.algorithm.kdtree.RadiusNeighborSearch;
import mpicbg.imglib.algorithm.kdtree.node.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestKDTree {
    protected static boolean testNNearestNeighbor(int n, int n2, int n3, int n4, float f, float f2) {
        int n5;
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        Random random = new Random(435435435L);
        float[] fArray = new float[n2];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[j] = random.nextFloat() * (f2 - f) + f;
            }
            SimpleNode simpleNode = new SimpleNode(fArray);
            arrayList.add(simpleNode);
        }
        long l = System.currentTimeMillis();
        KDTree kDTree = new KDTree(arrayList);
        NNearestNeighborSearch nNearestNeighborSearch = new NNearestNeighborSearch(kDTree);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("kdtree setup took: " + l2 + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            SimpleNode simpleNode = new SimpleNode(fArray);
            SimpleNode[] simpleNodeArray = (SimpleNode[])nNearestNeighborSearch.findNNearestNeighbors(simpleNode, n);
            SimpleNode[] simpleNodeArray2 = TestKDTree.findNNearestNeighborExhaustive(arrayList, simpleNode, n);
            for (n5 = 0; n5 < n; ++n5) {
                if (simpleNodeArray[n5].equals(simpleNodeArray2[n5])) continue;
                System.out.println(n5 + 1 + " - Nearest neighbor to: " + simpleNode);
                System.out.println("KD-Tree says: " + simpleNodeArray[n5] + " (" + simpleNodeArray[n5].distanceTo(simpleNode) + ")");
                System.out.println("Exhaustive says: " + simpleNodeArray2[n5] + " (" + simpleNodeArray2[n5].distanceTo(simpleNode) + ")");
                return false;
            }
        }
        long l3 = System.currentTimeMillis() - l;
        System.out.println("comparison (kd-exhaustive) search took: " + l3 + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
        }
        long l4 = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        for (n5 = 0; n5 < n4; ++n5) {
            for (int i = 0; i < n2; ++i) {
                fArray[i] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            SimpleNode simpleNode = new SimpleNode(fArray);
            SimpleNode[] simpleNodeArray = (SimpleNode[])nNearestNeighborSearch.findNNearestNeighbors(simpleNode, n);
            simpleNodeArray.clone();
        }
        long l5 = System.currentTimeMillis() - l;
        System.out.println("kdtree search took: " + (l5 - l4) + " ms.");
        System.out.println("kdtree all together took: " + (l2 + l5 - l4) + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            SimpleNode simpleNode = new SimpleNode(fArray);
            SimpleNode[] simpleNodeArray = TestKDTree.findNNearestNeighborExhaustive(arrayList, simpleNode, n);
            simpleNodeArray.clone();
        }
        long l6 = System.currentTimeMillis() - l;
        System.out.println("exhaustive search took: " + (l6 - l4) + " ms.");
        return true;
    }

    protected static boolean testRadiusSearch(int n, int n2, int n3, float f, float f2) {
        int n4;
        SimpleNode simpleNode;
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        Random random = new Random(435435435L);
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (f2 - f) + f;
            }
            SimpleNode simpleNode2 = new SimpleNode(fArray);
            arrayList.add(simpleNode2);
        }
        long l = System.currentTimeMillis();
        KDTree kDTree = new KDTree(arrayList);
        RadiusNeighborSearch radiusNeighborSearch = new RadiusNeighborSearch(kDTree);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("kdtree setup took: " + l2 + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            double d = random.nextDouble() * (double)(f2 - f) / 10.0;
            simpleNode = new SimpleNode(fArray);
            ArrayList<SimpleNode> arrayList2 = radiusNeighborSearch.findNeighborsSorted(simpleNode, d);
            ArrayList<SimpleNode> arrayList3 = TestKDTree.findNeighborsRadiusExhaustive(arrayList, simpleNode, d);
            if (arrayList2.size() != arrayList3.size()) {
                System.out.println("Not same number of points within radius(" + d + ") of " + simpleNode + " found, kdTree = " + arrayList2.size() + ", exhaustive = " + arrayList3.size());
                System.out.println("KDTree:");
                for (SimpleNode simpleNode3 : arrayList2) {
                    System.out.println(simpleNode3 + ", distance: " + simpleNode3.distanceTo(simpleNode));
                }
                System.out.println("Exhaustive:");
                for (SimpleNode simpleNode3 : arrayList3) {
                    System.out.println(simpleNode3 + ", distance: " + simpleNode3.distanceTo(simpleNode));
                }
                return false;
            }
            n4 = 1;
            for (int j = 0; j < arrayList2.size(); ++j) {
                if (arrayList2.get(j) == arrayList3.get(j) || arrayList2.get(j).distanceTo(simpleNode) == arrayList3.get(j).distanceTo(simpleNode)) continue;
                System.out.println("Point " + j + " disagrees within radius(" + d + ") of " + simpleNode + " found, \n\tkdTree = " + arrayList2.get(j) + ", distance: " + arrayList2.get(j).distanceTo(simpleNode) + ", \n\texhaustive = " + arrayList3.get(j) + ", distance: " + arrayList3.get(j).distanceTo(simpleNode));
                n4 = 0;
            }
            if (n4 != 0) continue;
            return false;
        }
        long l3 = System.currentTimeMillis() - l;
        System.out.println("comparison (kdtree <-> exhaustive) successfull, took: " + l3 + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            simpleNode = new SimpleNode(fArray);
            simpleNode.getClass();
        }
        long l4 = System.currentTimeMillis() - l;
        double d = (f2 - f) / 20.0f;
        l = System.currentTimeMillis();
        for (n4 = 0; n4 < n3; ++n4) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = random.nextFloat() * (f2 - f) + f;
            }
            SimpleNode simpleNode4 = new SimpleNode(fArray);
            ArrayList<SimpleNode> arrayList4 = radiusNeighborSearch.findNeighborsSorted(simpleNode4, d);
            arrayList4.getClass();
        }
        long l5 = System.currentTimeMillis() - l;
        System.out.println("kdtree search took: " + (l5 - l4) + " ms.");
        System.out.println("kdtree all together took: " + (l2 + l5 - l4) + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (f2 - f) + f;
            }
            SimpleNode simpleNode5 = new SimpleNode(fArray);
            ArrayList<SimpleNode> arrayList5 = TestKDTree.findNeighborsRadiusExhaustive(arrayList, simpleNode5, d);
            arrayList5.getClass();
        }
        long l6 = System.currentTimeMillis() - l;
        System.out.println("exhaustive search took: " + (l6 - l4) + " ms.");
        return true;
    }

    protected static boolean testNearestNeighbor(int n, int n2, int n3, float f, float f2) {
        SimpleNode simpleNode;
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        Random random = new Random(435435435L);
        float[] fArray = new float[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (f2 - f) + f;
            }
            SimpleNode simpleNode2 = new SimpleNode(fArray);
            arrayList.add(simpleNode2);
        }
        long l = System.currentTimeMillis();
        KDTree kDTree = new KDTree(arrayList);
        NearestNeighborSearch nearestNeighborSearch = new NearestNeighborSearch(kDTree);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("kdtree setup took: " + l2 + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            SimpleNode simpleNode3 = new SimpleNode(fArray);
            SimpleNode simpleNode4 = nearestNeighborSearch.findNearestNeighbor(simpleNode3);
            if (simpleNode4.equals(simpleNode = TestKDTree.findNearestNeighborExhaustive(arrayList, simpleNode3))) continue;
            System.out.println("Nearest neighbor to: " + simpleNode3);
            System.out.println("KD-Tree says: " + simpleNode4);
            System.out.println("Exhaustive says: " + simpleNode);
            return false;
        }
        long l3 = System.currentTimeMillis() - l;
        System.out.println("comparison (kdtree <-> exhaustive) search took: " + l3 + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            simpleNode = new SimpleNode(fArray);
            simpleNode.getClass();
        }
        long l4 = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            SimpleNode simpleNode5 = new SimpleNode(fArray);
            SimpleNode simpleNode6 = nearestNeighborSearch.findNearestNeighbor(simpleNode5);
            simpleNode6.getClass();
        }
        long l5 = System.currentTimeMillis() - l;
        System.out.println("kdtree search took: " + (l5 - l4) + " ms.");
        System.out.println("kdtree all together took: " + (l2 + l5 - l4) + " ms.");
        l = System.currentTimeMillis();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[j] = random.nextFloat() * (2.0f * f2 - 2.0f * f) + 2.0f * f;
            }
            SimpleNode simpleNode7 = new SimpleNode(fArray);
            SimpleNode simpleNode8 = TestKDTree.findNearestNeighborExhaustive(arrayList, simpleNode7);
            simpleNode8.getClass();
        }
        long l6 = System.currentTimeMillis() - l;
        System.out.println("exhaustive search took: " + (l6 - l4) + " ms.");
        return true;
    }

    private static SimpleNode findNearestNeighborExhaustive(ArrayList<SimpleNode> arrayList, SimpleNode simpleNode) {
        float f = Float.MAX_VALUE;
        SimpleNode simpleNode2 = null;
        for (SimpleNode simpleNode3 : arrayList) {
            float f2 = simpleNode3.distanceTo(simpleNode);
            if (!(f2 < f)) continue;
            f = f2;
            simpleNode2 = simpleNode3;
        }
        return new SimpleNode(simpleNode2);
    }

    private static ArrayList<SimpleNode> findNeighborsRadiusExhaustive(ArrayList<SimpleNode> arrayList, SimpleNode simpleNode, double d) {
        ArrayList<SimpleNode> arrayList2 = new ArrayList<SimpleNode>();
        for (SimpleNode simpleNode2 : arrayList) {
            float f = simpleNode2.distanceTo(simpleNode);
            if (!((double)f <= d)) continue;
            arrayList2.add(simpleNode2);
        }
        Collections.sort(arrayList2, new DistanceComparator<SimpleNode>(simpleNode));
        return arrayList2;
    }

    private static SimpleNode[] findNNearestNeighborExhaustive(ArrayList<SimpleNode> arrayList, SimpleNode simpleNode, int n) {
        SimpleNode[] simpleNodeArray = new SimpleNode[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.MAX_VALUE;
        }
        block1: for (SimpleNode simpleNode2 : arrayList) {
            float f = simpleNode2.distanceTo(simpleNode);
            for (int i = 0; i < n; ++i) {
                if (!(f < fArray[i])) continue;
                for (int j = n - 2; j >= i; --j) {
                    simpleNodeArray[j + 1] = simpleNodeArray[j];
                    fArray[j + 1] = fArray[j];
                }
                simpleNodeArray[i] = simpleNode2;
                fArray[i] = f;
                continue block1;
            }
        }
        return simpleNodeArray;
    }

    public static void main(String[] stringArray) {
        if (TestKDTree.testRadiusSearch(3, 100000, 1000, -100.0f, 100.0f)) {
            System.out.println("Radius neighbor test (3) successfull\n");
        }
        if (TestKDTree.testNNearestNeighbor(3, 3, 100000, 1000, -5.0f, 5.0f)) {
            System.out.println("N-Nearest neighbor test (3) successfull\n");
        }
        if (TestKDTree.testNearestNeighbor(3, 100000, 1000, -5.0f, 5.0f)) {
            System.out.println("Nearest neighbor test successfull\n");
        }
    }
}

