/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import java.util.ArrayList;
import java.util.Collections;
import mpicbg.imglib.algorithm.kdtree.DistanceComparator;
import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.kdtree.node.Node;
import mpicbg.imglib.algorithm.kdtree.node.NonLeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiusNeighborSearch<T extends Leaf<T>> {
    protected final KDTree<T> kdTree;
    protected ArrayList<T> pointsWithinRadius;
    protected double radius;

    public RadiusNeighborSearch(KDTree<T> kDTree) {
        this.kdTree = kDTree;
    }

    public KDTree<T> getKDTree() {
        return this.kdTree;
    }

    public ArrayList<T> findNeighborsUnsorted(T t, double d) {
        this.pointsWithinRadius = new ArrayList();
        this.radius = d;
        this.findNeighbors(t, this.kdTree.getRoot(), 0);
        return this.pointsWithinRadius;
    }

    public ArrayList<T> findNeighborsSorted(T t, double d) {
        this.findNeighborsUnsorted(t, d);
        Collections.sort(this.pointsWithinRadius, new DistanceComparator<T>(t));
        return this.pointsWithinRadius;
    }

    protected void findNeighbors(T t, Node<T> node, int n) {
        if (node.isLeaf()) {
            T t2 = ((Leaf)node).getEntry();
            double d = t2.distanceTo(t);
            if (d <= this.radius) {
                this.pointsWithinRadius.add(t2);
            }
        } else {
            int n2 = n % this.kdTree.getDimension();
            NonLeaf nonLeaf = (NonLeaf)node;
            if (nonLeaf.right == null) {
                this.findNeighbors(t, nonLeaf.left, n + 1);
            } else if (nonLeaf.left == null) {
                this.findNeighbors(t, nonLeaf.right, n + 1);
            } else {
                float f = nonLeaf.coordinate - t.get(n2);
                boolean bl = f < 0.0f;
                this.findNeighbors(t, bl ? nonLeaf.right : nonLeaf.left, n + 1);
                if ((double)Math.abs(f) <= this.radius) {
                    this.findNeighbors(t, bl ? nonLeaf.left : nonLeaf.right, n + 1);
                }
            }
        }
    }
}

