/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.kdtree.node.Node;
import mpicbg.imglib.algorithm.kdtree.node.NonLeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearestNeighborSearch<T extends Leaf<T>> {
    protected final KDTree<T> kdTree;
    private T bestPointSoFar;

    public NearestNeighborSearch(KDTree<T> kDTree) {
        this.kdTree = kDTree;
    }

    public KDTree<T> getKDTree() {
        return this.kdTree;
    }

    public T findNearestNeighbor(T t) {
        this.bestPointSoFar = null;
        return this.findNearestNeighbor(t, this.kdTree.getRoot(), 0);
    }

    protected T findNearestNeighbor(T t, Node<T> node, int n) {
        T t2;
        if (node.isLeaf()) {
            if (this.bestPointSoFar == null) {
                this.bestPointSoFar = ((Leaf)node).getEntry();
            }
            Object object = ((Leaf)node).getEntry();
            if (t.distanceTo(this.bestPointSoFar) < t.distanceTo(object)) {
                object = this.bestPointSoFar;
            }
            return (T)object;
        }
        int n2 = n % this.kdTree.getDimension();
        NonLeaf nonLeaf = (NonLeaf)node;
        if (nonLeaf.right == null) {
            return this.findNearestNeighbor(t, nonLeaf.left, n + 1);
        }
        if (nonLeaf.left == null) {
            return this.findNearestNeighbor(t, nonLeaf.right, n + 1);
        }
        float f = nonLeaf.coordinate - t.get(n2);
        boolean bl = f < 0.0f;
        T t3 = this.findNearestNeighbor(t, bl ? nonLeaf.right : nonLeaf.left, n + 1);
        float f2 = t.distanceTo(t3);
        if (f2 > Math.abs(f) && t.distanceTo(t2 = this.findNearestNeighbor(t, bl ? nonLeaf.left : nonLeaf.right, n + 1)) < f2) {
            return t2;
        }
        return t3;
    }
}

