/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import java.util.Arrays;
import mpicbg.imglib.algorithm.kdtree.DistanceComparator;
import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.kdtree.node.Node;
import mpicbg.imglib.algorithm.kdtree.node.NonLeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNearestNeighborSearch<T extends Leaf<T>> {
    protected final KDTree<T> kdTree;

    public NNearestNeighborSearch(KDTree<T> kDTree) {
        this.kdTree = kDTree;
    }

    public KDTree<T> getKDTree() {
        return this.kdTree;
    }

    public T[] findNNearestNeighbors(T t, int n) {
        Leaf[] leafArray = t.createArray(n);
        int n2 = this.findNNearestNeighbors((Leaf)t, this.kdTree.getRoot(), 0, 0, leafArray);
        if (n2 < leafArray.length) {
            Leaf[] leafArray2 = t.createArray(n2);
            for (int i = 0; i < n2; ++i) {
                leafArray2[i] = leafArray[i];
            }
            return leafArray2;
        }
        return leafArray;
    }

    public int findNNearestNeighbors(T t, Node<T> node, int n, int n2, T[] TArray) {
        if (node.isLeaf()) {
            int n3;
            Object n4 = ((Leaf)node).getEntry();
            if (n2 == 0) {
                TArray[0] = n4;
                return 1;
            }
            if (n2 < TArray.length) {
                for (n3 = 0; n3 < n2 && t.distanceTo(TArray[n3]) < t.distanceTo(n4); ++n3) {
                }
            } else {
                n3 = Arrays.binarySearch(TArray, n4, new DistanceComparator<T>(t));
                if (n3 < 0) {
                    n3 = -1 - n3;
                }
            }
            if (n3 < TArray.length) {
                if (n2 < TArray.length) {
                    if (n3 < n2) {
                        System.arraycopy(TArray, n3, TArray, n3 + 1, n2 - n3);
                    }
                    ++n2;
                } else if (n3 + 1 < TArray.length) {
                    System.arraycopy(TArray, n3, TArray, n3 + 1, TArray.length - n3 - 1);
                }
                TArray[n3] = n4;
            }
            return n2;
        }
        int n5 = n % this.kdTree.getDimension();
        NonLeaf nonLeaf = (NonLeaf)node;
        if (nonLeaf.right == null) {
            return this.findNNearestNeighbors((Leaf)t, nonLeaf.left, n + 1, n2, (Leaf[])TArray);
        }
        if (nonLeaf.left == null) {
            return this.findNNearestNeighbors((Leaf)t, nonLeaf.right, n + 1, n2, (Leaf[])TArray);
        }
        float f = nonLeaf.coordinate - t.get(n5);
        boolean bl = f < 0.0f;
        n2 = this.findNNearestNeighbors((Leaf)t, bl ? nonLeaf.right : nonLeaf.left, n + 1, n2, (Leaf[])TArray);
        float f2 = t.distanceTo(TArray[n2 - 1]);
        if (n2 < TArray.length || f2 > Math.abs(f)) {
            n2 = this.findNNearestNeighbors((Leaf)t, bl ? nonLeaf.left : nonLeaf.right, n + 1, n2, (Leaf[])TArray);
        }
        return n2;
    }

    public String toString(T t) {
        if (t == null) {
            return "null";
        }
        int n = this.kdTree.getDimension();
        String string = "(" + t.get(0);
        for (int i = 1; i < n; ++i) {
            string = string + ", " + t.get(i);
        }
        return string + ")";
    }

    public String toString(T[] TArray, int n) {
        if (n == 0) {
            return "[]";
        }
        String string = "[" + this.toString(TArray[0]);
        for (int i = 1; i < n; ++i) {
            string = string + ", " + this.toString(TArray[i]);
        }
        return string + "]";
    }
}

