/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import mpicbg.imglib.algorithm.gauss.GaussianConvolution3;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.ExponentialMathType;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianConvolution4<A extends Type<A>, B extends ExponentialMathType<B>, C extends Type<C>>
extends GaussianConvolution3<A, B, C> {
    final B[] sigma;
    final B[][] kernel;
    final B entity;

    public GaussianConvolution4(Image<A> image, ImageFactory<B> imageFactory, ImageFactory<C> imageFactory2, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, Converter<A, B> converter, Converter<B, C> converter2, B[] BArray) {
        super(image, imageFactory, imageFactory2, outOfBoundsStrategyFactory, converter, converter2, 0.0);
        this.sigma = BArray;
        this.entity = (ExponentialMathType)BArray[0].createVariable();
        this.kernel = (ExponentialMathType[][])this.entity.createArray2D(this.numDimensions, 1);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.kernel[i] = Util.createGaussianKernel1D(BArray[i], (boolean)true);
        }
    }

    public GaussianConvolution4(Image<A> image, ImageFactory<B> imageFactory, ImageFactory<C> imageFactory2, OutOfBoundsStrategyFactory<B> outOfBoundsStrategyFactory, Converter<A, B> converter, Converter<B, C> converter2, B b) {
        this(image, imageFactory, imageFactory2, outOfBoundsStrategyFactory, converter, converter2, (ExponentialMathType[])GaussianConvolution4.createArray(image, b));
    }

    @Override
    protected void convolveDim(LocalizableByDimCursor<B> localizableByDimCursor, LocalizableCursor<B> localizableCursor, int n, long l, long l2) {
        this.convolve((LocalizableByDimCursor)localizableByDimCursor, (LocalizableCursor)localizableCursor, n, (ExponentialMathType[])this.kernel[n], l, l2);
    }

    protected void convolve(LocalizableByDimCursor<B> localizableByDimCursor, LocalizableCursor<B> localizableCursor, int n, B[] BArray, long l, long l2) {
        localizableCursor.fwd(l);
        int n2 = BArray.length;
        int n3 = n2 - 1;
        int n4 = n2 / 2;
        int n5 = n4 - 1;
        int n6 = localizableByDimCursor.getImage().getNumDimensions();
        int n7 = n4;
        int[] nArray = new int[n6];
        ExponentialMathType exponentialMathType = (ExponentialMathType)((ExponentialMathType)localizableByDimCursor.getType()).createVariable();
        ExponentialMathType exponentialMathType2 = (ExponentialMathType)((ExponentialMathType)localizableByDimCursor.getType()).createVariable();
        for (long i = 0L; i < l2; ++i) {
            localizableCursor.fwd();
            exponentialMathType.setZero();
            localizableCursor.getPosition(nArray);
            int n8 = n;
            nArray[n8] = nArray[n8] - n7;
            localizableByDimCursor.setPosition(nArray);
            for (int j = -n4; j <= n5; ++j) {
                exponentialMathType2.set(localizableByDimCursor.getType());
                exponentialMathType2.mul(BArray[j + n4]);
                exponentialMathType.add((NumericType)exponentialMathType2);
                localizableByDimCursor.fwd(n);
            }
            exponentialMathType2.set(localizableByDimCursor.getType());
            exponentialMathType2.mul(BArray[n3]);
            exponentialMathType.add((NumericType)exponentialMathType2);
            ((ExponentialMathType)localizableCursor.getType()).set((Type)exponentialMathType);
        }
    }

    @Override
    public int getKernelSize(int n) {
        return this.kernel[n].length;
    }

    protected static <B extends Type<B>> B[] createArray(Image<?> image, B b) {
        Type[] typeArray = b.createArray1D(image.getNumDimensions());
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            typeArray[i] = b.copy();
        }
        return typeArray;
    }

    protected static int[] createArray2(Image<?> image, int n) {
        int[] nArray = new int[image.getNumDimensions()];
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            nArray[i] = n;
        }
        return nArray;
    }
}

