/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution3;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.real.FloatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianConvolution<T extends NumericType<T>>
extends GaussianConvolution3<T, T, T> {
    public GaussianConvolution(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double[] dArray) {
        super(image, null, null, outOfBoundsStrategyFactory, null, null, dArray);
    }

    public GaussianConvolution(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, double d) {
        this(image, outOfBoundsStrategyFactory, GaussianConvolution.createArray(image, d));
    }

    @Override
    protected Image<T> getTempImage1(int n) {
        if (n == 0) {
            this.temp1 = this.image;
        } else if (n == 1) {
            this.temp1 = this.image.createNewImage();
        }
        return this.temp1;
    }

    @Override
    protected Image<T> getTempImage2(int n) {
        if (n == 0) {
            this.temp2 = this.image.createNewImage();
        }
        return this.temp2;
    }

    @Override
    protected Image<T> getConvolvedImage() {
        Image image;
        if (this.numDimensions % 2 == 0) {
            image = this.temp1;
            this.temp2.close();
        } else {
            image = this.temp2;
            this.temp1.close();
        }
        return image;
    }

    @Override
    protected boolean processWithOptimizedMethod() {
        if (Array3D.class.isInstance(this.image.getContainer()) && FloatType.class.isInstance(this.image.createType())) {
            this.convolved = GaussianConvolution.computeGaussFloatArray3D(this.image, this.outOfBoundsFactory, this.kernel, this.getNumThreads());
            return true;
        }
        return false;
    }

    protected static <T extends NumericType<T>> Image<T> computeGaussFloatArray3D(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, final double[][] dArray, final int n) {
        int n2;
        final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory2 = outOfBoundsStrategyFactory;
        final Image<T> image2 = image;
        final Image image3 = image2.createNewImage();
        final FloatArray floatArray = (FloatArray)((DirectAccessContainer)image2.getContainer()).update(null);
        final FloatArray floatArray2 = (FloatArray)((DirectAccessContainer)image3.getContainer()).update(null);
        final Array3D array3D = (Array3D)image2.getContainer();
        final Array3D array3D2 = (Array3D)image3.getContainer();
        final int n3 = image2.getDimension(0);
        final int n4 = image2.getDimension(1);
        final int n5 = image2.getDimension(2);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)n);
        for (n2 = 0; n2 < threadArray.length; ++n2) {
            threadArray[n2] = new Thread(new Runnable(){

                public void run() {
                    int n7;
                    int n2 = atomicInteger.getAndIncrement();
                    float[] fArray = floatArray.getCurrentStorageArray();
                    float[] fArray2 = floatArray2.getCurrentStorageArray();
                    double[] dArray2 = (double[])dArray[0].clone();
                    int n32 = dArray[0].length;
                    int n42 = n32 / 2;
                    LocalizableByDimCursor3D localizableByDimCursor3D = (LocalizableByDimCursor3D)image2.createLocalizableByDimCursor(outOfBoundsStrategyFactory2);
                    int[] nArray = new int[dArray2.length];
                    for (int i = -n42; i <= n42; ++i) {
                        nArray[i + n42] = i;
                    }
                    boolean[] blArray = new boolean[n3];
                    for (n7 = 0; n7 < n3; ++n7) {
                        blArray[n7] = n7 - n42 >= 0 && n7 + n42 < n3;
                    }
                    for (n7 = 0; n7 < n5; ++n7) {
                        if (n7 % n != n2) continue;
                        int n52 = array3D.getPos(0, 0, n7);
                        for (int i = 0; i < n4; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n6;
                                double d = 0.0;
                                if (blArray[j]) {
                                    for (n6 = 0; n6 < n32; ++n6) {
                                        d += (double)fArray[n52 + nArray[n6]] * dArray2[n6];
                                    }
                                } else {
                                    n6 = 0;
                                    localizableByDimCursor3D.setPosition(j - n42 - 1, i, n7);
                                    for (int k = -n42; k <= n42; ++k) {
                                        localizableByDimCursor3D.fwdX();
                                        d += (double)((FloatType)localizableByDimCursor3D.getType()).get() * dArray2[n6++];
                                    }
                                }
                                fArray2[n52++] = (float)d;
                            }
                        }
                    }
                    localizableByDimCursor3D.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        atomicInteger.set(0);
        for (n2 = 0; n2 < threadArray.length; ++n2) {
            threadArray[n2] = new Thread(new Runnable(){

                public void run() {
                    int n8 = atomicInteger.getAndIncrement();
                    float[] fArray = floatArray2.getCurrentStorageArray();
                    LocalizableByDimCursor3D localizableByDimCursor3D = (LocalizableByDimCursor3D)image3.createLocalizableByDimCursor(outOfBoundsStrategyFactory2);
                    double[] dArray2 = (double[])dArray[1].clone();
                    int n2 = dArray[1].length;
                    int n32 = n2 / 2;
                    int n42 = array3D2.getPos(0, 1, 0);
                    int[] nArray = new int[dArray2.length];
                    for (int i = -n32; i <= n32; ++i) {
                        nArray[i + n32] = i * n42;
                    }
                    boolean[] blArray = new boolean[n4];
                    for (int i = 0; i < n4; ++i) {
                        blArray[i] = i - n32 >= 0 && i + n32 < n4;
                    }
                    float[] fArray2 = new float[n4];
                    for (int i = 0; i < n5; ++i) {
                        if (i % n != n8) continue;
                        for (int j = 0; j < n3; ++j) {
                            int n52;
                            int n6 = array3D2.getPos(j, 0, i);
                            for (n52 = 0; n52 < n4; ++n52) {
                                int n7;
                                double d = 0.0;
                                if (blArray[n52]) {
                                    for (n7 = 0; n7 < n2; ++n7) {
                                        d += (double)fArray[n6 + nArray[n7]] * dArray2[n7];
                                    }
                                } else {
                                    n7 = 0;
                                    localizableByDimCursor3D.setPosition(j, n52 - n32 - 1, i);
                                    for (int k = -n32; k <= n32; ++k) {
                                        localizableByDimCursor3D.fwdY();
                                        d += (double)((FloatType)localizableByDimCursor3D.getType()).get() * dArray2[n7++];
                                    }
                                }
                                fArray2[n52] = (float)d;
                                n6 += n42;
                            }
                            n6 = array3D2.getPos(j, 0, i);
                            for (n52 = 0; n52 < n4; ++n52) {
                                fArray[n6] = fArray2[n52];
                                n6 += n42;
                            }
                        }
                    }
                    localizableByDimCursor3D.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        atomicInteger.set(0);
        for (n2 = 0; n2 < threadArray.length; ++n2) {
            threadArray[n2] = new Thread(new Runnable(){

                public void run() {
                    int n8 = atomicInteger.getAndIncrement();
                    double[] dArray2 = (double[])dArray[2].clone();
                    int n2 = dArray[2].length;
                    int n32 = n2 / 2;
                    float[] fArray = floatArray2.getCurrentStorageArray();
                    LocalizableByDimCursor3D localizableByDimCursor3D = (LocalizableByDimCursor3D)image3.createLocalizableByDimCursor(outOfBoundsStrategyFactory2);
                    int n42 = array3D2.getPos(0, 0, 1);
                    int[] nArray = new int[dArray2.length];
                    for (int i = -n32; i <= n32; ++i) {
                        nArray[i + n32] = i * n42;
                    }
                    boolean[] blArray = new boolean[n5];
                    for (int i = 0; i < n5; ++i) {
                        blArray[i] = i - n32 >= 0 && i + n32 < n5;
                    }
                    float[] fArray2 = new float[n5];
                    for (int i = 0; i < n3; ++i) {
                        if (i % n != n8) continue;
                        for (int j = 0; j < n4; ++j) {
                            int n52;
                            int n6 = array3D2.getPos(i, j, 0);
                            for (n52 = 0; n52 < n5; ++n52) {
                                int n7;
                                double d = 0.0;
                                if (blArray[n52]) {
                                    for (n7 = 0; n7 < n2; ++n7) {
                                        d += (double)fArray[n6 + nArray[n7]] * dArray2[n7];
                                    }
                                } else {
                                    n7 = 0;
                                    localizableByDimCursor3D.setPosition(i, j, n52 - n32 - 1);
                                    for (int k = -n32; k <= n32; ++k) {
                                        localizableByDimCursor3D.fwdZ();
                                        d += (double)((FloatType)localizableByDimCursor3D.getType()).get() * dArray2[n7++];
                                    }
                                }
                                fArray2[n52] = (float)d;
                                n6 += n42;
                            }
                            n6 = array3D2.getPos(i, j, 0);
                            for (n52 = 0; n52 < n5; ++n52) {
                                fArray[n6] = fArray2[n52];
                                n6 += n42;
                            }
                        }
                    }
                    localizableByDimCursor3D.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        return image3;
    }
}

