/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.algorithm.fft.InverseFourierTransform;
import mpicbg.imglib.algorithm.fft.PhaseCorrelationPeak;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyPeriodicFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexFloatType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseCorrelation<T extends RealType<T>, S extends RealType<S>>
implements MultiThreaded,
Algorithm,
Benchmark {
    final int numDimensions;
    boolean computeFFTinParalell = true;
    Image<T> image1;
    Image<S> image2;
    int numPeaks;
    int[] minOverlapPx;
    float normalizationThreshold;
    boolean verifyWithCrossCorrelation;
    ArrayList<PhaseCorrelationPeak> phaseCorrelationPeaks;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public PhaseCorrelation(Image<T> image, Image<S> image2, int n, boolean bl) {
        this.image1 = image;
        this.image2 = image2;
        this.numPeaks = n;
        this.verifyWithCrossCorrelation = bl;
        this.numDimensions = image.getNumDimensions();
        this.normalizationThreshold = 1.0E-5f;
        this.minOverlapPx = new int[this.numDimensions];
        this.setMinimalPixelOverlap(3);
        this.setNumThreads();
        this.processingTime = -1L;
    }

    public PhaseCorrelation(Image<T> image, Image<S> image2) {
        this(image, image2, 5, true);
    }

    public void setComputeFFTinParalell(boolean bl) {
        this.computeFFTinParalell = bl;
    }

    public void setInvestigateNumPeaks(int n) {
        this.numPeaks = n;
    }

    public void setNormalizationThreshold(int n) {
        this.normalizationThreshold = n;
    }

    public void setVerifyWithCrossCorrelation(boolean bl) {
        this.verifyWithCrossCorrelation = bl;
    }

    public void setMinimalPixelOverlap(int[] nArray) {
        this.minOverlapPx = (int[])nArray.clone();
    }

    public void setMinimalPixelOverlap(int n) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.minOverlapPx[i] = n;
        }
    }

    public boolean getComputeFFTinParalell() {
        return this.computeFFTinParalell;
    }

    public int getInvestigateNumPeaks() {
        return this.numPeaks;
    }

    public float getNormalizationThreshold() {
        return this.normalizationThreshold;
    }

    public boolean getVerifyWithCrossCorrelation() {
        return this.verifyWithCrossCorrelation;
    }

    public int[] getMinimalPixelOverlap() {
        return (int[])this.minOverlapPx.clone();
    }

    public PhaseCorrelationPeak getShift() {
        return this.phaseCorrelationPeaks.get(this.phaseCorrelationPeaks.size() - 1);
    }

    public ArrayList<PhaseCorrelationPeak> getAllShifts() {
        return this.phaseCorrelationPeaks;
    }

    public boolean process() {
        int[] nArray = PhaseCorrelation.getMaxDim(this.image1, this.image2);
        FourierTransform<T, ComplexFloatType> fourierTransform = new FourierTransform<T, ComplexFloatType>(this.image1, new ComplexFloatType());
        FourierTransform<S, ComplexFloatType> fourierTransform2 = new FourierTransform<S, ComplexFloatType>(this.image2, new ComplexFloatType());
        fourierTransform.setRelativeImageExtension(0.1f);
        fourierTransform2.setRelativeImageExtension(0.1f);
        fourierTransform.setRelativeFadeOutDistance(0.1f);
        fourierTransform2.setRelativeFadeOutDistance(0.1f);
        fourierTransform.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
        fourierTransform2.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
        boolean bl = false;
        do {
            bl = true;
            fourierTransform.setExtendedOriginalImageSize(nArray);
            fourierTransform2.setExtendedOriginalImageSize(nArray);
            for (int i = 0; i < this.numDimensions; ++i) {
                int n = Math.abs(fourierTransform.getExtendedSize()[i] - fourierTransform2.getExtendedSize()[i]);
                if (n <= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + n;
                bl = false;
            }
        } while (!bl);
        if (!fourierTransform.checkInput()) {
            this.errorMessage = "Fourier Transform of first image failed: " + fourierTransform.getErrorMessage();
            return false;
        }
        if (!fourierTransform2.checkInput()) {
            this.errorMessage = "Fourier Transform of second image failed: " + fourierTransform2.getErrorMessage();
            return false;
        }
        if (!this.computeFFT(fourierTransform, fourierTransform2)) {
            this.errorMessage = "Fourier Transform of failed: fft1=" + fourierTransform.getErrorMessage() + " fft2=" + fourierTransform2.getErrorMessage();
            return false;
        }
        Image<ComplexFloatType> image = fourierTransform.getResult();
        Image<ComplexFloatType> image2 = fourierTransform2.getResult();
        this.normalizeAndConjugate(image, image2);
        this.multiplyInPlace(image, image2);
        InverseFourierTransform<FloatType, ComplexFloatType> inverseFourierTransform = new InverseFourierTransform<FloatType, ComplexFloatType>(image, fourierTransform, new FloatType());
        inverseFourierTransform.setInPlaceTransform(true);
        inverseFourierTransform.setCropBackToOriginalSize(false);
        if (!inverseFourierTransform.checkInput() || !inverseFourierTransform.process()) {
            this.errorMessage = "Inverse Fourier Transform of failed: " + inverseFourierTransform.getErrorMessage();
            return false;
        }
        image.close();
        image2.close();
        Image<FloatType> image3 = inverseFourierTransform.getResult();
        this.phaseCorrelationPeaks = this.extractPhaseCorrelationPeaks(image3, this.numPeaks, fourierTransform, fourierTransform2);
        if (!this.verifyWithCrossCorrelation) {
            return true;
        }
        this.verifyWithCrossCorrelation(this.phaseCorrelationPeaks, image3.getDimensions(), this.image1, this.image2);
        return true;
    }

    protected void verifyWithCrossCorrelation(ArrayList<PhaseCorrelationPeak> arrayList, int[] nArray, final Image<T> image, final Image<S> image2) {
        int n;
        boolean[][] blArray = Util.getRecursiveCoordinates((int)this.numDimensions);
        final ArrayList<PhaseCorrelationPeak> arrayList2 = new ArrayList<PhaseCorrelationPeak>();
        for (PhaseCorrelationPeak threadArray2 : arrayList) {
            for (n = 0; n < blArray.length; ++n) {
                boolean[] i = blArray[n];
                int[] nArray2 = threadArray2.getPosition();
                for (int j = 0; j < i.length; ++j) {
                    if (!i[j]) continue;
                    if (nArray2[j] < 0) {
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + nArray[j];
                        continue;
                    }
                    int n3 = j;
                    nArray2[n3] = nArray2[n3] - nArray[j];
                }
                arrayList2.add(new PhaseCorrelationPeak(nArray2, threadArray2.getPhaseCorrelationPeak()));
            }
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.getNumThreads());
        n = threadArray.length;
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n2 = atomicInteger.getAndIncrement();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        if (i % n != n2) continue;
                        PhaseCorrelationPeak phaseCorrelationPeak = (PhaseCorrelationPeak)arrayList2.get(i);
                        long[] lArray = new long[1];
                        phaseCorrelationPeak.setCrossCorrelationPeak((float)PhaseCorrelation.testCrossCorrelation(phaseCorrelationPeak.getPosition(), image, image2, PhaseCorrelation.this.minOverlapPx, lArray));
                        phaseCorrelationPeak.setNumPixels(lArray[0]);
                        phaseCorrelationPeak.setSortPhaseCorrelation(false);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        arrayList.clear();
        arrayList.addAll(arrayList2);
        Collections.sort(arrayList);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(int[] nArray, Image<T> image, Image<S> image2) {
        return PhaseCorrelation.testCrossCorrelation(nArray, image, image2, 5);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(int[] nArray, Image<T> image, Image<S> image2, int n) {
        return PhaseCorrelation.testCrossCorrelation(nArray, image, image2, n, null);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(int[] nArray, Image<T> image, Image<S> image2, int n, long[] lArray) {
        return PhaseCorrelation.testCrossCorrelation(nArray, image, image2, Util.getArrayFromValue((int)n, (int)image.getNumDimensions()), lArray);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(int[] nArray, Image<T> image, Image<S> image2, int[] nArray2) {
        return PhaseCorrelation.testCrossCorrelation(nArray, image, image2, nArray2, null);
    }

    public static <T extends RealType<T>, S extends RealType<S>> double testCrossCorrelation(int[] nArray, Image<T> image, Image<S> image2, int[] nArray2, long[] lArray) {
        double d;
        int n = image.getNumDimensions();
        double d2 = 0.0;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        long l = 1L;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 0) {
                if (nArray[i] >= image.getDimension(i)) {
                    if (lArray != null && lArray.length > 0) {
                        lArray[0] = 0L;
                    }
                    return 0.0;
                }
                nArray4[i] = nArray[i];
                nArray5[i] = 0;
                nArray3[i] = Math.min(image.getDimension(i) - nArray[i], image2.getDimension(i));
            } else {
                if (nArray[i] >= image2.getDimension(i)) {
                    if (lArray != null && lArray.length > 0) {
                        lArray[0] = 0L;
                    }
                    return 0.0;
                }
                nArray4[i] = 0;
                nArray5[i] = -nArray[i];
                nArray3[i] = Math.min(image2.getDimension(i) + nArray[i], image.getDimension(i));
            }
            l *= (long)nArray3[i];
            if (nArray3[i] >= nArray2[i]) continue;
            if (lArray != null && lArray.length > 0) {
                lArray[0] = 0L;
            }
            return 0.0;
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = l;
        }
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor2 = image2.createLocalizableByDimCursor();
        RegionOfInterestCursor regionOfInterestCursor = localizableByDimCursor.createRegionOfInterestCursor(nArray4, nArray3);
        RegionOfInterestCursor regionOfInterestCursor2 = localizableByDimCursor2.createRegionOfInterestCursor(nArray5, nArray3);
        double d3 = 0.0;
        double d4 = 0.0;
        while (regionOfInterestCursor.hasNext()) {
            regionOfInterestCursor.fwd();
            regionOfInterestCursor2.fwd();
            d3 += (double)((RealType)localizableByDimCursor.getType()).getRealFloat();
            d4 += (double)((RealType)localizableByDimCursor2.getType()).getRealFloat();
        }
        d3 /= (double)l;
        d4 /= (double)l;
        regionOfInterestCursor.reset();
        regionOfInterestCursor2.reset();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        while (regionOfInterestCursor.hasNext()) {
            regionOfInterestCursor.fwd();
            regionOfInterestCursor2.fwd();
            float f = ((RealType)localizableByDimCursor.getType()).getRealFloat();
            float f2 = ((RealType)localizableByDimCursor2.getType()).getRealFloat();
            d = (double)f - d3;
            double d8 = (double)f2 - d4;
            d7 += d * d8;
            d5 += d * d;
            d6 += d8 * d8;
        }
        d7 /= (double)l;
        double d9 = Math.sqrt(d5 /= (double)l);
        d = Math.sqrt(d6 /= (double)l);
        if (d9 == 0.0 || d == 0.0) {
            if (d9 == d && d3 == d4) {
                return 1.0;
            }
            return 0.0;
        }
        d2 = d7 / (d9 * d);
        regionOfInterestCursor.close();
        regionOfInterestCursor2.close();
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
        return d2;
    }

    protected ArrayList<PhaseCorrelationPeak> extractPhaseCorrelationPeaks(Image<FloatType> image, int n, FourierTransform<?, ?> fourierTransform, FourierTransform<?, ?> fourierTransform2) {
        ArrayList<PhaseCorrelationPeak> arrayList = new ArrayList<PhaseCorrelationPeak>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new PhaseCorrelationPeak(new int[this.numDimensions], -3.4028235E38f));
        }
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyPeriodicFactory());
        LocalNeighborhoodCursor localNeighborhoodCursor = localizableByDimCursor.createLocalNeighborhoodCursor();
        int[] nArray = fourierTransform.getOriginalOffset();
        int[] nArray2 = fourierTransform2.getOriginalOffset();
        int[] nArray3 = new int[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray3[i] = nArray2[i] - nArray[i];
        }
        int[] nArray4 = image.getDimensions();
        while (localizableByDimCursor.hasNext()) {
            localizableByDimCursor.fwd();
            localNeighborhoodCursor.update();
            float f = ((FloatType)localizableByDimCursor.getType()).get();
            boolean bl = true;
            while (localNeighborhoodCursor.hasNext() && bl) {
                localNeighborhoodCursor.fwd();
                bl = ((FloatType)localizableByDimCursor.getType()).get() <= f;
            }
            localNeighborhoodCursor.reset();
            if (!bl) continue;
            float f2 = Float.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                float f3 = arrayList.get(i).getPhaseCorrelationPeak();
                if (!(f3 < f2)) continue;
                f2 = f3;
                n2 = i;
            }
            if (!(f > f2)) continue;
            arrayList.remove(n2);
            int[] nArray5 = localizableByDimCursor.getPosition();
            for (int i = 0; i < this.numDimensions; ++i) {
                nArray5[i] = (nArray5[i] + nArray3[i]) % nArray4[i];
                if (nArray5[i] <= nArray4[i] / 2) continue;
                nArray5[i] = nArray5[i] - nArray4[i];
            }
            PhaseCorrelationPeak phaseCorrelationPeak = new PhaseCorrelationPeak(nArray5, f);
            phaseCorrelationPeak.setOriginalInvPCMPosition(localizableByDimCursor.getPosition());
            arrayList.add(phaseCorrelationPeak);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected static int[] getMaxDim(Image<?> image, Image<?> image2) {
        int[] nArray = new int[image.getNumDimensions()];
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            nArray[i] = Math.max(image.getDimension(i), image2.getDimension(i));
        }
        return nArray;
    }

    protected void multiplyInPlace(Image<ComplexFloatType> image, Image<ComplexFloatType> image2) {
        Cursor cursor = image.createCursor();
        Cursor cursor2 = image2.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor2.fwd();
            ((ComplexFloatType)cursor.getType()).mul((ComplexFloatType)cursor2.getType());
        }
        cursor.close();
        cursor2.close();
    }

    protected void normalizeAndConjugate(final Image<ComplexFloatType> image, final Image<ComplexFloatType> image2) {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)Math.min(2, this.numThreads));
        final int n = threadArray.length;
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n2 = atomicInteger.getAndIncrement();
                    if (n == 1) {
                        PhaseCorrelation.normalizeComplexImage((Image<ComplexFloatType>)image, PhaseCorrelation.this.normalizationThreshold);
                        PhaseCorrelation.normalizeAndConjugateComplexImage((Image<ComplexFloatType>)image2, PhaseCorrelation.this.normalizationThreshold);
                    } else if (n2 == 0) {
                        PhaseCorrelation.normalizeComplexImage((Image<ComplexFloatType>)image, PhaseCorrelation.this.normalizationThreshold);
                    } else {
                        PhaseCorrelation.normalizeAndConjugateComplexImage((Image<ComplexFloatType>)image2, PhaseCorrelation.this.normalizationThreshold);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
    }

    private static final void normalizeComplexImage(Image<ComplexFloatType> image, float f) {
        Cursor cursor = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            PhaseCorrelation.normalizeLength((ComplexFloatType)cursor.getType(), f);
        }
        cursor.close();
    }

    private static final void normalizeAndConjugateComplexImage(Image<ComplexFloatType> image, float f) {
        Cursor cursor = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            PhaseCorrelation.normalizeLength((ComplexFloatType)cursor.getType(), f);
            ((ComplexFloatType)cursor.getType()).complexConjugate();
        }
        cursor.close();
    }

    private static void normalizeLength(ComplexFloatType complexFloatType, float f) {
        float f2;
        float f3 = complexFloatType.getRealFloat();
        float f4 = (float)Math.sqrt(f3 * f3 + (f2 = complexFloatType.getComplexFloat()) * f2);
        if (f4 < f) {
            complexFloatType.setReal(0.0f);
            complexFloatType.setComplex(0.0f);
        } else {
            complexFloatType.setReal(f3 / f4);
            complexFloatType.setComplex(f2 / f4);
        }
    }

    protected boolean computeFFT(final FourierTransform<T, ComplexFloatType> fourierTransform, final FourierTransform<S, ComplexFloatType> fourierTransform2) {
        int n = this.computeFFTinParalell ? 2 : 1;
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)Math.min(n, this.numThreads));
        final int n2 = threadArray.length;
        final boolean[] blArray = new boolean[2];
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n = atomicInteger.getAndIncrement();
                    if (n2 == 1) {
                        fourierTransform.setNumThreads(PhaseCorrelation.this.getNumThreads());
                        fourierTransform2.setNumThreads(PhaseCorrelation.this.getNumThreads());
                        blArray[0] = fourierTransform.process();
                        blArray[1] = fourierTransform2.process();
                    } else if (n == 0) {
                        fourierTransform.setNumThreads(PhaseCorrelation.this.getNumThreads() / 2);
                        blArray[0] = fourierTransform.process();
                    } else {
                        fourierTransform2.setNumThreads(PhaseCorrelation.this.getNumThreads() / 2);
                        blArray[1] = fourierTransform2.process();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        return blArray[0] && blArray[1];
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image1 == null || this.image2 == null) {
            this.errorMessage = "One of the input images is null";
            return false;
        }
        if (this.image1.getNumDimensions() != this.image2.getNumDimensions()) {
            this.errorMessage = "Dimensionality of images is not the same";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

