/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FFTFunctions;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorExpWindowingFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierTransform<T extends RealType<T>, S extends ComplexType<S>>
implements MultiThreaded,
OutputAlgorithm<S>,
Benchmark {
    final Image<T> img;
    final int numDimensions;
    Image<S> fftImage;
    PreProcessing preProcessing;
    Rearrangement rearrangement;
    FFTOptimization fftOptimization;
    float relativeImageExtensionRatio;
    int[] imageExtension;
    float relativeFadeOutDistance;
    int minExtension;
    OutOfBoundsStrategyFactory<T> strategy;
    int[] originalSize;
    int[] originalOffset;
    int[] extendedSize;
    int[] extendedZeroPaddedSize;
    int[] inputSize = null;
    int[] inputSizeOffset = null;
    final S complexType;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public FourierTransform(Image<T> image, S s, PreProcessing preProcessing, Rearrangement rearrangement, FFTOptimization fFTOptimization, float f, float f2, int n) {
        this.img = image;
        this.complexType = s;
        this.numDimensions = this.img.getNumDimensions();
        this.extendedSize = new int[this.numDimensions];
        this.extendedZeroPaddedSize = new int[this.numDimensions];
        this.imageExtension = new int[this.numDimensions];
        this.setPreProcessing(preProcessing);
        this.setRearrangement(rearrangement);
        this.setFFTOptimization(fFTOptimization);
        this.setRelativeFadeOutDistance(f2);
        this.setRelativeImageExtension(f);
        this.setMinExtension(n);
        this.setCustomOutOfBoundsStrategy(null);
        this.originalSize = image.getDimensions();
        this.originalOffset = new int[this.numDimensions];
        this.processingTime = -1L;
        this.setNumThreads();
    }

    public FourierTransform(Image<T> image, S s) {
        this(image, s, PreProcessing.EXTEND_MIRROR_FADING, Rearrangement.REARRANGE_QUADRANTS, FFTOptimization.SPEED, 0.25f, 0.25f, 12);
    }

    public FourierTransform(Image<T> image, S s, Rearrangement rearrangement) {
        this(image, s);
        this.setRearrangement(rearrangement);
    }

    public FourierTransform(Image<T> image, S s, FFTOptimization fFTOptimization) {
        this(image, s);
        this.setFFTOptimization(fFTOptimization);
    }

    public FourierTransform(Image<T> image, S s, PreProcessing preProcessing) {
        this(image, s);
        this.setPreProcessing(preProcessing);
    }

    public FourierTransform(Image<T> image, S s, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(image, s);
        this.setPreProcessing(PreProcessing.USE_GIVEN_OUTOFBOUNDSSTRATEGY);
        this.setCustomOutOfBoundsStrategy(outOfBoundsStrategyFactory);
    }

    public void setPreProcessing(PreProcessing preProcessing) {
        this.preProcessing = preProcessing;
    }

    public void setRearrangement(Rearrangement rearrangement) {
        this.rearrangement = rearrangement;
    }

    public void setFFTOptimization(FFTOptimization fFTOptimization) {
        this.fftOptimization = fFTOptimization;
    }

    public void setRelativeFadeOutDistance(float f) {
        this.relativeFadeOutDistance = f;
    }

    public void setCustomOutOfBoundsStrategy(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this.strategy = outOfBoundsStrategyFactory;
    }

    public void setMinExtension(int n) {
        this.minExtension = n;
    }

    public void setImageExtension(int[] nArray) {
        this.imageExtension = (int[])nArray.clone();
    }

    public boolean setExtendedOriginalImageSize(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            if (nArray[i] >= this.originalSize[i]) continue;
            this.errorMessage = "Cannot set extended original image size smaller than image size";
            return false;
        }
        this.inputSize = (int[])nArray.clone();
        this.inputSizeOffset = new int[this.numDimensions];
        this.setRelativeImageExtension(this.relativeImageExtensionRatio);
        return true;
    }

    public void setRelativeImageExtension(float f) {
        this.relativeImageExtensionRatio = f;
        for (int i = 0; i < this.img.getNumDimensions(); ++i) {
            this.imageExtension[i] = this.inputSize == null ? Util.round((float)((float)this.img.getDimension(i) * (1.0f + f))) - this.img.getDimension(i) : Util.round((float)((float)this.inputSize[i] * (1.0f + f))) - this.img.getDimension(i);
            if (this.imageExtension[i] < this.minExtension) {
                this.imageExtension[i] = this.minExtension;
            }
            this.extendedSize[i] = this.imageExtension[i] + this.img.getDimension(i);
        }
    }

    public T getImageType() {
        return (T)((RealType)this.img.createType());
    }

    public int[] getExtendedSize() {
        return (int[])this.extendedSize.clone();
    }

    public PreProcessing getPreProcessing() {
        return this.preProcessing;
    }

    public Rearrangement getRearrangement() {
        return this.rearrangement;
    }

    public FFTOptimization getFFOptimization() {
        return this.fftOptimization;
    }

    public float getRelativeImageExtension() {
        return this.relativeImageExtensionRatio;
    }

    public int[] getImageExtension() {
        return (int[])this.imageExtension.clone();
    }

    public float getRelativeFadeOutDistance() {
        return this.relativeFadeOutDistance;
    }

    public OutOfBoundsStrategyFactory<T> getCustomOutOfBoundsStrategy() {
        return this.strategy;
    }

    public int getMinExtension() {
        return this.minExtension;
    }

    public int[] getOriginalSize() {
        return (int[])this.originalSize.clone();
    }

    public int[] getOriginalOffset() {
        return (int[])this.originalOffset.clone();
    }

    public int[] getFFTInputOffset() {
        if (this.inputSize == null) {
            return this.originalOffset;
        }
        return this.inputSizeOffset;
    }

    public int[] getFFTInputSize() {
        if (this.inputSize == null) {
            return (int[])this.originalSize.clone();
        }
        return (int[])this.inputSize.clone();
    }

    public boolean process() {
        OutOfBoundsStrategyMirrorExpWindowingFactory outOfBoundsStrategyMirrorExpWindowingFactory;
        long l = System.currentTimeMillis();
        switch (this.preProcessing) {
            case USE_GIVEN_OUTOFBOUNDSSTRATEGY: {
                if (this.strategy == null) {
                    this.errorMessage = "Custom OutOfBoundsStrategyFactory is null, cannot use custom strategy";
                    return false;
                }
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.img, this.imageExtension), this.fftOptimization);
                outOfBoundsStrategyMirrorExpWindowingFactory = this.strategy;
                break;
            }
            case EXTEND_MIRROR: {
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.img, this.imageExtension), this.fftOptimization);
                outOfBoundsStrategyMirrorExpWindowingFactory = new OutOfBoundsStrategyMirrorFactory();
                break;
            }
            case EXTEND_MIRROR_FADING: {
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.img, this.imageExtension), this.fftOptimization);
                outOfBoundsStrategyMirrorExpWindowingFactory = new OutOfBoundsStrategyMirrorExpWindowingFactory(this.relativeFadeOutDistance);
                break;
            }
            default: {
                this.extendedZeroPaddedSize = this.inputSize == null ? this.getZeroPaddingSize(this.img.getDimensions(), this.fftOptimization) : this.getZeroPaddingSize(this.inputSize, this.fftOptimization);
                outOfBoundsStrategyMirrorExpWindowingFactory = new OutOfBoundsStrategyValueFactory(this.img.createType());
            }
        }
        this.originalOffset = new int[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.inputSize != null) {
                this.inputSizeOffset[i] = (this.extendedZeroPaddedSize[i] - this.inputSize[i]) / 2;
            }
            this.originalOffset[i] = (this.extendedZeroPaddedSize[i] - this.img.getDimension(i)) / 2;
        }
        this.fftImage = FFTFunctions.computeFFT(this.img, this.complexType, outOfBoundsStrategyMirrorExpWindowingFactory, this.originalOffset, this.extendedZeroPaddedSize, this.getNumThreads(), false);
        if (this.fftImage == null) {
            this.errorMessage = "Could not compute the FFT transformation, most likely out of memory";
            return false;
        }
        if (this.rearrangement == Rearrangement.REARRANGE_QUADRANTS) {
            FFTFunctions.rearrangeFFTQuadrants(this.fftImage, this.getNumThreads());
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected int[] getExtendedImageSize(Image<?> image, int[] nArray) {
        int[] nArray2 = new int[image.getNumDimensions()];
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            nArray2[i] = nArray[i] + image.getDimension(i);
        }
        return nArray2;
    }

    protected int[] getZeroPaddingSize(int[] nArray, FFTOptimization fFTOptimization) {
        int[] nArray2 = new int[nArray.length];
        nArray2[0] = fFTOptimization == FFTOptimization.SPEED ? FftReal.nfftFast((int)nArray[0]) : FftReal.nfftSmall((int)nArray[0]);
        for (int i = 1; i < nArray2.length; ++i) {
            nArray2[i] = fFTOptimization == FFTOptimization.SPEED ? FftComplex.nfftFast((int)nArray[i]) : FftComplex.nfftSmall((int)nArray[i]);
        }
        return nArray2;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Image<S> getResult() {
        return this.fftImage;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.img == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FFTOptimization {
        SPEED,
        MEMORY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rearrangement {
        REARRANGE_QUADRANTS,
        UNCHANGED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreProcessing {
        NONE,
        EXTEND_MIRROR,
        EXTEND_MIRROR_FADING,
        USE_GIVEN_OUTOFBOUNDSSTRATEGY;

    }
}

