/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FFTFunctions {
    public static final <T extends RealType<T>, S extends ComplexType<S>> Image<T> computeInverseFFT(final Image<S> image, T t, final int n, final boolean bl, final boolean bl2, final int[] nArray, final int[] nArray2, final float f) {
        if (image == null) {
            return null;
        }
        final int n2 = image.getNumDimensions();
        int n3 = (image.getDimension(0) - 1) * 2;
        final int[] nArray3 = image.getDimensions();
        nArray3[0] = n3;
        ImageFactory imageFactory = new ImageFactory(t, image.getContainerFactory());
        final Image image2 = bl2 ? imageFactory.createImage(nArray) : imageFactory.createImage(nArray3);
        if (image2 == null) {
            return null;
        }
        for (int i = n2 - 1; i > 0; --i) {
            final int n4 = i;
            final AtomicInteger atomicInteger = new AtomicInteger();
            Thread[] threadArray = SimpleMultiThreading.newThreads((int)n);
            for (int j = 0; j < threadArray.length; ++j) {
                threadArray[j] = new Thread(new Runnable(){

                    public void run() {
                        int n5 = atomicInteger.getAndIncrement();
                        int n22 = image.getDimension(n4);
                        float[] fArray = new float[n22 * 2];
                        FftComplex fftComplex = new FftComplex(n22);
                        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
                        int[] nArray = new int[n2 - 1];
                        int[] nArray2 = new int[n2];
                        int n3 = 0;
                        for (int i = 0; i < n2; ++i) {
                            if (i == n4) continue;
                            nArray[n3++] = image.getDimension(i);
                        }
                        ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])nArray);
                        float[] fArray2 = new float[n22 * 2];
                        while (arrayLocalizableCursor.hasNext()) {
                            int n42;
                            arrayLocalizableCursor.fwd();
                            if (arrayLocalizableCursor.getPosition(0) % n != n5) continue;
                            arrayLocalizableCursor.getPosition(nArray);
                            nArray2[n4] = 0;
                            n3 = 0;
                            for (n42 = 0; n42 < n2; ++n42) {
                                if (n42 == n4) continue;
                                nArray2[n42] = nArray[n3++];
                            }
                            localizableByDimCursor.setPosition(nArray2);
                            for (n42 = 0; n42 < n22 - 1; ++n42) {
                                fArray[n42 * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                                fArray[n42 * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                                localizableByDimCursor.fwd(n4);
                            }
                            fArray[(n22 - 1) * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                            fArray[(n22 - 1) * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                            fftComplex.complexToComplex(1, fArray, fArray2);
                            localizableByDimCursor.setPosition(nArray2);
                            if (bl) {
                                for (n42 = 0; n42 < n22 - 1; ++n42) {
                                    ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[n42 * 2] / (float)n22, fArray2[n42 * 2 + 1] / (float)n22);
                                    localizableByDimCursor.fwd(n4);
                                }
                                ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[(n22 - 1) * 2] / (float)n22, fArray2[(n22 - 1) * 2 + 1] / (float)n22);
                                continue;
                            }
                            for (n42 = 0; n42 < n22 - 1; ++n42) {
                                ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[n42 * 2], fArray2[n42 * 2 + 1]);
                                localizableByDimCursor.fwd(n4);
                            }
                            ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[(n22 - 1) * 2], fArray2[(n22 - 1) * 2 + 1]);
                        }
                        localizableByDimCursor.close();
                        arrayLocalizableCursor.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        }
        final AtomicInteger atomicInteger = new AtomicInteger();
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)n);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n8;
                    int n22;
                    int n3 = atomicInteger.getAndIncrement();
                    int n4 = nArray3[0];
                    int n5 = image.getDimension(0);
                    float[] fArray = new float[n5 * 2];
                    FftReal fftReal = new FftReal(n4);
                    if (bl2) {
                        n22 = nArray2[0];
                        n8 = nArray2[0] + nArray[0];
                    } else {
                        n22 = 0;
                        n8 = n4;
                    }
                    LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
                    LocalizableByDimCursor localizableByDimCursor2 = image2.createLocalizableByDimCursor();
                    if (n2 > 1) {
                        int[] nArray4 = new int[n2 - 1];
                        int[] nArray22 = new int[n2];
                        for (int i = 1; i < n2; ++i) {
                            nArray4[i - 1] = image.getDimension(i);
                        }
                        ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])nArray4);
                        float[] fArray2 = new float[n4];
                        block1: while (arrayLocalizableCursor.hasNext()) {
                            int n6;
                            arrayLocalizableCursor.fwd();
                            if (arrayLocalizableCursor.getPosition(0) % n != n3) continue;
                            arrayLocalizableCursor.getPosition(nArray4);
                            nArray22[0] = 0;
                            if (bl2) {
                                for (n6 = 1; n6 < n2; ++n6) {
                                    nArray22[n6] = nArray4[n6 - 1];
                                    if (nArray22[n6] < nArray2[n6] || nArray22[n6] >= nArray2[n6] + nArray[n6]) continue block1;
                                }
                            } else {
                                for (n6 = 1; n6 < n2; ++n6) {
                                    nArray22[n6] = nArray4[n6 - 1];
                                }
                            }
                            localizableByDimCursor.setPosition(nArray22);
                            for (n6 = 0; n6 < n5 - 1; ++n6) {
                                fArray[n6 * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                                fArray[n6 * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                                localizableByDimCursor.fwd(0);
                            }
                            fArray[(n5 - 1) * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                            fArray[(n5 - 1) * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                            fftReal.complexToReal(1, fArray, fArray2);
                            if (bl2) {
                                for (n6 = 1; n6 < n2; ++n6) {
                                    int n7 = n6;
                                    nArray22[n7] = nArray22[n7] - nArray2[n6];
                                }
                            }
                            localizableByDimCursor2.setPosition(nArray22);
                            if (bl) {
                                for (n6 = n22; n6 < n8 - 1; ++n6) {
                                    ((RealType)localizableByDimCursor2.getType()).setReal(fArray2[n6] / (float)n4 * f);
                                    localizableByDimCursor2.fwd(0);
                                }
                                ((RealType)localizableByDimCursor2.getType()).setReal(fArray2[n8 - 1] / (float)n4 * f);
                                continue;
                            }
                            for (n6 = n22; n6 < n8 - 1; ++n6) {
                                ((RealType)localizableByDimCursor2.getType()).setReal(fArray2[n6] * f);
                                localizableByDimCursor2.fwd(0);
                            }
                            ((RealType)localizableByDimCursor2.getType()).setReal(fArray2[n8 - 1] * f);
                        }
                        localizableByDimCursor2.close();
                        localizableByDimCursor.close();
                        arrayLocalizableCursor.close();
                    } else {
                        if (n3 == 0) {
                            localizableByDimCursor.setPosition(0, 0);
                            for (int i = 0; i < n5 - 1; ++i) {
                                fArray[i * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                                fArray[i * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                                localizableByDimCursor.fwd(0);
                            }
                            fArray[(n5 - 1) * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                            fArray[(n5 - 1) * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                            float[] fArray3 = new float[n4];
                            fftReal.complexToReal(1, fArray, fArray3);
                            localizableByDimCursor2.setPosition(0, 0);
                            if (bl) {
                                for (int i = n22; i < n8 - 1; ++i) {
                                    ((RealType)localizableByDimCursor2.getType()).setReal(fArray3[i] / (float)n4 * f);
                                    localizableByDimCursor2.fwd(0);
                                }
                                ((RealType)localizableByDimCursor2.getType()).setReal(fArray3[n8 - 1] / (float)n4 * f);
                            } else {
                                for (int i = n22; i < n8 - 1; ++i) {
                                    ((RealType)localizableByDimCursor2.getType()).setReal(fArray3[i] * f);
                                    localizableByDimCursor2.fwd(0);
                                }
                                ((RealType)localizableByDimCursor2.getType()).setReal(fArray3[n8 - 1] * f);
                            }
                        }
                        localizableByDimCursor2.close();
                        localizableByDimCursor.close();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        return image2;
    }

    public static final <T extends RealType<T>, S extends ComplexType<S>> Image<S> computeFFT(final Image<T> image, S s, final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, final int[] nArray, final int[] nArray2, final int n, final boolean bl) {
        int n2;
        final int n3 = image.getNumDimensions();
        int[] nArray3 = new int[n3];
        nArray3[0] = nArray2[0] / 2 + 1;
        for (int i = 1; i < n3; ++i) {
            nArray3[i] = nArray2[i];
        }
        ImageFactory imageFactory = new ImageFactory(s, image.getContainerFactory());
        final Image image2 = imageFactory.createImage(nArray3);
        if (image2 == null) {
            return null;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)n);
        for (n2 = 0; n2 < threadArray.length; ++n2) {
            threadArray[n2] = new Thread(new Runnable(){

                public void run() {
                    int n5 = atomicInteger.getAndIncrement();
                    int n2 = nArray2[0];
                    int n32 = image2.getDimension(0);
                    float[] fArray = new float[n2];
                    FftReal fftReal = new FftReal(n2);
                    LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
                    LocalizableByDimCursor localizableByDimCursor2 = image2.createLocalizableByDimCursor();
                    if (n3 > 1) {
                        int[] nArray4 = new int[n3 - 1];
                        int[] nArray22 = new int[n3];
                        int[] nArray3 = new int[n3];
                        for (int i = 1; i < n3; ++i) {
                            nArray4[i - 1] = nArray2[i];
                        }
                        ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])nArray4);
                        float[] fArray2 = new float[n32 * 2];
                        while (arrayLocalizableCursor.hasNext()) {
                            int n4;
                            arrayLocalizableCursor.fwd();
                            if (arrayLocalizableCursor.getPosition(0) % n != n5) continue;
                            arrayLocalizableCursor.getPosition(nArray4);
                            nArray22[0] = 0;
                            nArray3[0] = -nArray[0];
                            for (n4 = 1; n4 < n3; ++n4) {
                                nArray22[n4] = nArray4[n4 - 1];
                                nArray3[n4] = nArray4[n4 - 1] - nArray[n4];
                            }
                            localizableByDimCursor.setPosition(nArray3);
                            for (n4 = 0; n4 < n2 - 1; ++n4) {
                                fArray[n4] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                                localizableByDimCursor.fwd(0);
                            }
                            fArray[n2 - 1] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                            fftReal.realToComplex(-1, fArray, fArray2);
                            localizableByDimCursor2.setPosition(nArray22);
                            if (bl) {
                                for (n4 = 0; n4 < n32 - 1; ++n4) {
                                    ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray2[n4 * 2] / (float)n2, fArray2[n4 * 2 + 1] / (float)n2);
                                    localizableByDimCursor2.fwd(0);
                                }
                                ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray2[(n32 - 1) * 2] / (float)n2, fArray2[(n32 - 1) * 2 + 1] / (float)n2);
                                continue;
                            }
                            for (n4 = 0; n4 < n32 - 1; ++n4) {
                                ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray2[n4 * 2], fArray2[n4 * 2 + 1]);
                                localizableByDimCursor2.fwd(0);
                            }
                            ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray2[(n32 - 1) * 2], fArray2[(n32 - 1) * 2 + 1]);
                        }
                        localizableByDimCursor2.close();
                        localizableByDimCursor.close();
                        arrayLocalizableCursor.close();
                    } else {
                        if (n5 == 0) {
                            localizableByDimCursor.setPosition(-nArray[0], 0);
                            for (int i = 0; i < n2 - 1; ++i) {
                                fArray[i] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                                localizableByDimCursor.fwd(0);
                            }
                            fArray[n2 - 1] = ((RealType)localizableByDimCursor.getType()).getRealFloat();
                            float[] fArray3 = new float[n32 * 2];
                            fftReal.realToComplex(-1, fArray, fArray3);
                            localizableByDimCursor2.setPosition(0, 0);
                            if (bl) {
                                for (int i = 0; i < n32 - 1; ++i) {
                                    ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray3[i * 2] / (float)n2, fArray3[i * 2 + 1] / (float)n2);
                                    localizableByDimCursor2.fwd(0);
                                }
                                ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray3[(n32 - 1) * 2] / (float)n2, fArray3[(n32 - 1) * 2 + 1] / (float)n2);
                            } else {
                                for (int i = 0; i < n32 - 1; ++i) {
                                    ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray3[i * 2], fArray3[i * 2 + 1]);
                                    localizableByDimCursor2.fwd(0);
                                }
                                ((ComplexType)localizableByDimCursor2.getType()).setComplexNumber(fArray3[(n32 - 1) * 2], fArray3[(n32 - 1) * 2 + 1]);
                            }
                        }
                        localizableByDimCursor2.close();
                        localizableByDimCursor.close();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        for (n2 = 1; n2 < n3; ++n2) {
            final int n4 = n2;
            atomicInteger.set(0);
            threadArray = SimpleMultiThreading.newThreads((int)n);
            for (int i = 0; i < threadArray.length; ++i) {
                threadArray[i] = new Thread(new Runnable(){

                    public void run() {
                        int n5 = atomicInteger.getAndIncrement();
                        int n2 = image2.getDimension(n4);
                        float[] fArray = new float[n2 * 2];
                        FftComplex fftComplex = new FftComplex(n2);
                        LocalizableByDimCursor localizableByDimCursor = image2.createLocalizableByDimCursor();
                        int[] nArray = new int[n3 - 1];
                        int[] nArray2 = new int[n3];
                        int n32 = 0;
                        for (int i = 0; i < n3; ++i) {
                            if (i == n4) continue;
                            nArray[n32++] = image2.getDimension(i);
                        }
                        ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])nArray);
                        float[] fArray2 = new float[n2 * 2];
                        while (arrayLocalizableCursor.hasNext()) {
                            int n42;
                            arrayLocalizableCursor.fwd();
                            if (arrayLocalizableCursor.getPosition(0) % n != n5) continue;
                            arrayLocalizableCursor.getPosition(nArray);
                            nArray2[n4] = 0;
                            n32 = 0;
                            for (n42 = 0; n42 < n3; ++n42) {
                                if (n42 == n4) continue;
                                nArray2[n42] = nArray[n32++];
                            }
                            localizableByDimCursor.setPosition(nArray2);
                            for (n42 = 0; n42 < n2 - 1; ++n42) {
                                fArray[n42 * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                                fArray[n42 * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                                localizableByDimCursor.fwd(n4);
                            }
                            fArray[(n2 - 1) * 2] = ((ComplexType)localizableByDimCursor.getType()).getRealFloat();
                            fArray[(n2 - 1) * 2 + 1] = ((ComplexType)localizableByDimCursor.getType()).getComplexFloat();
                            fftComplex.complexToComplex(-1, fArray, fArray2);
                            localizableByDimCursor.setPosition(nArray2);
                            if (bl) {
                                for (n42 = 0; n42 < n2 - 1; ++n42) {
                                    ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[n42 * 2] / (float)n2, fArray2[n42 * 2 + 1] / (float)n2);
                                    localizableByDimCursor.fwd(n4);
                                }
                                ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[(n2 - 1) * 2] / (float)n2, fArray2[(n2 - 1) * 2 + 1] / (float)n2);
                                continue;
                            }
                            for (n42 = 0; n42 < n2 - 1; ++n42) {
                                ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[n42 * 2], fArray2[n42 * 2 + 1]);
                                localizableByDimCursor.fwd(n4);
                            }
                            ((ComplexType)localizableByDimCursor.getType()).setComplexNumber(fArray2[(n2 - 1) * 2], fArray2[(n2 - 1) * 2 + 1]);
                        }
                        localizableByDimCursor.close();
                        arrayLocalizableCursor.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        }
        return image2;
    }

    private static final <T extends Type<T>> void rearrangeQuadrantFFTDimZeroSingleDim(Image<T> image) {
        int n = image.getDimension(0);
        int n2 = n / 2;
        int n3 = n - 1;
        Type type = image.createType();
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor2 = image.createLocalizableByDimCursor();
        localizableByDimCursor.setPosition(0, 0);
        localizableByDimCursor2.setPosition(0, n3);
        for (int i = 0; i < n2 - 1; ++i) {
            type.set(localizableByDimCursor.getType());
            localizableByDimCursor.getType().set(localizableByDimCursor2.getType());
            localizableByDimCursor2.getType().set(type);
            localizableByDimCursor.fwd(0);
            localizableByDimCursor2.bck(0);
        }
        type.set(localizableByDimCursor.getType());
        localizableByDimCursor.getType().set(localizableByDimCursor2.getType());
        localizableByDimCursor2.getType().set(type);
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
    }

    private static final <T extends Type<T>> void rearrangeQuadrantFFTDimZero(final Image<T> image, final int n) {
        final int n2 = image.getNumDimensions();
        if (n2 == 1) {
            FFTFunctions.rearrangeQuadrantFFTDimZeroSingleDim(image);
            return;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)n);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n6 = atomicInteger.getAndIncrement();
                    int n22 = image.getDimension(0);
                    int n3 = n22 / 2;
                    int n4 = n22 - 1;
                    Type type = image.createType();
                    LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
                    LocalizableByDimCursor localizableByDimCursor2 = image.createLocalizableByDimCursor();
                    int[] nArray = new int[n2 - 1];
                    int[] nArray2 = new int[n2];
                    for (int i = 1; i < n2; ++i) {
                        nArray[i - 1] = image.getDimension(i);
                    }
                    ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])nArray);
                    while (arrayLocalizableCursor.hasNext()) {
                        int n5;
                        arrayLocalizableCursor.fwd();
                        if (arrayLocalizableCursor.getPosition(0) % n != n6) continue;
                        arrayLocalizableCursor.getPosition(nArray);
                        nArray2[0] = 0;
                        for (n5 = 1; n5 < n2; ++n5) {
                            nArray2[n5] = nArray[n5 - 1];
                        }
                        localizableByDimCursor.setPosition(nArray2);
                        nArray2[0] = n4;
                        localizableByDimCursor2.setPosition(nArray2);
                        for (n5 = 0; n5 < n3 - 1; ++n5) {
                            type.set(localizableByDimCursor.getType());
                            localizableByDimCursor.getType().set(localizableByDimCursor2.getType());
                            localizableByDimCursor2.getType().set(type);
                            localizableByDimCursor.fwd(0);
                            localizableByDimCursor2.bck(0);
                        }
                        type.set(localizableByDimCursor.getType());
                        localizableByDimCursor.getType().set(localizableByDimCursor2.getType());
                        localizableByDimCursor2.getType().set(type);
                    }
                    localizableByDimCursor.close();
                    localizableByDimCursor2.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
    }

    private static final <T extends Type<T>> void rearrangeQuadrantDim(final Image<T> image, final int n, final int n2) {
        final int n3 = image.getNumDimensions();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)n2);
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n6 = atomicInteger.getAndIncrement();
                    int n22 = image.getDimension(n);
                    int n32 = n22 / 2;
                    Type type = image.createType();
                    LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
                    LocalizableByDimCursor localizableByDimCursor2 = image.createLocalizableByDimCursor();
                    int[] nArray = new int[n3 - 1];
                    int[] nArray2 = new int[n3];
                    int n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        if (i == n) continue;
                        nArray[n4++] = image.getDimension(i);
                    }
                    ArrayLocalizableCursor arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor((int[])nArray);
                    while (arrayLocalizableCursor.hasNext()) {
                        int n5;
                        arrayLocalizableCursor.fwd();
                        if (arrayLocalizableCursor.getPosition(0) % n2 != n6) continue;
                        arrayLocalizableCursor.getPosition(nArray);
                        nArray2[n] = 0;
                        n4 = 0;
                        for (n5 = 0; n5 < n3; ++n5) {
                            if (n5 == n) continue;
                            nArray2[n5] = nArray[n4++];
                        }
                        localizableByDimCursor.setPosition(nArray2);
                        nArray2[n] = n32;
                        localizableByDimCursor2.setPosition(nArray2);
                        for (n5 = 0; n5 < n32 - 1; ++n5) {
                            type.set(localizableByDimCursor.getType());
                            localizableByDimCursor.getType().set(localizableByDimCursor2.getType());
                            localizableByDimCursor2.getType().set(type);
                            localizableByDimCursor.fwd(n);
                            localizableByDimCursor2.fwd(n);
                        }
                        type.set(localizableByDimCursor.getType());
                        localizableByDimCursor.getType().set(localizableByDimCursor2.getType());
                        localizableByDimCursor2.getType().set(type);
                    }
                    localizableByDimCursor.close();
                    localizableByDimCursor2.close();
                    arrayLocalizableCursor.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
    }

    public static final <T extends Type<T>> void rearrangeFFTQuadrants(Image<T> image, int n) {
        FFTFunctions.rearrangeQuadrantFFTDimZero(image, n);
        for (int i = 1; i < image.getNumDimensions(); ++i) {
            FFTFunctions.rearrangeQuadrantDim(image, i, n);
        }
    }
}

