/***
 * Copyright (C) 2010 Johan Henriksson
 * This code is under the Endrov / BSD license. See www.endrov.net
 * for the full text and how to cite.
 */
package endrov.flowImageStats;


import java.awt.Color;
import java.util.Map;

import javax.swing.ImageIcon;

import org.jdom.Element;

import endrov.flow.Flow;
import endrov.flow.FlowExec;
import endrov.flow.FlowType;
import endrov.flow.FlowUnitBasic;
import endrov.flow.FlowUnitDeclaration;
import endrov.typeImageset.AnyEvImage;

/**
 * Flow unit: moving variance
 * @author Johan Henriksson
 *
 */
public class FlowUnitPercentileRect extends FlowUnitBasic
	{
	public static final String showName="Moving percentile (rect)";
	private static final String metaType="percentileRect";
	
	/******************************************************************************************************
	 * Plugin declaration
	 *****************************************************************************************************/
	public static void initPlugin() {}
	static
		{
		Flow.addUnitType(new FlowUnitDeclaration(CategoryInfo.name,showName,metaType,FlowUnitPercentileRect.class, null,
				"Local percentile of square region moving over image. Percentile=0.5 is a median filter."));
		}
	
	public String toXML(Element e){return metaType;}
	public void fromXML(Element e){}
	public String getBasicShowName(){return showName;}
	public ImageIcon getIcon(){return null;}
	public Color getBackground(){return CategoryInfo.bgColor;}
	
	/** Get types of flows in */
	protected void getTypesIn(Map<String, FlowType> types, Flow flow)
		{
		types.put("image", FlowType.ANYIMAGE);
		types.put("pw", FlowType.TNUMBER);
		types.put("ph", FlowType.TNUMBER);
		types.put("percentile", FlowType.TNUMBER);
		}
	
	/** Get types of flows out */
	protected void getTypesOut(Map<String, FlowType> types, Flow flow)
		{
		types.put("out", FlowType.ANYIMAGE); //TODO same type as "image"
		}
	
	/** Execute algorithm */
	public void evaluate(Flow flow, FlowExec exec) throws Exception
		{
		Map<String,Object> lastOutput=exec.getLastOutputCleared(this);
		
		AnyEvImage a=(AnyEvImage)flow.getInputValue(this, exec, "image");
		Number pw=(Number)flow.getInputValue(this, exec, "pw");
		Number ph=(Number)flow.getInputValue(this, exec, "ph");
		Number perc=(Number)flow.getInputValue(this, exec, "percentile");

		lastOutput.put("out", new EvOpPercentileRect(pw,ph,perc).exec1Untyped(exec.ph, a));
		}

	public String getHelpArticle()
		{
		return "Misc flow operations";
		}

	}
