/***
 * Copyright (C) 2010 Johan Henriksson
 * This code is under the Endrov / BSD license. See www.endrov.net
 * for the full text and how to cite.
 */
package endrov.flowFourier;


import java.awt.Color;
import java.util.Map;

import javax.swing.ImageIcon;

import org.jdom.Element;

import endrov.flow.Flow;
import endrov.flow.FlowExec;
import endrov.flow.FlowType;
import endrov.flow.FlowUnitBasic;
import endrov.flow.FlowUnitDeclaration;
import endrov.typeImageset.AnyEvImage;

/**
 * Flow unit: Differenc of gaussian 2D
 * @author Johan Henriksson
 *
 */
public class FlowUnitDoG2D extends FlowUnitBasic
	{
	public static final String showName="Difference of gaussian 2D";
	private static final String metaType="DoG2D";
	
	/******************************************************************************************************
	 * Plugin declaration
	 *****************************************************************************************************/
	public static void initPlugin() {}
	static
		{
		Flow.addUnitType(new FlowUnitDeclaration(CategoryInfo.name,showName,metaType,FlowUnitDoG2D.class, null,
				"Difference of two gaussians, slice by slice. Approximates the Ricker wavelet transform"));
		}
	
	public String toXML(Element e){return metaType;}
	public void fromXML(Element e){}
	public String getBasicShowName(){return showName;}
	public ImageIcon getIcon(){return null;}
	public Color getBackground(){return CategoryInfo.bgColor;}
	
	/** Get types of flows in */
	protected void getTypesIn(Map<String, FlowType> types, Flow flow)
		{
		types.put("in", FlowType.ANYIMAGE);
		types.put("sigma", FlowType.TNUMBER);
		}
	
	/** Get types of flows out */
	protected void getTypesOut(Map<String, FlowType> types, Flow flow)
		{
		types.put("out", FlowType.ANYIMAGE); //TODO same type as "image"
		}
	
	/** Execute algorithm */
	public void evaluate(Flow flow, FlowExec exec) throws Exception
		{
		Map<String,Object> lastOutput=exec.getLastOutputCleared(this);
		AnyEvImage in=(AnyEvImage)flow.getInputValue(this, exec, "in");
		Number sigma=(Number)flow.getInputValue(this, exec, "sigma");
		
		lastOutput.put("out", new EvOpDifferenceOfGaussian2D(sigma).exec1Untyped(exec.ph, in));
		}

	public String getHelpArticle()
		{
		return "Flow operations based on FFT";
		}

	}
