/***
 * Copyright (C) 2010 Johan Henriksson
 * This code is under the Endrov / BSD license. See www.endrov.net
 * for the full text and how to cite.
 */
package endrov.flowFindFeature;


import java.awt.Color;
import java.util.Map;

import javax.swing.ImageIcon;

import org.jdom.Element;

import endrov.flow.Flow;
import endrov.flow.FlowExec;
import endrov.flow.FlowType;
import endrov.flow.FlowUnitBasic;
import endrov.flow.FlowUnitDeclaration;
import endrov.typeImageset.AnyEvImage;

/**
 * Flow unit: Find local maximas
 * @author Johan Henriksson
 *
 */
public class FlowUnitFindLocalMaximas2D extends FlowUnitBasic
	{
	public static final String showName="Find local maximas 2D";
	private static final String metaType="findLocalMaximas2D";
	
	public static final ImageIcon icon=new ImageIcon(CategoryInfo.class.getResource("jhFlowCategoryFindMaximas.png"));

	/******************************************************************************************************
	 * Plugin declaration
	 *****************************************************************************************************/
	public static void initPlugin() {}
	static
		{
		Flow.addUnitType(new FlowUnitDeclaration(CategoryInfo.name,showName,metaType,FlowUnitFindLocalMaximas2D.class, icon,
				"Graphical display of local maximas in each plane"));
		}
	
	public String toXML(Element e){return metaType;}
	public void fromXML(Element e){}
	public String getBasicShowName(){return showName;}
	public ImageIcon getIcon(){return icon;}
	public Color getBackground(){return CategoryInfo.bgColor;}
	
	/** Get types of flows in */
	protected void getTypesIn(Map<String, FlowType> types, Flow flow)
		{
		types.put("image", FlowType.ANYIMAGE);
		types.put("alsoDiagonals", FlowType.TBOOLEAN);
		}
	
	/** Get types of flows out */
	protected void getTypesOut(Map<String, FlowType> types, Flow flow)
		{
		types.put("out", FlowType.ANYIMAGE); //TODO same type as "image"
		}
	
	/** Execute algorithm */
	public void evaluate(Flow flow, FlowExec exec) throws Exception
		{
		Map<String,Object> lastOutput=exec.getLastOutputCleared(this);
		
		AnyEvImage a=(AnyEvImage)flow.getInputValue(this, exec, "image");

		Boolean b=(Boolean)flow.getInputValue(this, exec, "alsoDiagonals");
		
		lastOutput.put("out", new EvOpFindLocalMaximas2D(b).exec1Untyped(exec.ph, a));
		}


	public String getHelpArticle()
		{
		return "Misc flow operations";
		}
	
	}
