/***
 * Copyright (C) 2010 Johan Henriksson
 * This code is under the Endrov / BSD license. See www.endrov.net
 * for the full text and how to cite.
 */
package endrov.flowBasic.collection;

import java.awt.Color;
import java.util.Map;
import javax.swing.ImageIcon;

import org.jdom.Element;

import endrov.flow.Flow;
import endrov.flow.FlowExec;
import endrov.flow.FlowType;
import endrov.flow.FlowUnitBasic;
import endrov.flow.FlowUnitDeclaration;
import endrov.flowBasic.RendererFlowUtil;

public class FlowUnitHeadTail extends FlowUnitBasic
	{
	private static final String metaType="headtail";

	private static ImageIcon icon=new ImageIcon(FlowUnitHeadTail.class.getResource("jhHeadTail.png"));

	/******************************************************************************************************
	 * Plugin declaration
	 *****************************************************************************************************/
	public static void initPlugin() {}
	static
		{
		Flow.addUnitType(new FlowUnitDeclaration(CategoryInfo.name,"HeadTail",metaType,FlowUnitHeadTail.class, icon,"Split list into the first element and the rest"));
		}
	
	public String getBasicShowName(){return "HeadTail";}
	public ImageIcon getIcon(){return icon;}
	public Color getBackground(){return RendererFlowUtil.colOperation;}

	public String toXML(Element e){return metaType;}
	public void fromXML(Element e){}

	
	/** Get types of flows in */
	protected void getTypesIn(Map<String, FlowType> types, Flow flow)
		{
		types.put("in", null);
		}
	/** Get types of flows out */
	protected void getTypesOut(Map<String, FlowType> types, Flow flow)
		{
		types.put("head", null);
		types.put("tail", null);
		}
	
	public void evaluate(Flow flow, FlowExec exec) throws Exception
		{
	//	Map<String,Object> lastOutput=exec.getLastOutput(this);
		//TODO flowunit
		}

	public String getHelpArticle()
		{
		return "Flow operations on collections";
		}

	}
