/***
 * Copyright (C) 2010 Johan Henriksson
 * This code is under the Endrov / BSD license. See www.endrov.net
 * for the full text and how to cite.
 */
package endrov.data.basicTypes;

import javax.swing.*;
import org.jdom.*;

import endrov.data.EvContainer;
import endrov.data.EvData;
import endrov.data.EvObject;

/**
 * A grouping of sub-objects
 * @author Johan Henriksson
 */
public class EvGroupObject extends EvObject
	{
	private static final String metaType="group";
	

	
	public String getMetaType()
		{
		return metaType;
		}
	
	public String getMetaTypeDesc()
		{
		return "Group";
		}

	public String saveMetadata(Element e)
		{
		return getMetaType();
		}
	
	public void loadMetadata(Element e)
		{
		}
	
	public void buildMetamenu(JMenu menu, EvContainer parentObject)
		{
		}
	
	
	@Override
	public EvObject cloneEvObject()
		{
		return cloneUsingSerialize();
		}

	/******************************************************************************************************
	 * Plugin declaration
	 *****************************************************************************************************/
	public static void initPlugin() {}
	static
		{
		EvData.supportedMetadataFormats.put(metaType,EvGroupObject.class);
		}

	
	}
