/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nids;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBBpos;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.nids.Nidsheader;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Nidsiosp
extends AbstractIOServiceProvider {
    protected boolean readonly;
    private NetcdfFile ncfile;
    private RandomAccessFile myRaf;
    protected Nidsheader headerParser;
    static final int Z_DEFLATED = 8;
    static final int DEF_WBITS = 15;
    protected int fileUsed = 0;
    protected int recStart = 0;
    protected boolean debug = false;
    protected boolean debugSize = false;
    protected boolean debugSPIO = false;
    protected boolean showHeaderBytes = false;
    protected boolean fill;
    protected HashMap dimHash = new HashMap(50);

    public Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Structure vp = v2.getParentStructure();
        List<Range> ranges = section.getRanges();
        Nidsheader.Vinfo vinfo = (Nidsheader.Vinfo)vp.getSPobject();
        byte[] vdata = this.headerParser.getUncompData((int)vinfo.doff, 0);
        ByteBuffer bos = ByteBuffer.wrap(vdata);
        if (vp.getName().startsWith("VADWindSpeed")) {
            return this.readNestedWindBarbData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getName().startsWith("unlinkedVectorStruct")) {
            return this.readNestedDataUnlinkVector(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getName().equals("linkedVectorStruct")) {
            return this.readNestedLinkedVectorData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getName().startsWith("textStruct")) {
            return this.readNestedTextStringData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getName().startsWith("VectorArrow")) {
            return this.readNestedVectorArrowData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getName().startsWith("circleStruct")) {
            return this.readNestedCircleStructData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        throw new UnsupportedOperationException("Unknown nested variable " + v2.getName());
    }

    public boolean isValidFile(RandomAccessFile raf) {
        Nidsheader localHeader = new Nidsheader();
        return localHeader.isValidFile(raf);
    }

    public void open(RandomAccessFile raf, NetcdfFile file, CancelTask cancelTask) throws IOException {
        this.ncfile = file;
        this.myRaf = raf;
        this.headerParser = new Nidsheader();
        this.headerParser.read(this.myRaf, this.ncfile);
        this.ncfile.finish();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Array outputData;
        List<Range> ranges = section.getRanges();
        Nidsheader.Vinfo vinfo = (Nidsheader.Vinfo)v2.getSPobject();
        byte[] vdata = this.headerParser.getUncompData((int)vinfo.doff, 0);
        ByteBuffer bos = ByteBuffer.wrap(vdata);
        if (v2.getName().equals("azimuth")) {
            Object data = this.readRadialDataAzi(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("gate")) {
            Object data = this.readRadialDataGate(vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("elevation")) {
            Object data = this.readRadialDataEle(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("latitude")) {
            double lat = this.ncfile.findGlobalAttribute("RadarLatitude").getNumericValue().doubleValue();
            Object data = this.readRadialDataLatLonAlt(lat, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("longitude")) {
            double lon = this.ncfile.findGlobalAttribute("RadarLongitude").getNumericValue().doubleValue();
            Object data = this.readRadialDataLatLonAlt(lon, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("altitude")) {
            double alt = this.ncfile.findGlobalAttribute("RadarAltitude").getNumericValue().doubleValue();
            Object data = this.readRadialDataLatLonAlt(alt, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("distance")) {
            Object data = this.readDistance(vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().equals("rays_time")) {
            String rt = this.ncfile.findGlobalAttribute("DateCreated").getStringValue();
            Date pDate = DateUnit.getStandardOrISO(rt);
            double lt = pDate.getTime();
            double[] dd = new double[vinfo.yt];
            for (int radial = 0; radial < vinfo.yt; ++radial) {
                dd[radial] = (float)lt;
            }
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), (Object)dd);
        } else if (v2.getName().startsWith("EchoTop") || v2.getName().startsWith("VertLiquid") || v2.getName().startsWith("BaseReflectivityComp")) {
            Object data = this.readOneArrayData(bos, vinfo, v2.getName());
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getName().startsWith("PrecipArray")) {
            Object data = this.readOneArrayData1(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else {
            if (v2.getName().equals("unlinkedVectorStruct")) {
                return this.readUnlinkedVectorData(v2.getName(), bos, vinfo);
            }
            if (v2.getName().equals("linkedVectorStruct")) {
                return this.readLinkedVectorData(v2.getName(), bos, vinfo);
            }
            if (v2.getName().startsWith("textStruct")) {
                return this.readTextStringData(v2.getName(), bos, vinfo);
            }
            if (v2.getName().startsWith("VADWindSpeed")) {
                return this.readWindBarbData(v2.getName(), bos, vinfo, null);
            }
            if (v2.getName().startsWith("VectorArrow")) {
                return this.readVectorArrowData(v2.getName(), bos, vinfo);
            }
            if (v2.getName().startsWith("TabMessagePage")) {
                Object data = this.readTabAlphaNumData(bos, vinfo);
                outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
            } else {
                if (v2.getName().startsWith("circleStruct")) {
                    return this.readCircleStructData(v2.getName(), bos, vinfo);
                }
                if (v2.getName().startsWith("hail") || v2.getName().startsWith("TVS")) {
                    return this.readGraphicSymbolData(v2.getName(), bos, vinfo);
                }
                Object data = this.readOneScanData(bos, vinfo, v2.getName());
                outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
            }
        }
        return outputData.sectionNoReduce(ranges).copy();
    }

    public Array readNestedGraphicSymbolData(String name, StructureMembers.Member m, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readCircleStructData(name, bos, vinfo);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readGraphicSymbolData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] sizes = vinfo.len;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("x_start").setDataParam(0);
        members.findMember("y_start").setDataParam(2);
        return new MyArrayStructureBBpos(members, new int[]{size}, bos, pos, sizes);
    }

    public Array readNestedLinkedVectorData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readLinkedVectorData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readLinkedVectorData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] dlen = vinfo.len;
        bos.position(0);
        int size = pos.length;
        int vlen = 0;
        for (int i = 0; i < size; ++i) {
            vlen += dlen[i];
        }
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        short sValue = 0;
        int ii = 0;
        short[][] sArray = new short[5][vlen];
        for (int i = 0; i < size; ++i) {
            bos.position(pos[i]);
            if (vinfo.code == 9) {
                sValue = bos.getShort();
            }
            short istart = bos.getShort();
            short jstart = bos.getShort();
            for (int j = 0; j < dlen[i]; ++j) {
                short iend = bos.getShort();
                short jend = bos.getShort();
                if (vinfo.code == 9) {
                    sArray[0][ii] = sValue;
                }
                sArray[1][ii] = istart;
                sArray[2][ii] = jstart;
                sArray[3][ii] = iend;
                sArray[4][ii] = jend;
                ++ii;
            }
        }
        ArrayStructureMA asma = new ArrayStructureMA(members, new int[]{vlen});
        Array data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[0]);
        StructureMembers.Member m = members.findMember("sValue");
        if (m != null) {
            m.setDataObject(data);
        }
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[1]);
        m = members.findMember("x_start");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[2]);
        m = members.findMember("y_start");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[3]);
        m = members.findMember("x_end");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[4]);
        m = members.findMember("y_end");
        m.setDataObject(data);
        return asma;
    }

    public Array readNestedCircleStructData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readCircleStructData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readCircleStructData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        int recsize = pos[1] - pos[0];
        for (int i = 1; i < size; ++i) {
            int r = pos[i] - pos[i - 1];
            if (r == recsize) continue;
            System.out.println(" PROBLEM at " + i + " == " + r);
        }
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("x_center").setDataParam(0);
        members.findMember("y_center").setDataParam(2);
        members.findMember("radius").setDataParam(4);
        members.setStructureSize(recsize);
        return new ArrayStructureBBpos(members, new int[]{size}, bos, pos);
    }

    public Object readTabAlphaNumData(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int plen = vinfo.xt;
        int tablen = vinfo.yt;
        String[] pdata = new String[plen];
        bos.position(0);
        int ipage = 0;
        int icnt = 4;
        StringBuffer sbuf = new StringBuffer();
        while (ipage < plen && tablen > 128 + icnt) {
            short llen = bos.getShort();
            if (llen == -1) {
                pdata[ipage] = new String(sbuf);
                sbuf = new StringBuffer();
                ++ipage;
                icnt += 2;
                continue;
            }
            byte[] b = new byte[llen];
            bos.get(b);
            String sl = new String(b) + "\n";
            sbuf.append(sl);
            icnt = icnt + llen + 2;
        }
        return pdata;
    }

    public Object readOneScanData(ByteBuffer bos, Nidsheader.Vinfo vinfo, String vName) throws IOException, InvalidRangeException {
        int ival;
        int doff = 0;
        int npixel = vinfo.yt * vinfo.xt;
        byte[] odata = new byte[vinfo.xt];
        byte[] pdata = new byte[npixel];
        bos.position(0);
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            short runLen = bos.getShort();
            doff += 2;
            if (vinfo.isRadial) {
                short radialAngle = bos.getShort();
                doff += 2;
                short radialAngleD = bos.getShort();
                doff += 2;
            }
            byte[] rdata = new byte[runLen * 2];
            int tmpp = bos.remaining();
            bos.get(rdata, 0, runLen * 2);
            byte[] bdata = this.readOneBeamData(rdata, runLen, vinfo.xt, doff += runLen * 2);
            if (vinfo.x0 > 0) {
                for (int i = 0; i < vinfo.x0; ++i) {
                    odata[i] = 0;
                }
            }
            System.arraycopy(bdata, 0, odata, vinfo.x0, bdata.length);
            System.arraycopy(odata, 0, pdata, vinfo.xt * radial, vinfo.xt);
        }
        boolean offset = false;
        if (vName.endsWith("_RAW")) {
            return pdata;
        }
        if (vName.startsWith("BaseReflectivity")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            float[] fdata = new float[npixel];
            for (int i = 0; i < npixel; ++i) {
                ival = levels[pdata[i]];
                fdata[i] = ival > -9997 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        if (vName.startsWith("RadialVelocity")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            float[] fdata = new float[npixel];
            for (int i = 0; i < npixel; ++i) {
                ival = levels[pdata[i]];
                fdata[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        if (vName.startsWith("StormMeanVelocity")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            float[] fdata = new float[npixel];
            for (int i = 0; i < npixel; ++i) {
                ival = levels[pdata[i]];
                fdata[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        if (vName.startsWith("Precip")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            float[] fdata = new float[npixel];
            for (int i = 0; i < npixel; ++i) {
                ival = levels[pdata[i]];
                fdata[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        return null;
    }

    public byte[] readOneBeamData(byte[] ddata, int rLen, int xt, int off) throws IOException, InvalidRangeException {
        int run;
        byte[] bdata = new byte[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen * 2; ++run) {
            int drun = this.convertunsignedByte2Short(ddata[run]) >> 4;
            byte dcode1 = (byte)(this.convertunsignedByte2Short(ddata[run]) & 0xF);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public Array readNestedWindBarbData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readWindBarbData(name, bos, vinfo, null);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readWindBarbData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo, List sList) throws IOException, InvalidRangeException {
        int recsize;
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        if (size > 1) {
            recsize = pos[1] - pos[0];
            for (int i = 1; i < size; ++i) {
                int r = pos[i] - pos[i - 1];
                if (r == recsize) continue;
                System.out.println(" PROBLEM at " + i + " == " + r);
            }
        } else {
            recsize = 1;
        }
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("value").setDataParam(0);
        members.findMember("x_start").setDataParam(2);
        members.findMember("y_start").setDataParam(4);
        members.findMember("direction").setDataParam(6);
        members.findMember("speed").setDataParam(8);
        members.setStructureSize(recsize);
        ArrayStructureBBpos ay = new ArrayStructureBBpos(members, new int[]{size}, bos, pos);
        return sList != null ? (ArrayStructure)ay.sectionNoReduce(sList) : ay;
    }

    public Array readNestedVectorArrowData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readVectorArrowData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readVectorArrowData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        int recsize = pos[1] - pos[0];
        for (int i = 1; i < size; ++i) {
            int r = pos[i] - pos[i - 1];
            if (r == recsize) continue;
            System.out.println(" PROBLEM at " + i + " == " + r);
        }
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("x_start").setDataParam(0);
        members.findMember("y_start").setDataParam(2);
        members.findMember("direction").setDataParam(4);
        members.findMember("arrowLength").setDataParam(6);
        members.findMember("arrowHeadLength").setDataParam(8);
        members.setStructureSize(recsize);
        return new ArrayStructureBBpos(members, new int[]{size}, bos, pos);
    }

    public Array readNestedTextStringData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Array ay;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readTextStringData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        String[] ps = new String[size];
        if (m.getName().equalsIgnoreCase("testString")) {
            for (int i = 0; i < size; ++i) {
                ps[i] = ma.getScalarString(i, m);
            }
            ay = Array.factory(String.class, pdata.getShape(), (Object)ps);
        } else {
            for (int i = 0; i < size; ++i) {
                pa[i] = ma.getScalarShort(i, m);
            }
            ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        }
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readTextStringData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] sizes = vinfo.len;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        if (vinfo.code == 8) {
            members.findMember("strValue").setDataParam(0);
            members.findMember("x_start").setDataParam(2);
            members.findMember("y_start").setDataParam(4);
            members.findMember("textString").setDataParam(6);
        } else {
            members.findMember("x_start").setDataParam(0);
            members.findMember("y_start").setDataParam(2);
            members.findMember("textString").setDataParam(4);
        }
        return new MyArrayStructureBBpos(members, new int[]{size}, bos, pos, sizes);
    }

    public Array readNestedDataUnlinkVector(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readUnlinkedVectorData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readUnlinkedVectorData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] dlen = vinfo.len;
        bos.position(0);
        int size = pos.length;
        int vlen = 0;
        for (int i = 0; i < size; ++i) {
            vlen += dlen[i];
        }
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(members, new int[]{vlen});
        int ii = 0;
        short[][] sArray = new short[5][vlen];
        for (int i = 0; i < size; ++i) {
            bos.position(pos[i]);
            short vlevel = bos.getShort();
            for (int j = 0; j < dlen[i]; ++j) {
                short istart = bos.getShort();
                short jstart = bos.getShort();
                short iend = bos.getShort();
                short jend = bos.getShort();
                sArray[0][ii] = vlevel;
                sArray[1][ii] = istart;
                sArray[2][ii] = jstart;
                sArray[3][ii] = iend;
                sArray[4][ii] = jend;
                ++ii;
            }
        }
        Array data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[0]);
        StructureMembers.Member m = members.findMember("iValue");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[1]);
        m = members.findMember("x_start");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[2]);
        m = members.findMember("y_start");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[3]);
        m = members.findMember("x_end");
        m.setDataObject(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[4]);
        m = members.findMember("y_end");
        m.setDataObject(data);
        return asma;
    }

    public Object readOneArrayData(ByteBuffer bos, Nidsheader.Vinfo vinfo, String vName) throws IOException, InvalidRangeException {
        int i;
        float[] fdata;
        int iscale;
        int doff = 0;
        boolean offset = false;
        byte[] pdata = new byte[vinfo.yt * vinfo.xt];
        byte[] b2 = new byte[2];
        int npixel = vinfo.yt * vinfo.xt;
        bos.position(0);
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            bos.get(b2);
            int runLen = this.getUInt(b2, 0, 2);
            doff += 2;
            byte[] rdata = new byte[runLen];
            int tmpp = bos.remaining();
            bos.get(rdata, 0, runLen);
            doff += runLen;
            byte[] bdata = this.readOneRowData(rdata, runLen, vinfo.xt);
            System.arraycopy(bdata, 0, pdata, vinfo.xt * radial, vinfo.xt);
        }
        if (vName.endsWith("_RAW")) {
            return pdata;
        }
        if (vName.equals("EchoTop") || vName.equals("VertLiquid")) {
            int[] levels = vinfo.len;
            iscale = vinfo.code;
            fdata = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[pdata[i]];
                fdata[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        if (vName.startsWith("BaseReflectivityComp")) {
            int[] levels = vinfo.len;
            iscale = vinfo.code;
            fdata = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[pdata[i]];
                fdata[i] = ival > -9997 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        return null;
    }

    public Object readOneArrayData1(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int doff = 0;
        byte[] pdata = new byte[vinfo.yt * vinfo.xt];
        bos.position(0);
        for (int row = 0; row < vinfo.yt; ++row) {
            short runLen = bos.getShort();
            doff += 2;
            byte[] rdata = new byte[runLen];
            int tmpp = bos.remaining();
            bos.get(rdata, 0, runLen);
            doff += runLen;
            byte[] bdata = vinfo.code == 17 ? this.readOneRowData1(rdata, runLen, vinfo.xt) : this.readOneRowData(rdata, runLen, vinfo.xt);
            System.arraycopy(bdata, 0, pdata, vinfo.xt * row, vinfo.xt);
        }
        return pdata;
    }

    public byte[] readOneRowData1(byte[] ddata, int rLen, int xt) throws IOException, InvalidRangeException {
        int run;
        byte[] bdata = new byte[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen / 2; ++run) {
            int drun = this.convertunsignedByte2Short(ddata[run]);
            byte dcode1 = (byte)this.convertunsignedByte2Short(ddata[++run]);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public byte[] readOneRowData(byte[] ddata, int rLen, int xt) throws IOException, InvalidRangeException {
        int run;
        byte[] bdata = new byte[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen; ++run) {
            int drun = this.convertunsignedByte2Short(ddata[run]) >> 4;
            byte dcode1 = (byte)(this.convertunsignedByte2Short(ddata[run]) & 0xF);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public Object readRadialDataEle(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        float[] elvdata = new float[vinfo.yt];
        float elvAngle = (float)vinfo.y0 * 0.1f;
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            elvdata[radial] = elvAngle;
        }
        return elvdata;
    }

    public Object readRadialDataLatLonAlt(double t, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        float[] vdata = new float[vinfo.yt];
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            vdata[radial] = (float)t;
        }
        return vdata;
    }

    public Object readRadialDataAzi(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int doff = 0;
        float[] azidata = new float[vinfo.yt];
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            short runLen = bos.getShort();
            doff += 2;
            float radialAngle = (float)bos.getShort() / 10.0f;
            doff += 2;
            short radialAngleD = bos.getShort();
            doff += 2;
            bos.position(doff += runLen * 2);
            Float ra = new Float(radialAngle);
            azidata[radial] = ra.floatValue();
        }
        return azidata;
    }

    public Object readDistance(Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] data = new int[vinfo.yt * vinfo.xt];
        for (int row = 0; row < vinfo.yt; ++row) {
            for (int col = 0; col < vinfo.xt; ++col) {
                int i = row * vinfo.yt + col;
                data[i] = col + vinfo.x0;
            }
        }
        return data;
    }

    public Object readRadialDataGate(Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        float[] gatedata = new float[vinfo.xt];
        float sc = (float)vinfo.y0 * 1.0f;
        for (int rad = 0; rad < vinfo.xt; ++rad) {
            gatedata[rad] = (float)(vinfo.x0 + rad) * sc;
        }
        return gatedata;
    }

    public byte[] readCompData1(byte[] uncomp, long hoff, long doff) throws IOException {
        byte b1 = uncomp[0];
        byte b2 = uncomp[1];
        int off = 2 * (((b1 & 0x3F) << 8) + b2);
        for (int i = 0; i < 2; ++i) {
            while (off < uncomp.length && uncomp[off] != 10) {
                ++off;
            }
            ++off;
        }
        byte[] data = new byte[(int)((long)(uncomp.length - off) - doff)];
        System.arraycopy(uncomp, off + (int)doff, data, 0, uncomp.length - off - (int)doff);
        return data;
    }

    public byte[] readCompData(long hoff, long doff) throws IOException {
        long pos = 0L;
        long len = this.myRaf.length();
        this.myRaf.seek(pos);
        int numin = (int)(len - hoff);
        byte[] b = new byte[(int)len];
        this.myRaf.readFully(b);
        Inflater inf = new Inflater(false);
        int result = 0;
        int uncompLen = 24500;
        byte[] uncomp = new byte[uncompLen];
        inf.setInput(b, (int)hoff, numin - 4);
        int limit = 20000;
        while (inf.getRemaining() > 0) {
            int resultLength;
            try {
                resultLength = inf.inflate(uncomp, result, 4000);
            }
            catch (DataFormatException ex) {
                System.out.println("ERROR on inflation " + ex.getMessage());
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
            if ((result += resultLength) > limit) {
                byte[] tmp = new byte[result];
                System.arraycopy(uncomp, 0, tmp, 0, result);
                uncomp = new byte[uncompLen += 10000];
                System.arraycopy(tmp, 0, uncomp, 0, result);
            }
            if (resultLength != 0) continue;
            int tt = inf.getRemaining();
            byte[] b2 = new byte[2];
            System.arraycopy(b, (int)hoff + numin - 4 - tt, b2, 0, 2);
            if (this.headerParser.isZlibHed(b2) == 0) {
                System.arraycopy(b, (int)hoff + numin - 4 - tt, uncomp, result, tt);
                result += tt;
                break;
            }
            inf.reset();
            inf.setInput(b, (int)hoff + numin - 4 - tt, tt);
        }
        inf.end();
        byte b1 = uncomp[0];
        byte b2 = uncomp[1];
        int off = 2 * (((b1 & 0x3F) << 8) + b2);
        for (int i = 0; i < 2; ++i) {
            while (off < result && uncomp[off] != 10) {
                ++off;
            }
            ++off;
        }
        byte[] data = new byte[(int)((long)(result - off) - doff)];
        System.arraycopy(uncomp, off + (int)doff, data, 0, result - off - (int)doff);
        return data;
    }

    public byte[] readUCompData(long hoff, long doff) throws IOException {
        long pos = 0L;
        long len = this.myRaf.length();
        this.myRaf.seek(pos);
        int numin = (int)(len - hoff);
        byte[] b = new byte[(int)len];
        this.myRaf.readFully(b);
        byte[] ucomp = new byte[numin - 4];
        System.arraycopy(b, (int)hoff, ucomp, 0, numin - 4);
        byte[] data = new byte[(int)((long)ucomp.length - doff)];
        System.arraycopy(ucomp, (int)doff, data, 0, ucomp.length - (int)doff);
        return data;
    }

    protected static char[] convertByteToChar(byte[] byteArray) {
        int size = byteArray.length;
        char[] cbuff = new char[size];
        for (int i = 0; i < size; ++i) {
            cbuff[i] = (char)byteArray[i];
        }
        return cbuff;
    }

    protected static byte[] convertCharToByte(char[] from) {
        int size = from.length;
        byte[] to = new byte[size];
        for (int i = 0; i < size; ++i) {
            to[i] = (byte)from[i];
        }
        return to;
    }

    int issZlibed(byte[] buf) {
        if ((buf[0] & 0xF) == 8 && (buf[0] >> 4) + 8 <= 15 && ((buf[0] << 8) + buf[1]) % 31 == 0) {
            return 1;
        }
        return 0;
    }

    int getUInt(byte[] b, int offset, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[offset + i]);
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    int getInt(byte[] b, int offset, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[offset + i]);
        }
        if (bv[0] > 127) {
            bv[0] = bv[0] - 128;
            base = -1;
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    public short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    public void flush() throws IOException {
        this.myRaf.flush();
    }

    public void close() throws IOException {
        this.myRaf.close();
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/NIDS/N0R_20041102_2111";
        NetcdfFile.registerIOProvider(Nidsiosp.class);
        NetcdfFile ncf = NetcdfFile.open(fileIn);
        Variable v = ncf.findVariable("BaseReflectivity");
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{300, 36};
        ArrayByte data = (ArrayByte)v.read(origin, shape);
        ncf.close();
    }

    private class MyArrayStructureBBpos
    extends ArrayStructureBBpos {
        int[] size;

        MyArrayStructureBBpos(StructureMembers members, int[] shape, ByteBuffer bbuffer, int[] positions, int[] size) {
            super(members, shape, bbuffer, positions);
            this.size = size;
        }

        public String getScalarString(int recnum, StructureMembers.Member m) {
            if (m.getDataType() == DataType.CHAR || m.getDataType() == DataType.STRING) {
                int i;
                int offset = this.calcOffset(recnum, m);
                int count = this.size[recnum];
                byte[] pa = new byte[count];
                for (i = 0; i < count; ++i) {
                    pa[i] = this.bbuffer.get(offset + i);
                    if (0 == pa[i]) break;
                }
                return new String(pa, 0, i);
            }
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be String or char");
        }
    }
}

