/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.EnhanceScaleMissing;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

class EnhanceScaleMissingImpl
implements EnhanceScaleMissing {
    private static final byte NC_FILL_BYTE = -127;
    private static final char NC_FILL_CHAR = '\u0000';
    private static final short NC_FILL_SHORT = -32767;
    private static final int NC_FILL_INT = -2147483647;
    private static final float NC_FILL_FLOAT = 9.96921E36f;
    private static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    private static final String FillValue = "_FillValue";
    private DataType convertedDataType = null;
    private boolean useNaNs = NetcdfDataset.useNaNs;
    private boolean invalidDataIsMissing = NetcdfDataset.invalidDataIsMissing;
    private boolean fillValueIsMissing = NetcdfDataset.fillValueIsMissing;
    private boolean missingDataIsMissing = NetcdfDataset.missingDataIsMissing;
    private boolean hasScaleOffset = false;
    private double scale = 1.0;
    private double offset = 0.0;
    private boolean hasValidRange = false;
    private boolean hasValidMin = false;
    private boolean hasValidMax = false;
    private double valid_min = -1.7976931348623157E308;
    private double valid_max = Double.MAX_VALUE;
    private boolean hasFillValue = false;
    private double fillValue;
    private boolean hasMissingValue = false;
    private double[] missingValue;
    private boolean isUnsigned;
    private boolean debug = false;
    private boolean debugRead = false;

    public EnhanceScaleMissingImpl() {
    }

    public EnhanceScaleMissingImpl(VariableDS forVar) {
        this(forVar, NetcdfDataset.useNaNs, NetcdfDataset.fillValueIsMissing, NetcdfDataset.invalidDataIsMissing, NetcdfDataset.missingDataIsMissing);
    }

    public EnhanceScaleMissingImpl(VariableDS forVar, boolean useNaNs, boolean fillValueIsMissing, boolean invalidDataIsMissing, boolean missingDataIsMissing) {
        boolean hasMissing;
        int i;
        Attribute att;
        VariableDS orgVarDS;
        this.useNaNs = useNaNs;
        this.fillValueIsMissing = fillValueIsMissing;
        this.invalidDataIsMissing = invalidDataIsMissing;
        this.missingDataIsMissing = missingDataIsMissing;
        Variable orgVar = forVar.getOriginalVariable();
        if (orgVar instanceof VariableDS && (orgVarDS = (VariableDS)orgVar).isEnhanced()) {
            return;
        }
        this.isUnsigned = forVar.isUnsigned();
        DataType scaleType = null;
        DataType missType = null;
        DataType validType = null;
        DataType fillType = null;
        if (this.debug) {
            System.out.println("EnhancementsImpl for Variable = " + forVar.getName());
        }
        if (null != (att = forVar.findAttribute("scale_factor")) && !att.isString()) {
            this.scale = att.getNumericValue().doubleValue();
            this.hasScaleOffset = true;
            scaleType = att.getDataType();
            forVar.remove(att);
            if (this.debug) {
                System.out.println("scale = " + this.scale + " type " + scaleType);
            }
        }
        if (null != (att = forVar.findAttribute("add_offset")) && !att.isString()) {
            this.offset = att.getNumericValue().doubleValue();
            this.hasScaleOffset = true;
            DataType offType = att.getDataType();
            if (this.rank(offType) > this.rank(scaleType)) {
                scaleType = offType;
            }
            forVar.remove(att);
            if (this.debug) {
                System.out.println("offset = " + this.offset);
            }
        }
        if (null != (att = forVar.findAttribute("valid_range")) && !att.isString() && att.isArray()) {
            this.valid_min = att.getNumericValue(0).doubleValue();
            this.valid_max = att.getNumericValue(1).doubleValue();
            this.hasValidRange = true;
            validType = att.getDataType();
            if (this.hasScaleOffset) {
                forVar.remove(att);
            }
            if (this.debug) {
                System.out.println("valid_range = " + this.valid_min + " " + this.valid_max);
            }
        }
        if (!this.hasValidRange) {
            att = forVar.findAttribute("valid_min");
            if (null != att && !att.isString()) {
                this.valid_min = att.getNumericValue().doubleValue();
                this.hasValidMin = true;
                validType = att.getDataType();
                if (this.hasScaleOffset) {
                    forVar.remove(att);
                }
                if (this.debug) {
                    System.out.println("valid_min = " + this.valid_min);
                }
            }
            if (null != (att = forVar.findAttribute("valid_max")) && !att.isString()) {
                this.valid_max = att.getNumericValue().doubleValue();
                this.hasValidMax = true;
                DataType t = att.getDataType();
                if (this.rank(t) > this.rank(validType)) {
                    validType = t;
                }
                if (this.hasScaleOffset) {
                    forVar.remove(att);
                }
                if (this.debug) {
                    System.out.println("valid_min = " + this.valid_max);
                }
            }
            if (this.hasValidMin && this.hasValidMax) {
                this.hasValidRange = true;
            }
        }
        boolean hasValidData = this.hasValidMin || this.hasValidMax || this.hasValidRange;
        att = forVar.findAttribute(FillValue);
        if (null != att && !att.isString()) {
            this.fillValue = att.getNumericValue().doubleValue();
            this.hasFillValue = true;
            fillType = att.getDataType();
            if (this.hasScaleOffset) {
                forVar.remove(att);
            }
            if (this.debug) {
                System.out.println("missing_datum from _FillValue = " + this.fillValue);
            }
        }
        if (null != (att = forVar.findAttribute("missing_value"))) {
            if (att.isString()) {
                try {
                    this.missingValue = new double[1];
                    this.missingValue[0] = Double.parseDouble(att.getStringValue());
                    missType = att.getDataType();
                    this.hasMissingValue = true;
                }
                catch (NumberFormatException ex) {
                    if (this.debug) {
                        System.out.println("String missing_value not parsable as double= " + att.getStringValue());
                    }
                }
            } else if (!att.isArray()) {
                this.missingValue = new double[1];
                this.missingValue[0] = att.getNumericValue().doubleValue();
                if (this.debug) {
                    System.out.println("missing_datum = " + this.missingValue[0]);
                }
                missType = att.getDataType();
                this.hasMissingValue = true;
            } else {
                int n = att.getLength();
                this.missingValue = new double[n];
                if (this.debug) {
                    System.out.print("missing_data = ");
                }
                for (i = 0; i < n; ++i) {
                    this.missingValue[i] = att.getNumericValue(i).doubleValue();
                    if (!this.debug) continue;
                    System.out.print(" " + this.missingValue[i]);
                }
                if (this.debug) {
                    System.out.println();
                }
                missType = att.getDataType();
                this.hasMissingValue = true;
            }
            if (this.hasScaleOffset) {
                forVar.remove(att);
            }
        }
        boolean bl = hasMissing = invalidDataIsMissing && hasValidData || fillValueIsMissing && this.hasFillValue || missingDataIsMissing && this.hasMissingValue;
        if (this.hasScaleOffset) {
            this.convertedDataType = forVar.getDataType();
            if (hasMissing) {
                if (this.rank(scaleType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = scaleType;
                }
                if (missingDataIsMissing && this.rank(missType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = missType;
                }
                if (fillValueIsMissing && this.rank(fillType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = fillType;
                }
                if (invalidDataIsMissing && this.rank(validType) > this.rank(this.convertedDataType)) {
                    this.convertedDataType = validType;
                }
                if (this.rank(this.convertedDataType) < this.rank(DataType.DOUBLE)) {
                    this.convertedDataType = DataType.FLOAT;
                }
            } else if (this.rank(scaleType) > this.rank(this.convertedDataType)) {
                this.convertedDataType = scaleType;
            }
            if (this.debug) {
                System.out.println("assign dataType = " + this.convertedDataType);
            }
            if (this.hasFillValue) {
                this.fillValue = this.scale * this.fillValue + this.offset;
                if (this.debug) {
                    System.out.println("scale the fillValue");
                }
            }
            if (this.hasMissingValue) {
                for (i = 0; i < this.missingValue.length; ++i) {
                    this.missingValue[i] = this.scale * this.missingValue[i] + this.offset;
                }
                if (this.debug) {
                    System.out.println("scale the missing values");
                }
            }
            if (hasValidData) {
                DataType orgType = forVar.getDataType();
                if (this.rank(validType) != this.rank(scaleType) || this.rank(scaleType) < this.rank(orgType)) {
                    if (this.hasValidRange || this.hasValidMin) {
                        this.valid_min = this.scale * this.valid_min + this.offset;
                    }
                    if (this.hasValidRange || this.hasValidMax) {
                        this.valid_max = this.scale * this.valid_max + this.offset;
                    }
                    if (this.debug) {
                        System.out.println("scale the range");
                    }
                }
            }
            boolean bl2 = useNaNs = useNaNs && (this.convertedDataType == DataType.DOUBLE || this.convertedDataType == DataType.FLOAT);
        }
        if (this.debug) {
            System.out.println("useNaNs = " + useNaNs);
        }
    }

    private int rank(DataType c) {
        if (c == DataType.BYTE) {
            return 0;
        }
        if (c == DataType.SHORT) {
            return 1;
        }
        if (c == DataType.INT) {
            return 2;
        }
        if (c == DataType.LONG) {
            return 3;
        }
        if (c == DataType.FLOAT) {
            return 4;
        }
        if (c == DataType.DOUBLE) {
            return 5;
        }
        return -1;
    }

    public DataType getConvertedDataType() {
        return this.convertedDataType;
    }

    public boolean hasInvalidData() {
        return this.hasValidRange || this.hasValidMin || this.hasValidMax;
    }

    public double getValidMin() {
        return this.valid_min;
    }

    public double getValidMax() {
        return this.valid_max;
    }

    public boolean isInvalidData(double val) {
        if (this.hasValidRange) {
            return val < this.valid_min || val > this.valid_max;
        }
        if (this.hasValidMin) {
            return val < this.valid_min;
        }
        if (this.hasValidMax) {
            return val > this.valid_max;
        }
        return false;
    }

    public boolean hasFillValue() {
        return this.hasFillValue;
    }

    public boolean isFillValue(double val) {
        return this.hasFillValue && val == this.fillValue;
    }

    public boolean hasScaleOffset() {
        return this.hasScaleOffset;
    }

    public boolean hasMissingValue() {
        return this.hasMissingValue;
    }

    public boolean isMissingValue(double val) {
        if (!this.hasMissingValue) {
            return false;
        }
        for (int i = 0; i < this.missingValue.length; ++i) {
            if (val != this.missingValue[i]) continue;
            return true;
        }
        return false;
    }

    public void setUseNaNs(boolean useNaNs) {
        this.useNaNs = useNaNs;
    }

    public boolean getUseNaNs() {
        return this.useNaNs;
    }

    public void setFillValueIsMissing(boolean b) {
        this.fillValueIsMissing = b;
    }

    public void setInvalidDataIsMissing(boolean b) {
        this.invalidDataIsMissing = b;
    }

    public void setMissingDataIsMissing(boolean b) {
        this.missingDataIsMissing = b;
    }

    public boolean hasMissing() {
        return this.invalidDataIsMissing && this.hasInvalidData() || this.fillValueIsMissing && this.hasFillValue() || this.missingDataIsMissing && this.hasMissingValue();
    }

    public boolean isMissing(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        if (!this.hasMissing()) {
            return false;
        }
        return this.invalidDataIsMissing && this.isInvalidData(val) || this.fillValueIsMissing && this.isFillValue(val) || this.missingDataIsMissing && this.isMissingValue(val);
    }

    public Object getFillValue(DataType dt) {
        DataType useType;
        DataType dataType = useType = this.convertedDataType == null ? dt : this.convertedDataType;
        if (useType == DataType.BYTE) {
            byte[] result = new byte[]{this.hasFillValue ? (byte)this.fillValue : (byte)-127};
            return result;
        }
        if (useType == DataType.BOOLEAN) {
            boolean[] result = new boolean[]{false};
            return result;
        }
        if (useType == DataType.CHAR) {
            char[] result = new char[]{this.hasFillValue ? (char)this.fillValue : (char)'\u0000'};
            return result;
        }
        if (useType == DataType.SHORT) {
            short[] result = new short[]{this.hasFillValue ? (short)this.fillValue : (short)-32767};
            return result;
        }
        if (useType == DataType.INT) {
            int[] result = new int[]{this.hasFillValue ? (int)this.fillValue : -2147483647};
            return result;
        }
        if (useType == DataType.LONG) {
            long[] result = new long[]{this.hasFillValue ? (long)this.fillValue : -2147483647L};
            return result;
        }
        if (useType == DataType.FLOAT) {
            float[] result = new float[]{this.hasFillValue ? (float)this.fillValue : 9.96921E36f};
            return result;
        }
        if (useType == DataType.DOUBLE) {
            double[] result = new double[]{this.hasFillValue ? this.fillValue : (double)9.96921E36f};
            return result;
        }
        String[] result = new String[]{FillValue};
        return result;
    }

    public double convertScaleOffsetMissing(byte valb) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(valb) ? Double.NaN : (double)valb;
        }
        double convertedValue = this.isUnsigned ? this.scale * (double)DataType.unsignedByteToShort(valb) + this.offset : this.scale * (double)valb + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    public double convertScaleOffsetMissing(short vals) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(vals) ? Double.NaN : (double)vals;
        }
        double convertedValue = this.isUnsigned ? this.scale * (double)DataType.unsignedShortToInt(vals) + this.offset : this.scale * (double)vals + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    public double convertScaleOffsetMissing(int vali) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(vali) ? Double.NaN : (double)vali;
        }
        double convertedValue = this.isUnsigned ? this.scale * (double)DataType.unsignedIntToLong(vali) + this.offset : this.scale * (double)vali + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    public double convertScaleOffsetMissing(long vall) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(vall) ? Double.NaN : (double)vall;
        }
        double convertedValue = this.scale * (double)vall + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    public double convertScaleOffsetMissing(double value) {
        if (!this.hasScaleOffset) {
            return this.useNaNs && this.isMissing(value) ? Double.NaN : value;
        }
        double convertedValue = this.scale * value + this.offset;
        return this.useNaNs && this.isMissing(convertedValue) ? Double.NaN : convertedValue;
    }

    public Array convertScaleOffset(Array in) {
        if (!this.hasScaleOffset) {
            return in;
        }
        if (this.debugRead) {
            System.out.println("convertScaleOffset ");
        }
        Array out = Array.factory(this.convertedDataType.getPrimitiveClassType(), in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        if (this.isUnsigned && in.getElementType() == Byte.TYPE) {
            this.convertScaleOffsetUnsignedByte(iterIn, iterOut);
        } else if (this.isUnsigned && in.getElementType() == Short.TYPE) {
            this.convertScaleOffsetUnsignedShort(iterIn, iterOut);
        } else if (this.isUnsigned && in.getElementType() == Integer.TYPE) {
            this.convertScaleOffsetUnsignedInt(iterIn, iterOut);
        } else {
            while (iterIn.hasNext()) {
                double val = this.scale * iterIn.getDoubleNext() + this.offset;
                iterOut.setDoubleNext(this.useNaNs && this.isMissing(val) ? Double.NaN : val);
            }
        }
        return out;
    }

    private void convertScaleOffsetUnsignedByte(IndexIterator iterIn, IndexIterator iterOut) {
        while (iterIn.hasNext()) {
            byte valb = iterIn.getByteNext();
            double val = this.scale * (double)DataType.unsignedByteToShort(valb) + this.offset;
            iterOut.setDoubleNext(this.useNaNs && this.isMissing(val) ? Double.NaN : val);
        }
    }

    private void convertScaleOffsetUnsignedShort(IndexIterator iterIn, IndexIterator iterOut) {
        while (iterIn.hasNext()) {
            short valb = iterIn.getShortNext();
            double val = this.scale * (double)DataType.unsignedShortToInt(valb) + this.offset;
            iterOut.setDoubleNext(this.useNaNs && this.isMissing(val) ? Double.NaN : val);
        }
    }

    private void convertScaleOffsetUnsignedInt(IndexIterator iterIn, IndexIterator iterOut) {
        while (iterIn.hasNext()) {
            int valb = iterIn.getIntNext();
            double val = this.scale * (double)DataType.unsignedIntToLong(valb) + this.offset;
            iterOut.setDoubleNext(this.useNaNs && this.isMissing(val) ? Double.NaN : val);
        }
    }

    public Array convertMissing(Array in) {
        block4: {
            IndexIterator iterIn;
            block3: {
                if (this.debugRead) {
                    System.out.println("convertMissing ");
                }
                iterIn = in.getIndexIterator();
                if (in.getElementType() != Double.TYPE) break block3;
                while (iterIn.hasNext()) {
                    double val = iterIn.getDoubleNext();
                    if (!this.isMissing(val)) continue;
                    iterIn.setDoubleCurrent(Double.NaN);
                }
                break block4;
            }
            if (in.getElementType() != Float.TYPE) break block4;
            while (iterIn.hasNext()) {
                float val = iterIn.getFloatNext();
                if (!this.isMissing(val)) continue;
                iterIn.setFloatCurrent(Float.NaN);
            }
        }
        return in;
    }

    public float[] setMissingToNaN(float[] values) {
        if (!this.hasMissing()) {
            return values;
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            float value = values[i];
            if (!(this.invalidDataIsMissing && this.isInvalidData(value) || this.fillValueIsMissing && this.isFillValue(value)) && (!this.missingDataIsMissing || !this.isMissingValue(value))) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public static void main(String[] args) {
        double d = Double.NaN;
        float f = (float)d;
        System.out.println(" f=" + f + " " + Float.isNaN(f) + " " + Double.isNaN(f));
    }
}

