/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlableDatasetFile
implements CrawlableDataset {
    private static Logger log = LoggerFactory.getLogger(CrawlableDatasetFile.class);
    private final File file;
    private final String path;
    private final String name;
    private final Object configObj;

    public CrawlableDatasetFile(String path, Object configObj) {
        if (path.startsWith("file:")) {
            try {
                URI uri = new URI(path);
                this.file = new File(uri);
            }
            catch (URISyntaxException e) {
                String tmpMsg = "Bad URI syntax for path <" + path + ">: " + e.getMessage();
                log.debug("CrawlableDatasetFile(): " + tmpMsg);
                throw new IllegalArgumentException(tmpMsg);
            }
        } else {
            this.file = new File(path);
        }
        this.path = this.normalizePath(this.file.getPath());
        this.name = this.file.getName();
        if (configObj != null) {
            log.warn("CrawlableDatasetFile(): config object not null, it will be ignored <" + configObj.toString() + ">.");
            this.configObj = configObj;
        } else {
            this.configObj = null;
        }
    }

    private CrawlableDatasetFile(CrawlableDatasetFile parent, String childPath) {
        this.file = new File(parent.getFile(), childPath);
        this.path = this.normalizePath(this.file.getPath());
        this.name = this.file.getName();
        this.configObj = null;
    }

    public CrawlableDatasetFile(File file) {
        this.file = file;
        this.path = this.normalizePath(this.file.getPath());
        this.name = this.file.getName();
        this.configObj = null;
    }

    private String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Object getConfigObject() {
        return this.configObj;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isCollection() {
        return this.file.isDirectory();
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        return new CrawlableDatasetFile(this, relativePath);
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        if (!this.isCollection()) {
            String tmpMsg = "This dataset <" + this.getPath() + "> is not a collection dataset.";
            log.error("listDatasets(): " + tmpMsg);
            throw new IllegalStateException(tmpMsg);
        }
        ArrayList<CrawlableDataset> list = new ArrayList<CrawlableDataset>();
        for (File allFile : this.file.listFiles()) {
            list.add(new CrawlableDatasetFile(this, allFile.getName()));
        }
        return list;
    }

    @Override
    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        List<CrawlableDataset> list = this.listDatasets();
        if (filter == null) {
            return list;
        }
        ArrayList<CrawlableDataset> retList = new ArrayList<CrawlableDataset>();
        for (CrawlableDataset curDs : list) {
            if (!filter.accept(curDs)) continue;
            retList.add(curDs);
        }
        return retList;
    }

    @Override
    public CrawlableDataset getParentDataset() {
        File parentFile = this.file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return new CrawlableDatasetFile(parentFile);
    }

    @Override
    public long length() {
        if (this.isCollection()) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    public Date lastModified() {
        long lastModDate = this.file.lastModified();
        if (lastModDate == 0L) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeInMillis(lastModDate);
        return cal.getTime();
    }

    public String toString() {
        return this.path;
    }
}

