/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.math.PickImagePeaks;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HoughTransform<S extends RealType<S>, T extends Type<T> & Comparable<T>>
implements OutputAlgorithm<S>,
Benchmark {
    protected long pTime;
    private String errorMsg;
    private final Image<T> image;
    private final Image<S> voteSpace;
    private LocalizableByDimCursor<S> voteCursor;
    private ArrayList<int[]> peaks;
    private final double[] peakExclusion;
    private final S one;

    protected HoughTransform(Image<T> image, int[] nArray, S s) {
        this(image, nArray, new ImageFactory(s, (ContainerFactory)new ArrayContainerFactory()));
    }

    protected HoughTransform(Image<T> image, int[] nArray, ImageFactory<S> imageFactory) {
        this.image = image;
        this.voteCursor = null;
        this.pTime = 0L;
        this.voteSpace = imageFactory.createImage(nArray);
        this.peaks = null;
        this.peakExclusion = new double[nArray.length];
        this.one = (RealType)this.voteSpace.createType();
        this.one.setOne();
        Arrays.fill(this.peakExclusion, 0.0);
    }

    protected boolean placeVote(int[] nArray, S s) {
        if (this.voteCursor == null) {
            this.voteCursor = this.voteSpace.createLocalizableByDimCursor();
        }
        this.voteCursor.setPosition(nArray);
        ((RealType)this.voteCursor.getType()).add(s);
        return true;
    }

    protected boolean placeVote(int[] nArray) {
        if (this.voteSpace != null) {
            if (this.voteCursor == null) {
                this.voteCursor = this.voteSpace.createLocalizableByDimCursor();
            }
            this.voteCursor.setPosition(nArray);
            ((RealType)this.voteCursor.getType()).add(this.one);
            return true;
        }
        this.errorMsg = "Uninitialized Vote Space";
        return false;
    }

    public ArrayList<int[]> getPeakList() {
        return this.peaks;
    }

    public boolean setExclusion(double[] dArray) {
        if (dArray.length >= this.peakExclusion.length) {
            System.arraycopy(dArray, 0, this.peakExclusion, 0, this.peakExclusion.length);
            return true;
        }
        return false;
    }

    protected void setErrorMsg(String string) {
        this.errorMsg = string;
    }

    protected boolean pickPeaks() {
        PickImagePeaks<S> pickImagePeaks = new PickImagePeaks<S>(this.voteSpace);
        pickImagePeaks.setSuppression(this.peakExclusion);
        boolean bl = pickImagePeaks.process();
        if (bl) {
            this.peaks = pickImagePeaks.getPeakList();
            return true;
        }
        return false;
    }

    public boolean checkInput() {
        return this.voteSpace != null;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public long getProcessingTime() {
        return this.pTime;
    }

    public Image<T> getImage() {
        return this.image;
    }

    public Image<S> getResult() {
        return this.voteSpace;
    }
}

