/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubpixelLocalization<T extends RealType<T>>
implements Algorithm,
Benchmark,
MultiThreaded {
    Image<T> laPlacian;
    List<DifferenceOfGaussianPeak<T>> peaks;
    int maxNumMoves = 4;
    boolean allowMaximaTolerance = false;
    float maximaTolerance = 0.01f;
    final ImageFactory<DoubleType> doubleArrayFactory;
    boolean[] allowedToMoveInDim;
    long processingTime;
    int numThreads = 1;
    String errorMessage = "";

    public SubpixelLocalization(Image<T> image, List<DifferenceOfGaussianPeak<T>> list) {
        this.setNumThreads();
        this.laPlacian = image;
        this.peaks = list;
        this.allowedToMoveInDim = new boolean[image.getNumDimensions()];
        for (int i = 0; i < this.allowedToMoveInDim.length; ++i) {
            this.allowedToMoveInDim[i] = true;
        }
        this.doubleArrayFactory = new ImageFactory((Type)new DoubleType(), (ContainerFactory)new ArrayContainerFactory());
    }

    public void setAllowMaximaTolerance(boolean bl) {
        this.allowMaximaTolerance = bl;
    }

    public void setMaximaTolerance(float f) {
        this.maximaTolerance = f;
    }

    public void setLaPlaceImage(Image<T> image) {
        this.laPlacian = image;
    }

    public void setDoGPeaks(List<DifferenceOfGaussianPeak<T>> list) {
        this.peaks = list;
    }

    public void setMaxNumMoves(int n) {
        this.maxNumMoves = n;
    }

    public void setAllowedToMoveInDim(boolean[] blArray) {
        this.allowedToMoveInDim = (boolean[])blArray.clone();
    }

    public boolean getAllowMaximaTolerance() {
        return this.allowMaximaTolerance;
    }

    public float getMaximaTolerance() {
        return this.maximaTolerance;
    }

    public Image<T> getLaPlaceImage() {
        return this.laPlacian;
    }

    public List<DifferenceOfGaussianPeak<T>> getDoGPeaks() {
        return this.peaks;
    }

    public int getMaxNumMoves() {
        return this.maxNumMoves;
    }

    public boolean[] getAllowedToMoveInDim() {
        return (boolean[])this.allowedToMoveInDim.clone();
    }

    protected boolean handleFailure(DifferenceOfGaussianPeak<T> differenceOfGaussianPeak, String string) {
        differenceOfGaussianPeak.setPeakType(DifferenceOfGaussian.SpecialPoint.INVALID);
        differenceOfGaussianPeak.setErrorMessage(string);
        return false;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.getNumThreads());
        final int n = threadArray.length;
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n2 = atomicInteger.getAndIncrement();
                    for (int i = 0; i < SubpixelLocalization.this.peaks.size(); ++i) {
                        DifferenceOfGaussianPeak differenceOfGaussianPeak;
                        if (i % n != n2) continue;
                        List list = SubpixelLocalization.this.peaks;
                        synchronized (list) {
                            differenceOfGaussianPeak = SubpixelLocalization.this.peaks.get(i);
                        }
                        SubpixelLocalization.this.analyzePeak(differenceOfGaussianPeak);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    public boolean analyzePeak(DifferenceOfGaussianPeak<T> differenceOfGaussianPeak) {
        int n;
        Matrix matrix;
        Matrix matrix2;
        int n2 = this.laPlacian.getNumDimensions();
        double[] dArray = new double[n2];
        int[] nArray = differenceOfGaussianPeak.getPosition();
        LocalizableByDimCursor localizableByDimCursor = this.laPlacian.createLocalizableByDimCursor();
        Image<DoubleType> image = this.doubleArrayFactory.createImage(new int[]{localizableByDimCursor.getNumDimensions(), localizableByDimCursor.getNumDimensions()});
        Image<DoubleType> image2 = this.doubleArrayFactory.createImage(new int[]{localizableByDimCursor.getNumDimensions()});
        RealType realType = (RealType)((RealType)differenceOfGaussianPeak.value).createVariable();
        boolean bl = true;
        boolean bl2 = false;
        int n3 = 0;
        do {
            int n4;
            ++n3;
            localizableByDimCursor.setPosition(nArray);
            realType.set(localizableByDimCursor.getType());
            image = this.getHessianMatrix(localizableByDimCursor, image);
            Matrix matrix3 = this.invertMatrix(image);
            if (matrix3 == null) {
                localizableByDimCursor.close();
                image.close();
                image2.close();
                return this.handleFailure(differenceOfGaussianPeak, "Cannot invert hessian matrix");
            }
            matrix2 = SubpixelLocalization.getMatrix(image2 = this.getDerivativeVector(localizableByDimCursor, image2));
            if (matrix2 == null) {
                localizableByDimCursor.close();
                image.close();
                image2.close();
                return this.handleFailure(differenceOfGaussianPeak, "Cannot compute derivative vector");
            }
            matrix = matrix3.uminus().times(matrix2);
            for (n4 = 0; n4 < n2; ++n4) {
                dArray[n4] = matrix.get(n4, 0);
            }
            bl = true;
            for (n4 = 0; n4 < n2; ++n4) {
                double d;
                double d2 = d = this.allowMaximaTolerance ? 0.5 + (double)((float)n3 * this.maximaTolerance) : 0.5;
                if (!(Math.abs(dArray[n4]) > d)) continue;
                if (this.allowedToMoveInDim[n4]) {
                    int n5 = n4;
                    nArray[n5] = (int)((double)nArray[n5] + Math.signum(dArray[n4]));
                    bl = false;
                    continue;
                }
                dArray[n4] = Math.signum(dArray[n4]) * 0.5;
            }
            bl2 = true;
            if (bl) continue;
            for (n4 = 0; n4 < n2; ++n4) {
                if (nArray[n4] > 0 && nArray[n4] < this.laPlacian.getDimension(n4) - 1) continue;
                bl2 = false;
            }
        } while (n3 <= this.maxNumMoves && !bl && bl2);
        localizableByDimCursor.close();
        image.close();
        image2.close();
        if (!bl) {
            return this.handleFailure(differenceOfGaussianPeak, "No stable extremum found.");
        }
        if (!bl2) {
            return this.handleFailure(differenceOfGaussianPeak, "Moved outside of the image.");
        }
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            d += matrix.get(n, 0) * matrix2.get(n, 0);
        }
        d /= 2.0;
        for (n = 0; n < n2; ++n) {
            differenceOfGaussianPeak.setSubPixelLocationOffset((float)dArray[n], n);
        }
        differenceOfGaussianPeak.setPixelLocation(nArray);
        RealType realType2 = (RealType)((RealType)differenceOfGaussianPeak.getImgValue()).createVariable();
        realType2.setReal(d);
        differenceOfGaussianPeak.setFitValue(realType2);
        differenceOfGaussianPeak.setImgValue(realType);
        return true;
    }

    protected Matrix invertMatrix(Image<DoubleType> image) {
        Matrix matrix = SubpixelLocalization.getMatrix(image);
        if (matrix == null) {
            return null;
        }
        return SubpixelLocalization.computePseudoInverseMatrix(matrix, 0.001);
    }

    protected Image<DoubleType> getDerivativeVector(LocalizableByDimCursor<T> localizableByDimCursor, Image<DoubleType> image) {
        SubpixelLocalization.computeDerivativeVector(localizableByDimCursor, image);
        return image;
    }

    protected Image<DoubleType> getHessianMatrix(LocalizableByDimCursor<T> localizableByDimCursor, Image<DoubleType> image) {
        SubpixelLocalization.computeHessianMatrix(localizableByDimCursor, image);
        return image;
    }

    public static <S extends RealType<S>> Matrix getMatrix(Image<S> image) {
        Matrix matrix;
        int n = image.getNumDimensions();
        if (n > 2) {
            return null;
        }
        if (n == 1) {
            matrix = new Matrix(image.getDimension(0), 1);
            LocalizableCursor localizableCursor = image.createLocalizableCursor();
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                matrix.set(localizableCursor.getPosition(0), 0, ((RealType)localizableCursor.getType()).getRealDouble());
            }
            localizableCursor.close();
        } else {
            matrix = new Matrix(image.getDimension(0), image.getDimension(1));
            LocalizableCursor localizableCursor = image.createLocalizableCursor();
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                matrix.set(localizableCursor.getPosition(0), localizableCursor.getPosition(1), ((RealType)localizableCursor.getType()).getRealDouble());
            }
            localizableCursor.close();
        }
        return matrix;
    }

    public static final Matrix computePseudoInverseMatrix(Matrix matrix, double d) {
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix);
        Matrix matrix2 = singularValueDecomposition.getU();
        Matrix matrix3 = singularValueDecomposition.getS();
        Matrix matrix4 = singularValueDecomposition.getV();
        for (int i = 0; i < matrix3.getRowDimension(); ++i) {
            double d2 = matrix3.get(i, i);
            d2 = d2 < d ? 1.0 / d : 1.0 / d2;
            matrix3.set(i, i, d2);
        }
        matrix2 = matrix2.transpose();
        return matrix4.times(matrix3).times(matrix2);
    }

    public static final <T extends RealType<T>> Image<DoubleType> computeDerivativeVector(LocalizableByDimCursor<T> localizableByDimCursor) {
        ImageFactory imageFactory = new ImageFactory((Type)new DoubleType(), (ContainerFactory)new ArrayContainerFactory());
        Image image = imageFactory.createImage(new int[]{localizableByDimCursor.getNumDimensions()});
        SubpixelLocalization.computeDerivativeVector(localizableByDimCursor, (Image<DoubleType>)image);
        return image;
    }

    public static final <T extends RealType<T>> void computeDerivativeVector(LocalizableByDimCursor<T> localizableByDimCursor, Image<DoubleType> image) {
        LocalizableCursor localizableCursor = image.createLocalizableCursor();
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            int n = localizableCursor.getPosition(0);
            localizableByDimCursor.fwd(n);
            double d = ((RealType)localizableByDimCursor.getType()).getRealDouble();
            localizableByDimCursor.bck(n);
            localizableByDimCursor.bck(n);
            double d2 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
            localizableByDimCursor.fwd(n);
            ((DoubleType)localizableCursor.getType()).setReal((d - d2) / 2.0);
        }
        localizableCursor.close();
    }

    public static final <T extends RealType<T>> Image<DoubleType> computeHessianMatrix(LocalizableByDimCursor<T> localizableByDimCursor) {
        ImageFactory imageFactory = new ImageFactory((Type)new DoubleType(), (ContainerFactory)new ArrayContainerFactory());
        Image image = imageFactory.createImage(new int[]{localizableByDimCursor.getNumDimensions(), localizableByDimCursor.getNumDimensions()});
        SubpixelLocalization.computeHessianMatrix(localizableByDimCursor, (Image<DoubleType>)image);
        return image;
    }

    public static final <T extends RealType<T>> void computeHessianMatrix(LocalizableByDimCursor<T> localizableByDimCursor, Image<DoubleType> image) {
        double d = 2.0 * ((RealType)localizableByDimCursor.getType()).getRealDouble();
        LocalizableCursor localizableCursor = image.createLocalizableCursor();
        LocalizableByDimCursor localizableByDimCursor2 = image.createLocalizableByDimCursor();
        while (localizableCursor.hasNext()) {
            double d2;
            double d3;
            localizableCursor.fwd();
            int n = localizableCursor.getPosition(0);
            int n2 = localizableCursor.getPosition(1);
            if (n == n2) {
                localizableByDimCursor.fwd(n);
                d3 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
                localizableByDimCursor.bck(n);
                localizableByDimCursor.bck(n);
                d2 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
                localizableByDimCursor.fwd(n);
                ((DoubleType)localizableCursor.getType()).set(d3 - d + d2);
                continue;
            }
            if (n2 <= n) continue;
            localizableByDimCursor.fwd(n2);
            localizableByDimCursor.fwd(n);
            d3 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
            localizableByDimCursor.bck(n);
            localizableByDimCursor.bck(n);
            d2 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
            localizableByDimCursor.bck(n2);
            localizableByDimCursor.bck(n2);
            double d4 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
            localizableByDimCursor.fwd(n);
            localizableByDimCursor.fwd(n);
            double d5 = ((RealType)localizableByDimCursor.getType()).getRealDouble();
            localizableByDimCursor.bck(n);
            localizableByDimCursor.fwd(n2);
            ((DoubleType)localizableCursor.getType()).set(((d3 - d2) / 2.0 - (d5 - d4) / 2.0) / 2.0);
            localizableByDimCursor2.setPosition(n2, 0);
            localizableByDimCursor2.setPosition(n, 1);
            ((DoubleType)localizableByDimCursor2.getType()).set((RealTypeImpl)localizableCursor.getType());
        }
        localizableCursor.close();
        localizableByDimCursor2.close();
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.laPlacian == null) {
            this.errorMessage = "SubpixelLocalization: [Image<T> img] is null.";
            return false;
        }
        if (this.peaks == null) {
            this.errorMessage = "SubpixelLocalization: [List<DifferenceOfGaussianPeak<T>> peaks] is null.";
            return false;
        }
        if (this.peaks.size() == 0) {
            this.errorMessage = "SubpixelLocalization: [List<DifferenceOfGaussianPeak<T>> peaks] is empty.";
            return false;
        }
        return true;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }
}

