/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import java.util.ArrayList;
import java.util.List;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.RadiusNeighborSearch;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveNonMaximalSuppression<T extends RealType<T>>
implements Algorithm,
Benchmark {
    final List<DifferenceOfGaussianPeak<T>> detections;
    double radius;
    long processingTime;
    String errorMessage = "";

    public AdaptiveNonMaximalSuppression(List<DifferenceOfGaussianPeak<T>> list, double d) {
        this.detections = list;
        this.radius = d;
        this.processingTime = -1L;
    }

    public ArrayList<DifferenceOfGaussianPeak<T>> getClearedList() {
        ArrayList<DifferenceOfGaussianPeak<T>> arrayList = new ArrayList<DifferenceOfGaussianPeak<T>>();
        for (DifferenceOfGaussianPeak<T> differenceOfGaussianPeak : this.detections) {
            if (!differenceOfGaussianPeak.isValid()) continue;
            arrayList.add(differenceOfGaussianPeak);
        }
        return arrayList;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        KDTree<DifferenceOfGaussianPeak<T>> kDTree = new KDTree<DifferenceOfGaussianPeak<T>>(this.detections);
        RadiusNeighborSearch<DifferenceOfGaussianPeak<DifferenceOfGaussianPeak<T>>> radiusNeighborSearch = new RadiusNeighborSearch<DifferenceOfGaussianPeak<DifferenceOfGaussianPeak<T>>>(kDTree);
        for (DifferenceOfGaussianPeak<T> differenceOfGaussianPeak : this.detections) {
            if (!differenceOfGaussianPeak.isValid()) continue;
            ArrayList<DifferenceOfGaussianPeak<T>> arrayList = radiusNeighborSearch.findNeighborsUnsorted(differenceOfGaussianPeak, this.radius);
            ArrayList<DifferenceOfGaussianPeak<T>> arrayList2 = new ArrayList<DifferenceOfGaussianPeak<T>>();
            for (DifferenceOfGaussianPeak<T> differenceOfGaussianPeak2 : arrayList) {
                if ((!differenceOfGaussianPeak.isMax() || !differenceOfGaussianPeak2.isMax()) && (!differenceOfGaussianPeak.isMin() || !differenceOfGaussianPeak2.isMin())) continue;
                arrayList2.add(differenceOfGaussianPeak2);
            }
            this.invalidateLowerEntries(arrayList2, differenceOfGaussianPeak);
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected void invalidateLowerEntries(ArrayList<DifferenceOfGaussianPeak<T>> arrayList, DifferenceOfGaussianPeak<T> differenceOfGaussianPeak) {
        double d = Math.abs(((RealType)differenceOfGaussianPeak.getValue()).getRealDouble());
        for (DifferenceOfGaussianPeak<T> differenceOfGaussianPeak2 : arrayList) {
            if (!(Math.abs(((RealType)differenceOfGaussianPeak2.getValue()).getRealDouble()) < d)) continue;
            differenceOfGaussianPeak2.setPeakType(DifferenceOfGaussian.SpecialPoint.INVALID);
        }
    }

    public boolean checkInput() {
        if (this.detections == null) {
            this.errorMessage = "List<DifferenceOfGaussianPeak<T>> detections is null.";
            return false;
        }
        if (this.detections.size() == 0) {
            this.errorMessage = "List<DifferenceOfGaussianPeak<T>> detections is empty.";
            return false;
        }
        if (Double.isNaN(this.radius)) {
            this.errorMessage = "Radius is NaN.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }
}

