/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuringElement
extends Image<BitType> {
    private final int[] offset;

    public StructuringElement(int[] nArray, String string) {
        this((ImageFactory<BitType>)new ImageFactory((Type)new BitType(), (ContainerFactory)new ArrayContainerFactory()), nArray, string);
    }

    public StructuringElement(ImageFactory<BitType> imageFactory, int[] nArray, String string) {
        super(imageFactory, nArray, string);
        this.offset = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.offset[i] = nArray[i] / 2;
        }
    }

    public int[] getOffset() {
        return this.offset;
    }

    public static StructuringElement createBall(int n, double d) {
        int n2;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = (int)(d * 2.0 + 1.0);
        }
        StructuringElement structuringElement = new StructuringElement(nArray, "Ball Structure " + n + "D, " + d);
        LocalizableCursor localizableCursor = structuringElement.createLocalizableCursor();
        while (localizableCursor.hasNext()) {
            double d2 = 0.0;
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray2);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                d2 += Math.pow(nArray2[n2] - structuringElement.offset[n2], 2.0);
            }
            if ((d2 = Math.sqrt(d2)) <= d) {
                ((BitType)localizableCursor.getType()).setOne();
                continue;
            }
            ((BitType)localizableCursor.getType()).setZero();
        }
        localizableCursor.close();
        structuringElement.removeCursor((Cursor)localizableCursor);
        return structuringElement;
    }

    public static StructuringElement createCube(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
        }
        StructuringElement structuringElement = new StructuringElement(nArray, "Cube Structure " + n2);
        Cursor cursor = structuringElement.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((BitType)cursor.getType()).setOne();
        }
        cursor.close();
        structuringElement.removeCursor(cursor);
        return structuringElement;
    }

    public static StructuringElement createBar(int n, int n2, int n3) {
        if (n3 >= n) {
            throw new RuntimeException("Invalid bar dimension " + n3 + ". Only have " + n + " dimensions.");
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i == n3 ? n2 : 1;
        }
        StructuringElement structuringElement = new StructuringElement(nArray, "Bar " + n3 + " of " + n + ", " + n2);
        Cursor cursor = structuringElement.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((BitType)cursor.getType()).setOne();
        }
        cursor.close();
        structuringElement.removeCursor(cursor);
        return structuringElement;
    }
}

