/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import java.util.LinkedList;
import mpicbg.imglib.algorithm.ROIAlgorithm;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatisticalOperation<T extends RealType<T>>
extends ROIAlgorithm<T, T> {
    private final StructuringElement strel;
    private final LinkedList<T> statList;
    private final int[] lastPosition;
    private final LocalizableByDimCursor<T> outputCursor;
    private boolean init = false;
    private StatisticsCollectionStrategy<T> statsStrategy;

    public StatisticalOperation(Image<T> image, StructuringElement structuringElement) {
        this(image, structuringElement, null);
    }

    public StatisticalOperation(Image<T> image, StructuringElement structuringElement, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super((RealType)image.createType(), image, structuringElement.getDimensions(), outOfBoundsStrategyFactory);
        this.strel = structuringElement;
        this.statList = new LinkedList();
        this.lastPosition = new int[this.strel.getNumDimensions()];
        this.outputCursor = this.getOutputImage().createLocalizableByDimCursor();
        this.statsStrategy = new SimpleCollectionStrategy<T>();
    }

    public void reset() {
        this.init = false;
    }

    public boolean isInit() {
        return this.init;
    }

    public StructuringElement getStrel() {
        return this.strel;
    }

    protected LinkedList<T> getList() {
        return this.statList;
    }

    public int[] getLastPosition() {
        return this.lastPosition;
    }

    public void close() {
        super.close();
        this.outputCursor.close();
    }

    public boolean checkInput() {
        return super.checkInput() && this.outputCursor.isActive();
    }

    protected boolean patchOperation(int[] nArray, RegionOfInterestCursor<T> regionOfInterestCursor) {
        this.statsStrategy.collectStats(this.statList, regionOfInterestCursor, nArray);
        this.outputCursor.setPosition(nArray);
        this.statsOp(this.outputCursor);
        System.arraycopy(nArray, 0, this.lastPosition, 0, nArray.length);
        this.init = true;
        return true;
    }

    protected abstract void statsOp(LocalizableByDimCursor<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SimpleCollectionStrategy<R extends RealType<R>>
    implements StatisticsCollectionStrategy<R> {
        private final LocalizableByDimCursor<BitType> strelCursor;

        public SimpleCollectionStrategy() {
            this.strelCursor = StatisticalOperation.this.strel.createLocalizableByDimCursor();
        }

        @Override
        public void collectStats(LinkedList<R> linkedList, RegionOfInterestCursor<R> regionOfInterestCursor, int[] nArray) {
            linkedList.clear();
            while (regionOfInterestCursor.hasNext()) {
                int n;
                regionOfInterestCursor.fwd();
                this.strelCursor.setPosition(regionOfInterestCursor);
                if (!((BitType)this.strelCursor.getType()).get()) continue;
                RealType realType = (RealType)((RealType)regionOfInterestCursor.getType()).copy();
                for (n = 0; n < linkedList.size() && realType.compareTo(linkedList.get(n)) > 0; ++n) {
                }
                linkedList.add(n, realType.copy());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StatisticsCollectionStrategy<R extends RealType<R>> {
        public void collectStats(LinkedList<R> var1, RegionOfInterestCursor<R> var2, int[] var3);
    }
}

