/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.roi.MorphDilate;
import mpicbg.imglib.algorithm.roi.MorphErode;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphOpen<T extends RealType<T>>
implements OutputAlgorithm<T>,
Benchmark {
    private final Image<T> image;
    private Image<T> outputImage;
    private MorphDilate<T> dilater;
    private final MorphErode<T> eroder;
    private final StructuringElement strel;
    private final OutOfBoundsStrategyFactory<T> outsideFactory;
    private long pTime;

    public MorphOpen(Image<T> image, StructuringElement structuringElement) {
        this(image, structuringElement, null);
    }

    public MorphOpen(Image<T> image, StructuringElement structuringElement, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this.image = image;
        this.strel = structuringElement;
        this.eroder = new MorphErode<T>(this.image, this.strel, outOfBoundsStrategyFactory);
        this.dilater = null;
        this.outputImage = null;
        this.outsideFactory = outOfBoundsStrategyFactory;
        this.pTime = 0L;
    }

    public Image<T> getResult() {
        return this.outputImage;
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        String string = "";
        string = string + this.eroder.getErrorMessage();
        if (this.dilater != null) {
            string = string + this.dilater.getErrorMessage();
        }
        return string;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        this.pTime = 0L;
        boolean bl = false;
        if (this.eroder.process()) {
            this.dilater = new MorphDilate<T>(this.eroder.getResult(), this.strel, this.outsideFactory);
            this.dilater.setName(this.image.getName() + " Opened");
            bl = this.dilater.process();
        }
        this.outputImage = bl ? this.dilater.getResult() : null;
        this.pTime = System.currentTimeMillis() - l;
        return bl;
    }

    public long getProcessingTime() {
        return this.pTime;
    }
}

