/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.roi.MorphDilate;
import mpicbg.imglib.algorithm.roi.MorphErode;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphClose<T extends RealType<T>>
implements OutputAlgorithm<T>,
Benchmark {
    private final Image<T> image;
    private Image<T> outputImage;
    private final MorphDilate<T> dilater;
    private MorphErode<T> eroder;
    private final StructuringElement strel;
    private final OutOfBoundsStrategyFactory<T> outsideFactory;
    private long pTime;

    public MorphClose(Image<T> image, StructuringElement structuringElement) {
        this(image, structuringElement, null);
    }

    public MorphClose(Image<T> image, StructuringElement structuringElement, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this.image = image;
        this.strel = structuringElement;
        this.dilater = new MorphDilate<T>(this.image, this.strel, outOfBoundsStrategyFactory);
        this.eroder = null;
        this.outputImage = null;
        this.outsideFactory = outOfBoundsStrategyFactory;
        this.pTime = 0L;
    }

    public Image<T> getResult() {
        return this.outputImage;
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        String string = "";
        string = string + this.dilater.getErrorMessage();
        if (this.eroder != null) {
            string = string + this.eroder.getErrorMessage();
        }
        return string;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        this.pTime = 0L;
        boolean bl = false;
        if (this.dilater.process()) {
            this.eroder = new MorphErode<T>(this.dilater.getResult(), this.strel, this.outsideFactory);
            this.eroder.setName(this.image.getName() + " Closed");
            bl = this.eroder.process();
        }
        this.outputImage = bl ? this.eroder.getResult() : null;
        this.pTime = System.currentTimeMillis() - l;
        return bl;
    }

    public long getProcessingTime() {
        return this.pTime;
    }
}

