/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickImagePeaks<T extends RealType<T>>
implements OutputAlgorithm<BitType>,
Benchmark {
    private final Image<T> image;
    private long pTime;
    private Image<BitType> peakImage;
    private ContainerFactory peakContainerFactory;
    private final ArrayList<int[]> peakLocList;
    private final double[] suppressAxis;
    private double suppressSum;

    public PickImagePeaks(Image<T> image) {
        this.image = image;
        this.pTime = 0L;
        this.peakContainerFactory = null;
        this.peakLocList = new ArrayList();
        this.peakImage = null;
        this.suppressAxis = new double[image.getDimensions().length];
        Arrays.fill(this.suppressAxis, 0.0);
        this.suppressSum = 0.0;
    }

    private void doSuppression() {
        if (this.peakLocList.size() > 0 && this.suppressSum >= 1.0) {
            ArrayList<Peak> arrayList = new ArrayList<Peak>();
            LocalizableByDimCursor localizableByDimCursor = this.image.createLocalizableByDimCursor();
            for (int[] object : this.peakLocList) {
                localizableByDimCursor.setPosition(object);
                RealType realType = (RealType)((RealType)localizableByDimCursor.getType()).copy();
                arrayList.add(new Peak(this, object, realType));
            }
            Collections.sort(arrayList);
            this.peakLocList.clear();
            for (Peak peak : arrayList) {
                boolean bl = true;
                for (int[] nArray : this.peakLocList) {
                    if (!(peak.distanceFactor(nArray) < 1.0)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                this.peakLocList.add(peak.getPosition());
            }
        }
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        LocalizableCursor localizableCursor = this.image.createLocalizableCursor();
        LocalizableByDimCursor localizableByDimCursor = this.image.createLocalizableByDimCursor();
        int[] nArray = this.image.getDimensions();
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray2.length];
        ImageFactory imageFactory = new ImageFactory((Type)new BitType(), (ContainerFactory)(this.peakContainerFactory == null ? new ArrayContainerFactory() : this.peakContainerFactory));
        this.peakImage = imageFactory.createImage(nArray);
        Image image = imageFactory.createImage(nArray);
        LocalizableCursor localizableCursor2 = image.createLocalizableCursor();
        LocalizableByDimCursor localizableByDimCursor2 = image.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor3 = this.peakImage.createLocalizableByDimCursor();
        this.peakLocList.clear();
        for (int i = 0; i < nArray2.length; ++i) {
            localizableCursor.reset();
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                localizableCursor.getPosition(nArray2);
                localizableByDimCursor2.setPosition(nArray2);
                System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                int n = i;
                nArray3[n] = nArray3[n] - 1;
                if (nArray3[i] < 0) {
                    ((BitType)localizableByDimCursor2.getType()).set(false);
                    continue;
                }
                localizableByDimCursor.setPosition(nArray3);
                RealType realType = (RealType)localizableCursor.getType();
                RealType realType2 = (RealType)localizableByDimCursor.getType();
                ((BitType)localizableByDimCursor2.getType()).set(realType2.compareTo((Object)realType) >= 0);
            }
            localizableCursor2.reset();
            while (localizableCursor2.hasNext()) {
                localizableCursor2.fwd();
                localizableCursor2.getPosition(nArray2);
                localizableByDimCursor3.setPosition(nArray2);
                System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                int n = i;
                nArray3[n] = nArray3[n] + 1;
                if (nArray3[i] >= nArray[i]) {
                    ((BitType)localizableByDimCursor3.getType()).set(false);
                    continue;
                }
                if (i != 0 && !((BitType)localizableByDimCursor3.getType()).get()) continue;
                localizableByDimCursor2.setPosition(nArray3);
                ((BitType)localizableByDimCursor3.getType()).set(!((BitType)localizableCursor2.getType()).get() && ((BitType)localizableByDimCursor2.getType()).get());
            }
        }
        this.pTime = System.currentTimeMillis() - l;
        return true;
    }

    public long getProcessingTime() {
        return this.pTime;
    }

    public Image<BitType> getResult() {
        return this.peakImage;
    }

    public ArrayList<int[]> getPeakList() {
        if (this.peakLocList.isEmpty() && this.peakImage != null) {
            LocalizableCursor localizableCursor = this.peakImage.createLocalizableCursor();
            this.peakLocList.clear();
            while (localizableCursor.hasNext()) {
                localizableCursor.fwd();
                if (!((BitType)localizableCursor.getType()).get()) continue;
                this.peakLocList.add(localizableCursor.getPosition());
            }
            this.doSuppression();
        }
        return this.peakLocList;
    }

    public void setSuppression(double d) {
        Arrays.fill(this.suppressAxis, d);
        this.suppressSum = (double)this.suppressAxis.length * d;
    }

    public void setSuppression(double[] dArray) {
        System.arraycopy(dArray, 0, this.suppressAxis, 0, this.suppressAxis.length);
        this.suppressSum = 0.0;
        for (double d : dArray) {
            this.suppressSum += d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Peak
    implements Comparable<Peak> {
        private final T peakVal;
        private final int[] pos;
        final /* synthetic */ PickImagePeaks this$0;

        public Peak(int[] nArray, T t) {
            this.this$0 = var1_1;
            this.peakVal = t;
            this.pos = nArray;
        }

        @Override
        public int compareTo(Peak peak) {
            if (this.peakVal.compareTo(peak.peakVal) == 1) {
                return -1;
            }
            if (this.peakVal.compareTo(peak.peakVal) == 0) {
                return 0;
            }
            return 1;
        }

        public int[] getPosition() {
            return this.pos;
        }

        public double distanceFactor(int[] nArray) {
            double d = 0.0;
            for (int i = 0; i < this.pos.length; ++i) {
                d += Math.pow(((double)this.pos[i] - (double)nArray[i]) / this.this$0.suppressAxis[i], 2.0);
            }
            d = Math.sqrt(d);
            return d;
        }
    }
}

