/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCalculator<S extends Type<S>, T extends Type<T>, U extends Type<U>>
implements OutputAlgorithm<U>,
MultiThreaded,
Benchmark {
    final Image<S> image1;
    final Image<T> image2;
    final Image<U> output;
    final Function<S, T, U> function;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public ImageCalculator(Image<S> image, Image<T> image2, Image<U> image3, Function<S, T, U> function) {
        this.image1 = image;
        this.image2 = image2;
        this.output = image3;
        this.function = function;
        this.setNumThreads();
    }

    public ImageCalculator(Image<S> image, Image<T> image2, ImageFactory<U> imageFactory, Function<S, T, U> function) {
        this(image, image2, ImageCalculator.createImageFromFactory(imageFactory, image.getDimensions()), function);
    }

    public Image<U> getResult() {
        return this.output;
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image1 == null) {
            this.errorMessage = "ImageCalculator: [Image<S> image1] is null.";
            return false;
        }
        if (this.image2 == null) {
            this.errorMessage = "ImageCalculator: [Image<T> image2] is null.";
            return false;
        }
        if (this.output == null) {
            this.errorMessage = "ImageCalculator: [Image<U> output] is null.";
            return false;
        }
        if (this.function == null) {
            this.errorMessage = "ImageCalculator: [Function<S,T,U>] is null.";
            return false;
        }
        if (!this.image1.getContainer().compareStorageContainerDimensions(this.image2.getContainer()) || !this.image1.getContainer().compareStorageContainerDimensions(this.output.getContainer())) {
            this.errorMessage = "ImageCalculator: Images have different dimensions, not supported: Image1: " + Util.printCoordinates((int[])this.image1.getDimensions()) + " Image2: " + Util.printCoordinates((int[])this.image2.getDimensions()) + " Output: " + Util.printCoordinates((int[])this.output.getDimensions());
            return false;
        }
        return true;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        long l2 = this.image1.getNumPixels();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.getNumThreads());
        final Vector vector = SimpleMultiThreading.divideIntoChunks((long)l2, (int)this.numThreads);
        final boolean bl = this.image1.getContainer().compareStorageContainerCompatibility(this.image2.getContainer()) && this.image1.getContainer().compareStorageContainerCompatibility(this.output.getContainer());
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                public void run() {
                    int n = atomicInteger.getAndIncrement();
                    Chunk chunk = (Chunk)vector.get(n);
                    if (bl) {
                        ImageCalculator.this.computeSimple(chunk.getStartPosition(), chunk.getLoopSize());
                    } else {
                        ImageCalculator.this.computeAdvanced(chunk.getStartPosition(), chunk.getLoopSize());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected void computeSimple(long l, long l2) {
        Cursor cursor = this.image1.createCursor();
        Cursor cursor2 = this.image2.createCursor();
        Cursor cursor3 = this.output.createCursor();
        cursor.fwd(l);
        cursor2.fwd(l);
        cursor3.fwd(l);
        for (long i = 0L; i < l2; ++i) {
            cursor.fwd();
            cursor2.fwd();
            cursor3.fwd();
            this.function.compute(cursor.getType(), cursor2.getType(), cursor3.getType());
        }
        cursor.close();
        cursor2.close();
        cursor3.close();
    }

    protected void computeAdvanced(long l, long l2) {
        System.out.println(l + " -> " + (l + l2));
        LocalizableByDimCursor localizableByDimCursor = this.image1.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor2 = this.image2.createLocalizableByDimCursor();
        LocalizableCursor localizableCursor = this.output.createLocalizableCursor();
        localizableCursor.fwd(l);
        for (long i = 0L; i < l2; ++i) {
            localizableCursor.fwd();
            localizableByDimCursor.setPosition((Localizable)localizableCursor);
            localizableByDimCursor2.setPosition((Localizable)localizableCursor);
            this.function.compute(localizableByDimCursor.getType(), localizableByDimCursor2.getType(), localizableCursor.getType());
        }
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
        localizableCursor.close();
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    protected static <U extends Type<U>> Image<U> createImageFromFactory(ImageFactory<U> imageFactory, int[] nArray) {
        if (imageFactory == null || nArray == null) {
            return null;
        }
        return imageFactory.createImage(nArray);
    }
}

