/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeMinMax<T extends Type<T> & Comparable<T>>
implements Algorithm,
MultiThreaded,
Benchmark {
    final Image<T> image;
    final T min;
    final T max;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public ComputeMinMax(Image<T> image) {
        this.setNumThreads();
        this.image = image;
        this.min = image.createType();
        this.max = image.createType();
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean process() {
        int n;
        long l = System.currentTimeMillis();
        long l2 = this.image.getNumPixels();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threadArray = SimpleMultiThreading.newThreads((int)this.getNumThreads());
        final Vector vector = SimpleMultiThreading.divideIntoChunks((long)l2, (int)this.numThreads);
        final Vector<Type> vector2 = new Vector<Type>();
        final Vector<Type> vector3 = new Vector<Type>();
        for (n = 0; n < threadArray.length; ++n) {
            vector2.add(this.image.createType());
            vector3.add(this.image.createType());
            threadArray[n] = new Thread(new Runnable(){

                public void run() {
                    int n = atomicInteger.getAndIncrement();
                    Chunk chunk = (Chunk)vector.get(n);
                    ComputeMinMax.this.compute(chunk.getStartPosition(), chunk.getLoopSize(), (Type)vector2.get(n), (Type)vector3.get(n));
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threadArray);
        this.min.set((Type)vector2.get(0));
        this.max.set((Type)vector3.get(0));
        for (n = 0; n < threadArray.length; ++n) {
            Type type = (Type)vector2.get(n);
            if (Util.min(this.min, (Type)type) == type) {
                this.min.set(type);
            }
            if (Util.max(this.max, (Type)(type = (Type)vector3.get(n))) != type) continue;
            this.max.set(type);
        }
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    protected void compute(long l, long l2, T t, T t2) {
        Cursor cursor = this.image.createCursor();
        cursor.fwd();
        t.set(cursor.getType());
        t2.set(cursor.getType());
        cursor.reset();
        cursor.fwd(l);
        for (long i = 0L; i < l2; ++i) {
            cursor.fwd();
            Type type = cursor.getType();
            if (Util.min(t, (Type)type) == type) {
                t.set(type);
            }
            if (Util.max(t2, (Type)type) != type) continue;
            t2.set(type);
        }
        cursor.close();
    }

    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ScaleSpace: [Image<A> img] is null.";
            return false;
        }
        return true;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

