/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.List;
import java.util.PriorityQueue;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.numeric.ComplexType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Watershed {
    public static <T extends ComplexType<T>, L extends Comparable<L>> void seededWatershed(Image<T> image, Labeling<L> labeling, int[][] nArray, Labeling<L> labeling2) {
        assert (labeling.getNumDimensions() == image.getNumDimensions());
        assert (labeling.getNumDimensions() == labeling2.getNumDimensions());
        for (int i = 0; i < nArray.length; ++i) {
            assert (nArray[i].length == labeling.getNumDimensions());
        }
        PriorityQueue priorityQueue = new PriorityQueue();
        LocalizableCursor localizableCursor = labeling.createLocalizableCursor();
        LocalizableByDimCursor localizableByDimCursor = labeling2.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor2 = image.createLocalizableByDimCursor();
        int[] nArray2 = labeling2.getDimensions();
        int[] nArray3 = image.getDimensions();
        int[] nArray4 = labeling.createPositionArray();
        int[] nArray5 = labeling.createPositionArray();
        long l = 0L;
        for (Object object : localizableCursor) {
            Object object2 = object.getLabeling();
            if (object2.isEmpty()) continue;
            localizableCursor.getPosition(nArray4);
            int n = 0;
            for (int i = 0; i < nArray4.length; ++i) {
                if (nArray4[i] < nArray2[i] && nArray4[i] < nArray3[i]) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            localizableByDimCursor.setPosition(nArray4);
            object2 = ((LabelingType)localizableByDimCursor.getType()).intern((List)object2);
            ((LabelingType)localizableByDimCursor.getType()).setLabeling((List)object2);
            localizableByDimCursor2.setPosition(nArray4);
            double d = ((ComplexType)localizableByDimCursor2.getType()).getRealDouble();
            priorityQueue.add(new PixelIntensity(nArray4, nArray2, d, l++, object2));
        }
        while (!priorityQueue.isEmpty()) {
            Object object;
            PixelIntensity pixelIntensity = (PixelIntensity)priorityQueue.remove();
            object = pixelIntensity.getLabeling();
            pixelIntensity.getPosition(nArray4, nArray2);
            for (Object object3 : (Object)nArray) {
                boolean bl = false;
                for (int i = 0; i < nArray4.length; ++i) {
                    nArray5[i] = nArray4[i] + object3[i];
                    if (nArray5[i] < nArray2[i] && nArray5[i] < nArray3[i] && nArray5[i] >= 0) continue;
                    bl = true;
                }
                if (bl) continue;
                localizableByDimCursor.setPosition(nArray5);
                if (!((LabelingType)localizableByDimCursor.getType()).getLabeling().isEmpty()) continue;
                ((LabelingType)localizableByDimCursor.getType()).setLabeling((List)object);
                localizableByDimCursor2.setPosition(nArray4);
                double d = ((ComplexType)localizableByDimCursor2.getType()).getRealDouble();
                priorityQueue.add(new PixelIntensity(nArray5, nArray2, d, l++, object));
            }
        }
        localizableCursor.close();
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PixelIntensity<T extends Comparable<T>>
    implements Comparable<PixelIntensity<T>> {
        protected final long index;
        protected final long age;
        protected final double intensity;
        protected final List<T> labeling;

        public PixelIntensity(int[] nArray, int[] nArray2, double d, long l, List<T> list) {
            long l2 = nArray[0];
            long l3 = nArray2[0];
            for (int i = 1; i < nArray2.length; ++i) {
                l2 += (long)nArray[i] * l3;
                l3 *= (long)nArray2[i];
            }
            this.index = l2;
            this.intensity = d;
            this.labeling = list;
            this.age = l;
        }

        @Override
        public int compareTo(PixelIntensity<T> pixelIntensity) {
            int n = Double.compare(this.intensity, pixelIntensity.intensity);
            if (n == 0) {
                n = Double.compare(this.age, pixelIntensity.age);
            }
            return n;
        }

        void getPosition(int[] nArray, int[] nArray2) {
            long l = this.index;
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[i] = (int)(l % (long)nArray2[i]);
                l /= (long)nArray2[i];
            }
        }

        List<T> getLabeling() {
            return this.labeling;
        }
    }
}

