/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.logic.BitType;
import mpicbg.imglib.type.numeric.integer.IntType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryInterpolation2D
implements OutputAlgorithm<BitType> {
    private final Image<BitType> img1;
    private final Image<BitType> img2;
    private float weight;
    private Image<BitType> interpolated;
    private String errorMessage;
    private IDT2D idt1;
    private IDT2D idt2;

    public BinaryInterpolation2D(Image<BitType> image, Image<BitType> image2, float f) {
        this.img1 = image;
        this.img2 = image2;
        this.weight = f;
    }

    public Image<BitType> getResult() {
        return this.interpolated;
    }

    public boolean checkInput() {
        if (this.img1.getNumDimensions() < 2 || this.img2.getNumDimensions() < 2) {
            this.errorMessage = "Need at least 2 dimensions";
            return false;
        }
        if (this.img1.getDimension(0) != this.img2.getDimension(0) || this.img1.getDimension(1) != this.img2.getDimension(1)) {
            this.errorMessage = "Dimensions do not match";
            return false;
        }
        if (this.weight < 0.0f || this.weight > 1.0f) {
            this.errorMessage = "Weight must be between 0 and 1, both inclusive.";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setWeight(float f) throws IllegalArgumentException {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Weight must be between 0 and 1, both inclusive.");
        }
        this.weight = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        Cursor cursor;
        ExecutorService executorService;
        ImageFactory imageFactory = new ImageFactory((Type)new BitType(), (ContainerFactory)new ArrayContainerFactory());
        this.interpolated = imageFactory.createImage(new int[]{this.img1.getDimension(0), this.img1.getDimension(1)});
        BinaryInterpolation2D binaryInterpolation2D = this;
        synchronized (binaryInterpolation2D) {
            if (null == this.idt1 || null == this.idt2) {
                executorService = Executors.newFixedThreadPool(Math.min(2, Runtime.getRuntime().availableProcessors()));
                cursor = executorService.submit(new NewITD2D(this.img1));
                Future<IDT2D> future = executorService.submit(new NewITD2D(this.img2));
                executorService.shutdown();
                try {
                    this.idt1 = (IDT2D)cursor.get();
                    this.idt2 = future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException(executionException);
                }
            }
        }
        if (this.img1.getContainer().compareStorageContainerCompatibility(this.img2.getContainer())) {
            binaryInterpolation2D = this.idt1.result.createCursor();
            executorService = this.idt2.result.createCursor();
            cursor = this.interpolated.createCursor();
            while (cursor.hasNext()) {
                binaryInterpolation2D.fwd();
                executorService.fwd();
                cursor.fwd();
                if (!((float)((IntType)binaryInterpolation2D.getType()).get() * this.weight + (float)((IntType)executorService.getType()).get() * (1.0f - this.weight) > 0.0f)) continue;
                ((BitType)cursor.getType()).set(true);
            }
            binaryInterpolation2D.close();
            executorService.close();
            cursor.close();
        } else {
            System.out.println("using option 2");
            binaryInterpolation2D = this.idt1.result.createLocalizableByDimCursor();
            executorService = this.idt2.result.createLocalizableByDimCursor();
            cursor = this.interpolated.createLocalizableByDimCursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                binaryInterpolation2D.setPosition((Localizable)cursor);
                executorService.setPosition((Localizable)cursor);
                if (!(0.0f <= (float)((IntType)binaryInterpolation2D.getType()).get() * this.weight + (float)((IntType)executorService.getType()).get() * (1.0f - this.weight))) continue;
                ((BitType)cursor.getType()).set(true);
            }
            binaryInterpolation2D.close();
            executorService.close();
            cursor.close();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NewITD2D
    implements Callable<IDT2D> {
        private final Image<BitType> img;

        NewITD2D(Image<BitType> image) {
            this.img = image;
        }

        @Override
        public IDT2D call() throws Exception {
            return new IDT2D(this.img);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IDT2D {
        final Image<IntType> result;
        final int w;
        final int h;
        final int[] position = new int[2];
        final LocalizableByDimCursor<BitType> csrc;
        final LocalizableByDimCursor<IntType> cout;

        IDT2D(Image<BitType> image) {
            this.w = image.getDimension(0);
            this.h = image.getDimension(1);
            ImageFactory imageFactory = new ImageFactory((Type)new IntType(), (ContainerFactory)new ArrayContainerFactory());
            this.result = imageFactory.createImage(new int[]{this.w, this.h});
            int n = (this.w + this.h) * 9;
            for (IntType intType : this.result) {
                intType.set(n);
            }
            this.csrc = image.createLocalizableByDimCursor();
            this.cout = this.result.createLocalizableByDimCursor();
            int n2 = 0;
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    if (this.isBoundary(j, i)) {
                        this.setOutValueAt(j, i, 0);
                        ++n2;
                        continue;
                    }
                    if (!this.isJustOutside(j, i)) continue;
                    this.setOutValueAt(j, i, -1);
                }
            }
            if (n2 > 0) {
                this.propagate();
            }
            this.csrc.close();
            this.cout.close();
        }

        private final void setPosition(LocalizableByDimCursor<?> localizableByDimCursor, int n, int n2) {
            this.position[0] = n;
            this.position[1] = n2;
            localizableByDimCursor.setPosition(this.position);
        }

        private final void setOutValueAt(int n, int n2, int n3) {
            this.setPosition(this.cout, n, n2);
            ((IntType)this.cout.getType()).set(n3);
        }

        private final int getSrcValueAt(int n, int n2) {
            this.setPosition(this.csrc, n, n2);
            return ((BitType)this.csrc.getType()).get() ? 1 : 0;
        }

        private final int getOutValueAt(int n, int n2) {
            this.setPosition(this.cout, n, n2);
            return ((IntType)this.cout.getType()).get();
        }

        private final void idt(int n, int n2, int n3, int n4) {
            if (n + n3 < 0 || n2 + n4 < 0 || n + n3 >= this.w || n2 + n4 >= this.h) {
                return;
            }
            int n5 = this.getOutValueAt(n + n3, n2 + n4);
            int n6 = n3 == 0 || n4 == 0 ? 3 : 4;
            int n7 = n5 < 0 ? -1 : 1;
            this.setPosition(this.cout, n, n2);
            if (Math.abs(((IntType)this.cout.getType()).get()) > Math.abs(n5 += n6 * n7)) {
                ((IntType)this.cout.getType()).set(n5);
            }
        }

        private final void propagate() {
            int n;
            int n2;
            for (n2 = 0; n2 < this.h; ++n2) {
                for (n = 0; n < this.w; ++n) {
                    this.idt(n, n2, -1, 0);
                    this.idt(n, n2, -1, -1);
                    this.idt(n, n2, 0, -1);
                }
            }
            for (n2 = this.h - 1; n2 >= 0; --n2) {
                for (n = this.w - 1; n >= 0; --n) {
                    this.idt(n, n2, 1, 0);
                    this.idt(n, n2, 1, 1);
                    this.idt(n, n2, 0, 1);
                }
            }
            for (n2 = this.w - 1; n2 >= 0; --n2) {
                for (n = this.h - 1; n >= 0; --n) {
                    this.idt(n2, n, 1, 0);
                    this.idt(n2, n, 1, 1);
                    this.idt(n2, n, 0, 1);
                }
            }
            for (n2 = 0; n2 < this.w; ++n2) {
                for (n = 0; n < this.h; ++n) {
                    this.idt(n2, n, -1, 0);
                    this.idt(n2, n, -1, -1);
                    this.idt(n2, n, 0, -1);
                }
            }
        }

        private final boolean isBoundary(int n, int n2) {
            if (this.getSrcValueAt(n, n2) == 0) {
                return false;
            }
            if (n <= 0 || this.getSrcValueAt(n - 1, n2) == 0) {
                return true;
            }
            if (n >= this.w - 1 || this.getSrcValueAt(n + 1, n2) == 0) {
                return true;
            }
            if (n2 <= 0 || this.getSrcValueAt(n, n2 - 1) == 0) {
                return true;
            }
            if (n2 >= this.h - 1 || this.getSrcValueAt(n, n2 + 1) == 0) {
                return true;
            }
            if (n <= 0 || n2 <= 0 || this.getSrcValueAt(n - 1, n2 - 1) == 0) {
                return true;
            }
            if (n <= 0 || n2 >= this.h - 1 || this.getSrcValueAt(n - 1, n2 + 1) == 0) {
                return true;
            }
            if (n >= this.w - 1 || n2 <= 0 || this.getSrcValueAt(n + 1, n2 - 1) == 0) {
                return true;
            }
            return n >= this.w - 1 || n2 >= this.h - 1 || this.getSrcValueAt(n + 1, n2 + 1) == 0;
        }

        private final boolean isJustOutside(int n, int n2) {
            if (this.getSrcValueAt(n, n2) != 0) {
                return false;
            }
            if (n > 0 && this.getSrcValueAt(n - 1, n2) != 0) {
                return true;
            }
            if (n < this.w - 1 && this.getSrcValueAt(n + 1, n2) != 0) {
                return true;
            }
            if (n2 > 0 && this.getSrcValueAt(n, n2 - 1) != 0) {
                return true;
            }
            if (n2 < this.h - 1 && this.getSrcValueAt(n, n2 + 1) != 0) {
                return true;
            }
            if (n > 0 && n2 > 0 && this.getSrcValueAt(n - 1, n2 - 1) != 0) {
                return true;
            }
            if (n > 0 && n2 < this.h - 1 && this.getSrcValueAt(n - 1, n2 + 1) != 0) {
                return true;
            }
            if (n < this.w - 1 && n2 > 0 && this.getSrcValueAt(n + 1, n2 - 1) != 0) {
                return true;
            }
            return n < this.w - 1 && n2 < this.h - 1 && this.getSrcValueAt(n + 1, n2 + 1) != 0;
        }
    }
}

