/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.logic.BitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllConnectedComponents {
    public static <T extends Comparable<T>> void labelAllConnectedComponents(Labeling<T> labeling, Image<BitType> image, Iterator<T> iterator) throws NoSuchElementException {
        int[][] nArray = AllConnectedComponents.getStructuringElement(image.getNumDimensions());
        AllConnectedComponents.labelAllConnectedComponents(labeling, image, iterator, nArray);
    }

    public static <T extends Comparable<T>> void labelAllConnectedComponents(Labeling<T> labeling, Image<BitType> image, Iterator<T> iterator, int[][] nArray) throws NoSuchElementException {
        LocalizableCursor localizableCursor = image.createLocalizableCursor();
        LocalizableByDimCursor localizableByDimCursor = image.createLocalizableByDimCursor();
        LocalizableByDimCursor localizableByDimCursor2 = labeling.createLocalizableByDimCursor();
        int[] nArray2 = image.createPositionArray();
        int[] nArray3 = image.createPositionArray();
        int[] nArray4 = labeling.getDimensions();
        PositionStack positionStack = new PositionStack(image.getNumDimensions());
        for (BitType bitType : localizableCursor) {
            if (!bitType.get()) continue;
            localizableCursor.getPosition(nArray2);
            boolean bl = false;
            for (int i = 0; i < nArray4.length; ++i) {
                if (nArray2[i] < nArray4[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            localizableByDimCursor2.setPosition(nArray2);
            if (!((LabelingType)localizableByDimCursor2.getType()).getLabeling().isEmpty()) continue;
            List list = ((LabelingType)localizableByDimCursor2.getType()).intern((Comparable)iterator.next());
            ((LabelingType)localizableByDimCursor2.getType()).setLabeling(list);
            positionStack.push(nArray2);
            while (!positionStack.isEmpty()) {
                positionStack.pop(nArray2);
                for (int[] nArray5 : nArray) {
                    bl = false;
                    for (int i = 0; i < nArray5.length; ++i) {
                        nArray3[i] = nArray2[i] + nArray5[i];
                        if (nArray3[i] >= 0 && nArray3[i] < nArray4[i]) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    localizableByDimCursor.setPosition(nArray3);
                    if (!((BitType)localizableByDimCursor.getType()).get()) continue;
                    localizableByDimCursor2.setPosition(nArray3);
                    if (!((LabelingType)localizableByDimCursor2.getType()).getLabeling().isEmpty()) continue;
                    ((LabelingType)localizableByDimCursor2.getType()).setLabeling(list);
                    positionStack.push(nArray3);
                }
            }
        }
        localizableCursor.close();
        localizableByDimCursor.close();
        localizableByDimCursor2.close();
    }

    public static int[][] getStructuringElement(int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= 3;
        }
        int[][] nArray = new int[--n2][n];
        int[] nArray2 = new int[n];
        Arrays.fill(nArray2, -1);
        block1: for (int i = 0; i < n2; ++i) {
            System.arraycopy(nArray2, 0, nArray[i], 0, n);
            if (i == n2 / 2 - 1) {
                nArray2[0] = nArray2[0] + 2;
                continue;
            }
            for (int j = 0; j < n; ++j) {
                if (nArray2[j] != 1) {
                    int n3 = j;
                    nArray2[n3] = nArray2[n3] + 1;
                    continue block1;
                }
                nArray2[j] = -1;
            }
        }
        return nArray;
    }

    public static Iterator<Integer> getIntegerNames(final int n) {
        return new Iterator<Integer>(){
            int current;
            {
                this.current = n;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer next() {
                return this.current++;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected static class PositionStack {
        private final int dimensions;
        private int[] storage;
        private int position = 0;

        public PositionStack(int n) {
            this.dimensions = n;
            this.storage = new int[100 * n];
        }

        public void push(int[] nArray) {
            int n = this.position * this.dimensions;
            if (this.storage.length == n) {
                int[] nArray2 = new int[this.storage.length * 3 / 2];
                System.arraycopy(this.storage, 0, nArray2, 0, this.storage.length);
                this.storage = nArray2;
            }
            System.arraycopy(nArray, 0, this.storage, n, this.dimensions);
            ++this.position;
        }

        public void pop(int[] nArray) {
            --this.position;
            System.arraycopy(this.storage, this.position * this.dimensions, nArray, 0, this.dimensions);
        }

        public boolean isEmpty() {
            return this.position == 0;
        }
    }
}

