/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.kdtree.node.Node;
import mpicbg.imglib.algorithm.kdtree.node.NonLeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KDTree<T extends Leaf<T>> {
    protected final int medianLength;
    protected final int dimension;
    protected final Node<T> root;
    public static boolean debug = false;
    protected ArrayList<T> duplicates = new ArrayList();

    public KDTree(List<T> list) {
        this(list, 100000);
    }

    public KDTree(List<T> list, int n) {
        this.medianLength = n;
        this.dimension = ((Leaf)list.get(0)).getNumDimensions();
        int n2 = 0;
        for (Leaf leaf : list) {
            if (leaf.getNumDimensions() != this.dimension) {
                throw new RuntimeException("Dimensionality of nodes is not preserved, first entry has dimensionality " + this.dimension + " entry " + n2 + " has dimensionality " + leaf.getNumDimensions());
            }
            ++n2;
        }
        this.root = this.makeNode(list, 0);
    }

    protected Node<T> makeNode(List<T> list, int n) {
        Leaf leaf;
        int n2;
        int n3 = list.size();
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1) {
            return (Node)list.get(0);
        }
        int n4 = n % this.dimension;
        float f = this.median(list, n4);
        ArrayList<Leaf> arrayList = new ArrayList<Leaf>();
        ArrayList<Leaf> arrayList2 = new ArrayList<Leaf>();
        for (n2 = 0; n2 < n3; ++n2) {
            leaf = (Leaf)list.get(n2);
            if (leaf.get(n4) <= f) {
                arrayList.add(leaf);
                continue;
            }
            arrayList2.add(leaf);
        }
        if (arrayList2.size() == 0) {
            if (this.allIdentical(arrayList)) {
                Leaf leaf2 = (Leaf)list.get(0);
                arrayList.remove(0);
                this.duplicates.addAll(arrayList);
                return leaf2;
            }
            arrayList.clear();
            arrayList2.clear();
            for (n2 = 0; n2 < n3; ++n2) {
                leaf = (Leaf)list.get(n2);
                if (leaf.get(n4) < f) {
                    arrayList.add(leaf);
                    continue;
                }
                arrayList2.add(leaf);
            }
        }
        return new NonLeaf(f, this.dimension, this.makeNode(arrayList, n + 1), this.makeNode(arrayList2, n + 1));
    }

    protected boolean allIdentical(List<T> list) {
        Leaf leaf = null;
        for (Leaf leaf2 : list) {
            if (leaf == null) {
                leaf = leaf2;
                continue;
            }
            Leaf leaf3 = leaf2;
            for (int i = 0; i < this.dimension; ++i) {
                if (leaf3.get(i) == leaf.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public ArrayList<T> getDuplicates() {
        return this.duplicates;
    }

    public boolean hasDuplicates() {
        return this.duplicates.size() > 0;
    }

    protected float median(List<T> list, int n) {
        float[] fArray;
        if (list.size() <= this.medianLength) {
            fArray = new float[list.size()];
            for (int i = 0; i < fArray.length; ++i) {
                Leaf leaf = (Leaf)list.get(i);
                fArray[i] = leaf.get(n);
            }
        } else {
            fArray = new float[this.medianLength];
            Random random = new Random();
            for (int i = 0; i < fArray.length; ++i) {
                int n2 = Math.abs(random.nextInt()) % fArray.length;
                Leaf leaf = (Leaf)list.get(n2);
                fArray[i] = leaf.get(n);
            }
        }
        Arrays.sort(fArray);
        return (fArray.length & 1) == 1 ? fArray[fArray.length / 2] : (fArray[fArray.length / 2] + fArray[fArray.length / 2 - 1]) / 2.0f;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String toString(Node<T> node, String string) {
        if (node == null) {
            return string + "null";
        }
        if (Leaf.class.isInstance(node)) {
            return string + node.toString();
        }
        NonLeaf nonLeaf = (NonLeaf)node;
        return this.toString(nonLeaf.left, string + "\t") + "\n" + string + nonLeaf.coordinate + "\n" + this.toString(nonLeaf.right, string + "\t") + "\n";
    }

    public String toString() {
        return this.toString(this.root, "");
    }
}

