/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.histogram.arbitrary;

import mpicbg.imglib.algorithm.histogram.HistogramBin;
import mpicbg.imglib.algorithm.histogram.HistogramBinFactory;
import mpicbg.imglib.algorithm.histogram.HistogramKey;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealHistogramBinFactory<T extends RealType<T>>
implements HistogramBinFactory<T> {
    private final double width;
    private final double offset;

    public RealHistogramBinFactory(double d, double d2) {
        this.width = d;
        this.offset = d2;
    }

    private double mapToCenter(double d) {
        double d2 = Math.floor((d - this.offset) / this.width) + 0.5;
        return d2 * this.width + this.offset;
    }

    private T centerType(T t) {
        double d = this.mapToCenter(t.getRealDouble());
        RealType realType = (RealType)t.createVariable();
        realType.setReal(d);
        return (T)realType;
    }

    @Override
    public HistogramBin<T> createBin(T t) {
        T t2 = this.centerType(t);
        return new RealHistogramBin(this, t2, this.createKey(t2));
    }

    @Override
    public HistogramKey<T> createKey(T t) {
        T t2 = this.centerType(t);
        int n = new Double(t2.getRealDouble()).hashCode();
        HistogramKey<T> histogramKey = new HistogramKey<T>(n, t2, this);
        return histogramKey;
    }

    @Override
    public boolean equivalent(T t, T t2) {
        return this.mapToCenter(t.getRealDouble()) == this.mapToCenter(t2.getRealDouble());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RealHistogramBin
    extends HistogramBin<T> {
        final /* synthetic */ RealHistogramBinFactory this$0;

        public RealHistogramBin(T t, HistogramKey<T> histogramKey) {
            this.this$0 = var1_1;
            super(t, histogramKey);
        }

        @Override
        public T getLowerBound() {
            RealType realType = (RealType)((RealType)this.getCenter()).createVariable();
            realType.setReal(((RealType)this.getCenter()).getRealDouble() - this.this$0.width / 2.0);
            return realType;
        }

        @Override
        public T getUpperBound() {
            RealType realType = (RealType)((RealType)this.getCenter()).createVariable();
            realType.setReal(((RealType)this.getCenter()).getRealDouble() - this.this$0.width / 2.0);
            return realType;
        }

        @Override
        public double getNorm() {
            return this.this$0.width;
        }
    }
}

