/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.histogram;

import java.util.ArrayList;
import java.util.Hashtable;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.histogram.HistogramBin;
import mpicbg.imglib.algorithm.histogram.HistogramBinFactory;
import mpicbg.imglib.algorithm.histogram.HistogramKey;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram<T extends Type<T>>
implements Algorithm,
Benchmark {
    private long pTime = 0L;
    private Hashtable<HistogramKey<T>, HistogramBin<T>> hashTable;
    private Cursor<T> cursor;
    private final HistogramBinFactory<T> binFactory;

    public Histogram(HistogramBinFactory<T> histogramBinFactory, Cursor<T> cursor) {
        this.cursor = cursor;
        this.hashTable = new Hashtable();
        this.binFactory = histogramBinFactory;
    }

    public ArrayList<HistogramKey<T>> getKeys() {
        return new ArrayList<HistogramKey<T>>(this.hashTable.keySet());
    }

    public ArrayList<T> getKeyTypes() {
        ArrayList<HistogramKey<T>> arrayList = this.getKeys();
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        for (HistogramKey<T> histogramKey : arrayList) {
            arrayList2.add(histogramKey.getType());
        }
        return arrayList2;
    }

    public HistogramBin<T> getBin(T t) {
        return this.getBin(this.binFactory.createKey(t));
    }

    public HistogramBin<T> getBin(HistogramKey<T> histogramKey) {
        if (this.hashTable.containsKey(histogramKey)) {
            return this.hashTable.get(histogramKey);
        }
        HistogramBin<T> histogramBin = this.binFactory.createBin(histogramKey.getType());
        return histogramBin;
    }

    public boolean checkInput() {
        return true;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean process() {
        long l = System.currentTimeMillis();
        while (this.cursor.hasNext()) {
            this.cursor.fwd();
            HistogramKey<Type> histogramKey = this.binFactory.createKey(this.cursor.getType());
            HistogramBin<Object> histogramBin = this.hashTable.get(histogramKey);
            if (histogramBin == null) {
                histogramBin = this.binFactory.createBin(histogramKey.getType());
                this.hashTable.put(histogramKey, histogramBin);
            }
            histogramBin.inc();
        }
        this.pTime = System.currentTimeMillis() - l;
        return true;
    }

    public long getProcessingTime() {
        return this.pTime;
    }
}

